/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.ui.LearningUiHighlightingManager;
import training.ui.RepaintHighlighting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J*\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0014H\u0002J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u0016J,\u0010\u0017\u001a\u00020\f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0014J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u0014J=\u0010!\u001a\u00020\f\"\b\b\u0000\u0010\"*\u00020\u00052\u0006\u0010#\u001a\u0002H\"2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u0002H\"\u0012\u0006\u0012\u0004\u0018\u00010\u000e0%\u00a2\u0006\u0002\u0010&J\u0019\u0010'\u001a\u00020\f2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\nH\u0000\u00a2\u0006\u0002\b)R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ltraining/ui/LearningUiHighlightingManager;", "", "()V", "highlightingComponents", "", "Ljava/awt/Component;", "getHighlightingComponents", "()Ljava/util/List;", "highlights", "", "Ltraining/ui/RepaintHighlighting;", "clearHighlights", "", "getRectangle", "Ljava/awt/Rectangle;", "original", "highlightComponent", "clearPreviousHighlights", "", "init", "Lkotlin/Function0;", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "highlightJListItem", "list", "Ljavax/swing/JList;", "index", "", "highlightJTreeItem", "tree", "Ljavax/swing/JTree;", "path", "Ljavax/swing/tree/TreePath;", "highlightPartOfComponent", "T", "component", "rectangle", "Lkotlin/Function1;", "(Ljava/awt/Component;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;Lkotlin/jvm/functions/Function1;)V", "removeIt", "core", "removeIt$intellij_featuresTrainer", "HighlightingOptions", "intellij.featuresTrainer"})
public final class LearningUiHighlightingManager {
    private static final List<RepaintHighlighting<?>> highlights;
    @NotNull
    public static final LearningUiHighlightingManager INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> getHighlightingComponents() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = highlights;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RepaintHighlighting repaintHighlighting = (RepaintHighlighting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.getOriginal();
            collection.add(t);
        }
        return (List)destination$iv$iv;
    }

    public final void highlightComponent(@NotNull Component original, @NotNull HighlightingOptions options) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.highlightPartOfComponent(original, options, highlightComponent.1.INSTANCE);
    }

    public static /* synthetic */ void highlightComponent$default(LearningUiHighlightingManager learningUiHighlightingManager, Component component2, HighlightingOptions highlightingOptions, int n, Object object) {
        if ((n & 2) != 0) {
            highlightingOptions = new HighlightingOptions(false, false, false, false, 15, null);
        }
        learningUiHighlightingManager.highlightComponent(component2, highlightingOptions);
    }

    public final void highlightJListItem(@NotNull JList<?> list2, @NotNull HighlightingOptions options, @NotNull Function0<Integer> index) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(index, (String)"index");
        this.highlightPartOfComponent((Component)list2, options, (Function1)new Function1<JList<?>, Rectangle>(index, list2){
            final /* synthetic */ Function0 $index;
            final /* synthetic */ JList $list;

            @Nullable
            public final Rectangle invoke(@NotNull JList<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Integer n = (Integer)this.$index.invoke();
                if (n == null) {
                    return null;
                }
                int i2 = n;
                Rectangle itemRect = this.$list.getCellBounds(i2, i2);
                Rectangle listRect = this.$list.getVisibleRect();
                if (itemRect.y >= listRect.y + listRect.height || itemRect.y + itemRect.height <= listRect.y) {
                    return null;
                }
                int n2 = itemRect.y;
                int n3 = listRect.y;
                int n4 = 0;
                int adjustedY = Math.max(n2, n3);
                n3 = itemRect.height;
                n4 = itemRect.y + itemRect.height - listRect.y;
                int n5 = listRect.y + listRect.height - itemRect.y;
                boolean bl = false;
                n4 = Math.min(n4, n5);
                n5 = 0;
                int adjustedHeight = Math.min(n3, n4);
                return new Rectangle(itemRect.x, adjustedY, itemRect.width, adjustedHeight);
            }
            {
                this.$index = function0;
                this.$list = jList2;
                super(1);
            }
        });
    }

    public static /* synthetic */ void highlightJListItem$default(LearningUiHighlightingManager learningUiHighlightingManager, JList jList2, HighlightingOptions highlightingOptions, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            highlightingOptions = new HighlightingOptions(false, false, false, false, 15, null);
        }
        learningUiHighlightingManager.highlightJListItem(jList2, highlightingOptions, (Function0<Integer>)function0);
    }

    public final void highlightJTreeItem(@NotNull JTree tree2, @NotNull HighlightingOptions options, @NotNull Function0<? extends TreePath> path) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        this.highlightPartOfComponent((Component)tree2, options, (Function1)new Function1<JTree, Rectangle>(path, tree2){
            final /* synthetic */ Function0 $path;
            final /* synthetic */ JTree $tree;

            @Nullable
            public final Rectangle invoke(@NotNull JTree it) {
                Rectangle rectangle;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TreePath treePath = (TreePath)this.$path.invoke();
                if (treePath != null) {
                    TreePath treePath2 = treePath;
                    boolean bl = false;
                    boolean bl2 = false;
                    TreePath it2 = treePath2;
                    boolean bl3 = false;
                    Rectangle treeRect = this.$tree.getVisibleRect();
                    Rectangle rectangle2 = this.$tree.getPathBounds(it2);
                    if (rectangle2 == null) {
                        rectangle = null;
                    } else {
                        Rectangle pathRect = rectangle2;
                        int offset = pathRect.x - treeRect.x;
                        int n = treeRect.width - offset;
                        int n2 = pathRect.width;
                        boolean bl4 = false;
                        int width = Math.min(n, n2);
                        rectangle = new Rectangle(pathRect.x, pathRect.y, width, pathRect.height);
                    }
                } else {
                    rectangle = null;
                }
                return rectangle;
            }
            {
                this.$path = function0;
                this.$tree = jTree;
                super(1);
            }
        });
    }

    public static /* synthetic */ void highlightJTreeItem$default(LearningUiHighlightingManager learningUiHighlightingManager, JTree jTree, HighlightingOptions highlightingOptions, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            highlightingOptions = new HighlightingOptions(false, false, false, false, 15, null);
        }
        learningUiHighlightingManager.highlightJTreeItem(jTree, highlightingOptions, (Function0<? extends TreePath>)function0);
    }

    public final <T extends Component> void highlightPartOfComponent(@NotNull T component2, @NotNull HighlightingOptions options, @NotNull Function1<? super T, ? extends Rectangle> rectangle) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(rectangle, (String)"rectangle");
        this.highlightComponent(component2, options.getClearPreviousHighlights(), (Function0)new Function0<RepaintHighlighting<?>>(component2, options, rectangle){
            final /* synthetic */ Component $component;
            final /* synthetic */ HighlightingOptions $options;
            final /* synthetic */ Function1 $rectangle;

            @NotNull
            public final RepaintHighlighting<?> invoke() {
                return new RepaintHighlighting<Component>(this.$component, this.$options, (Function0<? extends Rectangle>)((Function0)new Function0<Rectangle>(this){
                    final /* synthetic */ highlightPartOfComponent.1 this$0;

                    @Nullable
                    public final Rectangle invoke() {
                        return (Rectangle)this.this$0.$rectangle.invoke((Object)this.this$0.$component);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$component = component2;
                this.$options = highlightingOptions;
                this.$rectangle = function1;
                super(0);
            }
        });
    }

    public static /* synthetic */ void highlightPartOfComponent$default(LearningUiHighlightingManager learningUiHighlightingManager, Component component2, HighlightingOptions highlightingOptions, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            highlightingOptions = new HighlightingOptions(false, false, false, false, 15, null);
        }
        learningUiHighlightingManager.highlightPartOfComponent(component2, highlightingOptions, function1);
    }

    public final void clearHighlights() {
        Application app$iv;
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            for (RepaintHighlighting core : LearningUiHighlightingManager.access$getHighlights$p(INSTANCE)) {
                INSTANCE.removeIt$intellij_featuresTrainer(core);
            }
            LearningUiHighlightingManager.access$getHighlights$p(INSTANCE).clear();
        } else {
            boolean $i$f$invokeLater = false;
            Application application2 = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(){

                public final void run() {
                    boolean bl = false;
                    for (RepaintHighlighting core : LearningUiHighlightingManager.access$getHighlights$p(LearningUiHighlightingManager.INSTANCE)) {
                        LearningUiHighlightingManager.INSTANCE.removeIt$intellij_featuresTrainer(core);
                    }
                    LearningUiHighlightingManager.access$getHighlights$p(LearningUiHighlightingManager.INSTANCE).clear();
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application2.invokeLater(runnable, modalityState);
        }
    }

    private final void highlightComponent(Component original, boolean clearPreviousHighlights, Function0<? extends RepaintHighlighting<?>> init) {
        Application app$iv;
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            if (clearPreviousHighlights) {
                INSTANCE.clearHighlights();
            }
            if (original.isShowing()) {
                RepaintHighlighting repaintByTimer = (RepaintHighlighting)init.invoke();
                repaintByTimer.reinitHighlightComponent();
                repaintByTimer.initTimer();
                LearningUiHighlightingManager.access$getHighlights$p(INSTANCE).add(repaintByTimer);
            }
        } else {
            boolean $i$f$invokeLater = false;
            Application application2 = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(clearPreviousHighlights, original, init){
                final /* synthetic */ boolean $clearPreviousHighlights$inlined;
                final /* synthetic */ Component $original$inlined;
                final /* synthetic */ Function0 $init$inlined;
                {
                    this.$clearPreviousHighlights$inlined = bl;
                    this.$original$inlined = component2;
                    this.$init$inlined = function0;
                }

                public final void run() {
                    boolean bl = false;
                    if (this.$clearPreviousHighlights$inlined) {
                        LearningUiHighlightingManager.INSTANCE.clearHighlights();
                    }
                    if (this.$original$inlined.isShowing()) {
                        RepaintHighlighting repaintByTimer = (RepaintHighlighting)this.$init$inlined.invoke();
                        repaintByTimer.reinitHighlightComponent();
                        repaintByTimer.initTimer();
                        LearningUiHighlightingManager.access$getHighlights$p(LearningUiHighlightingManager.INSTANCE).add(repaintByTimer);
                    }
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application2.invokeLater(runnable, modalityState);
        }
    }

    public final void removeIt$intellij_featuresTrainer(@NotNull RepaintHighlighting<?> core) {
        Intrinsics.checkNotNullParameter(core, (String)"core");
        core.setRemoved(true);
        core.cleanup();
    }

    @Nullable
    public final Rectangle getRectangle(@NotNull Component original) {
        Function0<Rectangle> function0;
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Iterable iterable = highlights;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                RepaintHighlighting it = (RepaintHighlighting)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getOriginal(), (Object)original)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return (function0 = (Function0<Rectangle>)v0) != null && (function0 = function0.getRectangle()) != null ? (Rectangle)function0.invoke() : null;
    }

    private LearningUiHighlightingManager() {
    }

    static {
        LearningUiHighlightingManager learningUiHighlightingManager;
        INSTANCE = learningUiHighlightingManager = new LearningUiHighlightingManager();
        highlights = new ArrayList();
    }

    public static final /* synthetic */ List access$getHighlights$p(LearningUiHighlightingManager $this) {
        LearningUiHighlightingManager learningUiHighlightingManager = $this;
        return highlights;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "", "highlightBorder", "", "highlightInside", "usePulsation", "clearPreviousHighlights", "(ZZZZ)V", "getClearPreviousHighlights", "()Z", "getHighlightBorder", "getHighlightInside", "getUsePulsation", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.featuresTrainer"})
    public static final class HighlightingOptions {
        private final boolean highlightBorder;
        private final boolean highlightInside;
        private final boolean usePulsation;
        private final boolean clearPreviousHighlights;

        public final boolean getHighlightBorder() {
            return this.highlightBorder;
        }

        public final boolean getHighlightInside() {
            return this.highlightInside;
        }

        public final boolean getUsePulsation() {
            return this.usePulsation;
        }

        public final boolean getClearPreviousHighlights() {
            return this.clearPreviousHighlights;
        }

        public HighlightingOptions(boolean highlightBorder, boolean highlightInside, boolean usePulsation, boolean clearPreviousHighlights) {
            this.highlightBorder = highlightBorder;
            this.highlightInside = highlightInside;
            this.usePulsation = usePulsation;
            this.clearPreviousHighlights = clearPreviousHighlights;
        }

        public /* synthetic */ HighlightingOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                bl4 = true;
            }
            this(bl, bl2, bl3, bl4);
        }

        public HighlightingOptions() {
            this(false, false, false, false, 15, null);
        }

        public final boolean component1() {
            return this.highlightBorder;
        }

        public final boolean component2() {
            return this.highlightInside;
        }

        public final boolean component3() {
            return this.usePulsation;
        }

        public final boolean component4() {
            return this.clearPreviousHighlights;
        }

        @NotNull
        public final HighlightingOptions copy(boolean highlightBorder, boolean highlightInside, boolean usePulsation, boolean clearPreviousHighlights) {
            return new HighlightingOptions(highlightBorder, highlightInside, usePulsation, clearPreviousHighlights);
        }

        public static /* synthetic */ HighlightingOptions copy$default(HighlightingOptions highlightingOptions, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = highlightingOptions.highlightBorder;
            }
            if ((n & 2) != 0) {
                bl2 = highlightingOptions.highlightInside;
            }
            if ((n & 4) != 0) {
                bl3 = highlightingOptions.usePulsation;
            }
            if ((n & 8) != 0) {
                bl4 = highlightingOptions.clearPreviousHighlights;
            }
            return highlightingOptions.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "HighlightingOptions(highlightBorder=" + this.highlightBorder + ", highlightInside=" + this.highlightInside + ", usePulsation=" + this.usePulsation + ", clearPreviousHighlights=" + this.clearPreviousHighlights + ")";
        }

        public int hashCode() {
            int n = this.highlightBorder ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.highlightInside ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            int n4 = (n2 + n3) * 31;
            int n5 = this.usePulsation ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            int n6 = (n4 + n5) * 31;
            int n7 = this.clearPreviousHighlights ? 1 : 0;
            if (n7 != 0) {
                n7 = 1;
            }
            return n6 + n7;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HighlightingOptions)) break block3;
                    HighlightingOptions highlightingOptions = (HighlightingOptions)object;
                    if (this.highlightBorder != highlightingOptions.highlightBorder || this.highlightInside != highlightingOptions.highlightInside || this.usePulsation != highlightingOptions.usePulsation || this.clearPreviousHighlights != highlightingOptions.clearPreviousHighlights) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

