/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.list;

import circlet.code.api.CodeReviewRecord;
import circlet.platform.api.Ref;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.review.SpaceReviewDataKeys;
import com.intellij.space.vcs.review.SpaceReviewTabController;
import com.intellij.space.vcs.review.UtilsKt;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/space/vcs/review/list/SpaceOpenCodeReviewDetailsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "logOpenReview", "intellij.space"})
final class SpaceOpenCodeReviewDetailsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Ref ref = (Ref)e.getData(SpaceReviewDataKeys.getSELECTED_REVIEW_IN_LIST$intellij_space());
        if (ref == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"e.getData(SpaceReviewDat\u2026REVIEW_IN_LIST) ?: return");
        Ref selectedReviewRecordRef = ref;
        SpaceReviewTabController spaceReviewTabController = (SpaceReviewTabController)e.getData(SpaceReviewDataKeys.getREVIEW_TAB_CONTROLLER$intellij_space());
        if (spaceReviewTabController == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)spaceReviewTabController, (String)"e.getData(SpaceReviewDat\u2026TAB_CONTROLLER) ?: return");
        SpaceReviewTabController reviewTabController = spaceReviewTabController;
        this.logOpenReview(e);
        reviewTabController.openReviewDetails((Ref<? extends CodeReviewRecord>)selectedReviewRecordRef);
        UtilsKt.openReviewInEditor(project2, reviewTabController.getWorkspace(), reviewTabController.getSpaceProjectInfo(), (Ref<? extends CodeReviewRecord>)selectedReviewRecordRef);
    }

    private final void logOpenReview(AnActionEvent e) {
        InputEvent inputEvent = e.getInputEvent();
        SpaceStatsCounterCollector.OpenReviewActionType openReviewType = inputEvent instanceof MouseEvent ? (((MouseEvent)inputEvent).getClickCount() == 1 ? SpaceStatsCounterCollector.OpenReviewActionType.ARROW : SpaceStatsCounterCollector.OpenReviewActionType.DOUBLE_CLICK) : SpaceStatsCounterCollector.OpenReviewActionType.ENTER;
        SpaceStatsCounterCollector.OPEN_REVIEW.log((Object)openReviewType);
    }

    public SpaceOpenCodeReviewDetailsAction() {
        super(SpaceBundle.messagePointer("action.open.review.details.text", new Object[0]));
    }
}

