/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.share;

import circlet.client.api.PR_RepositoryInfo;
import circlet.client.api.RepoDetails;
import circlet.client.api.TD_MemberProfile;
import circlet.workspaces.Workspace;
import com.intellij.CommonBundle;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.actions.SpaceActionUtils;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.settings.SpaceLoginState;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.utils.SpaceUrls;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.share.SpaceShareProjectAction$WhenMappings;
import com.intellij.space.vcs.share.SpaceShareProjectDialog;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SpreadBuilder;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import libraries.klogging.BaseLogger;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u001b\u001a\u00020\u000bH\u0002J8\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J@\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J:\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170(H\u0002J\"\u0010)\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010\u00172\u0006\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/space/vcs/share/SpaceShareProjectAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "git", "Lgit4idea/commands/Git;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addRemoteUrl", "Lkotlin/Pair;", "", "repoDetails", "Lcirclet/client/api/RepoDetails;", "gitRepo", "Lgit4idea/repo/GitRepository;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createEmptyGitRepository", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "createSpaceProject", "Lcom/intellij/space/vcs/share/SpaceShareProjectDialog$Result;", "notifyError", "message", "performFirstCommitIfRequired", "repository", "name", "url", "pushCurrentBranch", "remoteName", "remoteUrl", "selectFilesToCommit", "", "allFiles", "", "preselectedFiles", "", "shareProjectOnSpace", "file", "details", "Lcom/intellij/space/vcs/share/SpaceShareProjectDialog$Result$ProjectCreated;", "showInitialPushNotPerformedNotification", "repoName", "update", "Companion", "intellij.space"})
final class SpaceShareProjectAction
extends DumbAwareAction {
    private final Git git;
    private static final KLogger LOG;
    @NotNull
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SpaceActionUtils.INSTANCE.showIconInActionSearch(e);
        Project project = e.getProject();
        if (project == null || project.isDefault() || !TrustedProjects.isTrusted((Project)project)) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        SpaceProjectContext context2 = SpaceProjectContext.Companion.getInstance(project);
        if (context2.getCurrentContext().isAssociatedWithSpaceRepository()) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDefault() || project.isDisposed()) {
            return;
        }
        SpaceStatsCounterCollector.OPEN_SHARE_PROJECT.log((Object)SpaceStatsCounterCollector.LoginState.Companion.convert((SpaceLoginState)SpaceWorkspaceComponent.Companion.getInstance().getLoginState().getValue()));
        ApplicationManager.getApplication().invokeLater(new Runnable(this, project, file){
            final /* synthetic */ SpaceShareProjectAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                Lifetime $this$using$iv = SpaceWorkspaceComponent.Companion.getInstance().getLifetime();
                boolean $i$f$using = false;
                LifetimeSource lt$iv = LifetimeUtilsKt.nested((Lifetime)$this$using$iv);
                try {
                    Lifetime lt = (Lifetime)lt$iv;
                    boolean bl = false;
                    SpaceShareProjectDialog.Result creationResult = SpaceShareProjectAction.access$createSpaceProject(this.this$0, this.$project);
                    if (creationResult instanceof SpaceShareProjectDialog.Result.ProjectCreated) {
                        SpaceShareProjectAction.access$shareProjectOnSpace(this.this$0, this.$project, this.$file, (SpaceShareProjectDialog.Result.ProjectCreated)creationResult);
                    } else if (Intrinsics.areEqual((Object)creationResult, (Object)SpaceShareProjectDialog.Result.NotCreated.INSTANCE)) {
                        String string = SpaceBundle.message("share.project.error.notification.repository.not.created", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpaceBundle.message(\"sha\u2026.repository.not.created\")");
                        SpaceShareProjectAction.access$notifyError(this.this$0, this.$project, string);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lt$iv.terminate();
                }
            }
            {
                this.this$0 = spaceShareProjectAction;
                this.$project = project;
                this.$file = virtualFile;
            }
        }, ModalityState.NON_MODAL);
    }

    /*
     * WARNING - void declaration
     */
    private final void shareProjectOnSpace(Project project, VirtualFile file, SpaceShareProjectDialog.Result.ProjectCreated details) {
        void repoInfo2;
        void repoDetails;
        SpaceShareProjectDialog.Result.ProjectCreated projectCreated = details;
        PR_RepositoryInfo pR_RepositoryInfo = projectCreated.component1();
        RepoDetails repoDetails2 = projectCreated.component2();
        String url = projectCreated.component3();
        new Task.Backgroundable(this, file, project, (RepoDetails)repoDetails, (PR_RepositoryInfo)repoInfo2, url, project, SpaceBundle.message("share.project.action.progress.title.sharing.title", new Object[0])){
            final /* synthetic */ SpaceShareProjectAction this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ RepoDetails $repoDetails;
            final /* synthetic */ PR_RepositoryInfo $repoInfo;
            final /* synthetic */ String $url;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void remoteUrl;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(SpaceBundle.message("share.project.action.progress.title.searching.repository.title", new Object[0]));
                Repository repository2 = this.$file != null ? VcsRepositoryManager.getInstance((Project)this.$project).getRepositoryForFile(this.$file, false) : VcsRepositoryManager.getInstance((Project)this.$project).getRepositoryForFile(this.$project.getBaseDir(), false);
                SpaceShareProjectAction.access$getLOG$cp().info((Object)("Found repository: " + repository2));
                Repository repository3 = repository2;
                if (repository3 == null || (repository3 = repository3.getRoot()) == null) {
                    repository3 = ProjectUtil.guessProjectDir((Project)this.$project);
                }
                if (repository3 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)repository3, (String)"repository?.root ?: proj\u2026essProjectDir() ?: return");
                Repository root = repository3;
                SpaceShareProjectAction.access$getLOG$cp().info((Object)("Found project root: " + root));
                if (repository2 == null) {
                    KLogger this_$iv = SpaceShareProjectAction.access$getLOG$cp();
                    boolean $i$f$info = false;
                    if (this_$iv.isInfoEnabled()) {
                        KLogger kLogger = this_$iv;
                        boolean bl = false;
                        String string = "No git repo detected, creating empty git repository";
                        kLogger.info((Object)string);
                    }
                    if (!SpaceShareProjectAction.access$createEmptyGitRepository(this.this$0, this.$project, (VirtualFile)root, indicator)) {
                        SpaceShareProjectAction.access$getLOG$cp().error((Object)"Unable to init git repository");
                        return;
                    }
                }
                GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"GitUtil.getRepositoryManager(project)");
                GitRepositoryManager gitRepoManager = gitRepositoryManager;
                GitRepository gitRepository = (GitRepository)gitRepoManager.getRepositoryForRoot((VirtualFile)root);
                if (gitRepository == null) {
                    throw (Throwable)new Exception("Can't find Git repository");
                }
                Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"gitRepoManager.getReposi\u2026n't find Git repository\")");
                GitRepository gitRepo = gitRepository;
                Git git = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)git, (String)"Git.getInstance()");
                Git git2 = git;
                Pair pair = SpaceShareProjectAction.access$addRemoteUrl(this.this$0, this.$repoDetails, git2, gitRepo, indicator);
                String string = (String)pair.component1();
                String remoteName = (String)pair.component2();
                String repoName = this.$repoInfo.getName();
                if (!SpaceShareProjectAction.access$performFirstCommitIfRequired(this.this$0, this.$project, (VirtualFile)root, gitRepo, indicator, repoName, this.$url)) {
                    SpaceShareProjectAction.access$getLOG$cp().info((Object)"Commit not finished");
                    return;
                }
                if (!SpaceShareProjectAction.access$pushCurrentBranch(this.this$0, this.$project, gitRepo, remoteName, (String)remoteUrl, repoName, this.$url, indicator)) {
                    SpaceShareProjectAction.access$getLOG$cp().info((Object)"Push not finished");
                    return;
                }
                VcsNotifier.getInstance((Project)this.$project).notifySuccess("space.project.shared.successfully", SpaceBundle.message("share.project.success.notification.title", new Object[0]), XmlStringUtil.formatLink((String)this.$url, (String)repoName), NotificationListener.URL_OPENING_LISTENER);
            }
            {
                this.this$0 = this$0;
                this.$file = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$repoDetails = $captured_local_variable$3;
                this.$repoInfo = $captured_local_variable$4;
                this.$url = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7);
            }
        }.queue();
    }

    private final void showInitialPushNotPerformedNotification(Project project, String url, String repoName) {
        String string = SpaceBundle.message("share.project.error.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SpaceBundle.message(\"sha\u2026rror.notification.title\")");
        String string2 = SpaceBundle.message("share.project.error.notification.not.pushed.git.access", XmlStringUtil.formatLink((String)url, (String)repoName));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceBundle.message(\"sha\u2026ormatLink(url, repoName))");
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(string, string2, NotificationType.ERROR).setListener(NotificationListener.URL_OPENING_LISTENER).setDisplayId("space.sharing.not.finished");
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"VcsNotifier.IMPORTANT_ER\u2026yId(SHARING_NOT_FINISHED)");
        Notification notification2 = notification;
        Workspace workspace2 = (Workspace)SpaceWorkspaceComponent.Companion.getInstance().getWorkspace().getValue();
        if (workspace2 != null) {
            notification2.addAction((AnAction)NotificationAction.create((String)SpaceBundle.message("share.project.error.notification.action.configure.text", new Object[0]), (Consumer)new Consumer(workspace2){
                final /* synthetic */ Workspace $workspace;

                public final void consume(AnActionEvent it) {
                    String gitAccessConfigurationPageUrl = SpaceUrls.INSTANCE.git(((TD_MemberProfile)this.$workspace.getMe().getValue()).getUsername());
                    BrowserUtil.browse((String)gitAccessConfigurationPageUrl);
                }
                {
                    this.$workspace = workspace2;
                }
            }));
        }
        VcsNotifier.getInstance((Project)project).notify(notification2);
    }

    private final SpaceShareProjectDialog.Result createSpaceProject(Project project) {
        LOG.info((Object)"Creating repository on Space");
        SpaceShareProjectDialog shareProjectDialog = new SpaceShareProjectDialog(project);
        if (shareProjectDialog.showAndGet()) {
            SpaceShareProjectDialog.Result result2 = shareProjectDialog.getResult$intellij_space();
            if (result2 == null) {
                LOG.info((Object)"Repository not created");
                return SpaceShareProjectDialog.Result.NotCreated.INSTANCE;
            }
            LOG.info((Object)("Repository created successfully: " + result2));
            return result2;
        }
        return SpaceShareProjectDialog.Result.Canceled.INSTANCE;
    }

    private final boolean createEmptyGitRepository(Project project, VirtualFile root, ProgressIndicator indicator) {
        indicator.setText(SpaceBundle.message("share.project.action.progress.title.initializing.repository.title", new Object[0]));
        GitCommandResult gitCommandResult = Git.getInstance().init(project, root, new GitLineHandlerListener[0]);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"Git.getInstance().init(project, root)");
        GitCommandResult result2 = gitCommandResult;
        if (!result2.success()) {
            VcsNotifier.getInstance((Project)project).notifyError("space.git.repo.init.error", GitBundle.message((String)"initializing.title", (Object[])new Object[0]), result2.getErrorOutputAsHtmlString());
            KLogger this_$iv = LOG;
            boolean $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Failed to create empty git repo: " + result2.getErrorOutputAsJoinedString();
                kLogger.info((Object)string);
            }
            return false;
        }
        GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
        GitUtil.generateGitignoreFileIfNeeded((Project)project, (VirtualFile)root);
        return true;
    }

    private final Pair<String, String> addRemoteUrl(RepoDetails repoDetails, Git git, GitRepository gitRepo, ProgressIndicator indicator) {
        String string;
        switch (SpaceShareProjectAction$WhenMappings.$EnumSwitchMapping$0[SpaceSettings.Companion.getInstance().getCloneType().ordinal()]) {
            case 1: {
                string = repoDetails.getUrls().getHttpUrl();
                break;
            }
            case 2: {
                string = repoDetails.getUrls().getSshUrl();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String remoteUrl = string;
        String remoteName = "space";
        indicator.setText(SpaceBundle.message("share.project.action.progress.title.adding.remote.title", new Object[0]));
        GitCommandResult gitCommandResult = git.addRemote(gitRepo, remoteName, remoteUrl);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"git.addRemote(gitRepo, remoteName, remoteUrl)");
        GitCommandResult commandResult = gitCommandResult;
        if (commandResult.success()) {
            gitRepo.update();
        } else {
            KLogger this_$iv = LOG;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string2 = commandResult.getErrorOutputAsJoinedString();
                kLogger.error((Object)string2);
            }
        }
        return new Pair((Object)remoteUrl, (Object)remoteName);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean performFirstCommitIfRequired(Project project, VirtualFile root, GitRepository repository2, ProgressIndicator indicator, String name, String url) {
        if (!repository2.isFresh()) {
            return true;
        }
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            LOG.info((Object)"Adding files for commit");
            indicator.setText(SpaceBundle.message("share.project.action.progress.title.adding.files.title", new Object[0]));
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
            ChangeListManager changeListManager2 = changeListManager;
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            Collection collection = repository2.getUntrackedFilesHolder().retrieveUntrackedFilePaths();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.untrackedFile\u2026rieveUntrackedFilePaths()");
            Iterable iterable = collection;
            boolean $i$f$mapNotNull = false;
            void var12_14 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile virtualFile;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                FilePath p1 = (FilePath)element$iv$iv;
                boolean bl2 = false;
                if (p1.getVirtualFile() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                VirtualFile it$iv$iv = virtualFile;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile file = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(!vcsManager.isIgnored(file) && !changeListManager2.isIgnoredFile(file))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List untrackedFiles = (List)destination$iv$iv;
            List list2 = changeListManager2.getAffectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"changeListManager.affectedFiles");
            List trackedFiles = list2;
            trackedFiles.removeAll(untrackedFiles);
            List allFiles = CollectionsKt.plus((Collection)trackedFiles, (Iterable)untrackedFiles);
            Collection<VirtualFile> filesToCommit = this.selectFilesToCommit(project, indicator, allFiles, trackedFiles);
            if (filesToCommit.isEmpty()) {
                return false;
            }
            Collection collection2 = ContainerUtil.intersection((Collection)untrackedFiles, filesToCommit);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ContainerUtil.intersecti\u2026ckedFiles, filesToCommit)");
            Collection filesToAdd = collection2;
            Collection collection3 = ContainerUtil.subtract((Collection)trackedFiles, filesToCommit);
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"ContainerUtil.subtract(t\u2026ckedFiles, filesToCommit)");
            Collection filesToDelete = collection3;
            HashSet affectedFiles = new HashSet(CollectionsKt.plus((Collection)trackedFiles, (Iterable)filesToCommit));
            GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)filesToAdd);
            GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)filesToDelete);
            LOG.info((Object)"Performing commit");
            indicator.setText(SpaceBundle.message("share.project.action.progress.title.committing.title", new Object[0]));
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{"-m", "Initial commit"});
            handler.endOptions();
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
            VcsFileUtil.markFilesDirty((Project)project, (Collection)affectedFiles);
        }
        catch (VcsException e) {
            BaseLogger.DefaultImpls.warn$default((BaseLogger)((BaseLogger)LOG), (Throwable)e, null, (int)2, null);
            String string = XmlStringUtil.formatLink((String)url, (String)('\'' + name + '\''));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatLink(url, \"'$name'\")");
            String repositoryLink = string;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)SpaceBundle.message("share.project.error.notification.initial.commit.failed.message", repositoryLink));
            spreadBuilder.addSpread((Object)e.getMessages());
            String string2 = XmlStringUtil.wrapInHtmlLines((CharSequence[])((CharSequence[])spreadBuilder.toArray((Object[])new CharSequence[spreadBuilder.size()])));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wrapInHtmlLines( // NON-\u2026      *e.messages\n      )");
            this.notifyError(project, string2);
            return false;
        }
        LOG.info((Object)"Successfully created initial commit");
        return true;
    }

    private final Collection<VirtualFile> selectFilesToCommit(Project project, ProgressIndicator indicator, List<? extends VirtualFile> allFiles, List<VirtualFile> preselectedFiles) {
        SelectFilesDialog dialog2 = (SelectFilesDialog)ActionsKt.invokeAndWaitIfNeeded((ModalityState)indicator.getModalityState(), (Function0)((Function0)new Function0<SelectFilesDialog>(project, allFiles, preselectedFiles){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $allFiles;
            final /* synthetic */ List $preselectedFiles;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SelectFilesDialog invoke() {
                void var1_1;
                SelectFilesDialog selectFilesDialog = SelectFilesDialog.init((Project)this.$project, (List)this.$allFiles, null, null, (boolean)true, (boolean)false, (String)CommonBundle.getAddButtonText(), (String)CommonBundle.getCancelButtonText());
                Intrinsics.checkNotNullExpressionValue((Object)selectFilesDialog, (String)"SelectFilesDialog.init(p\u2026le.getCancelButtonText())");
                SelectFilesDialog selectFilesDialog2 = selectFilesDialog;
                selectFilesDialog2.setTitle(SpaceBundle.message("share.project.action.progress.title.adding.files.to.commit.title", new Object[0]));
                Collection collection = this.$preselectedFiles;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    selectFilesDialog2.setSelectedFiles((Collection)this.$preselectedFiles);
                }
                selectFilesDialog2.showAndGet();
                return var1_1;
            }
            {
                this.$project = project;
                this.$allFiles = list2;
                this.$preselectedFiles = list3;
                super(0);
            }
        }));
        if (!dialog2.isOK()) {
            return CollectionsKt.emptyList();
        }
        Collection collection = dialog2.getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"dialog.selectedFiles");
        return collection;
    }

    private final boolean pushCurrentBranch(Project project, GitRepository repository2, String remoteName, String remoteUrl, String name, String url, ProgressIndicator indicator) {
        LOG.info((Object)"Pushing to master");
        indicator.setText(SpaceBundle.message("share.project.action.progress.title.pushing.title", new Object[0]));
        GitLocalBranch currentBranch = repository2.getCurrentBranch();
        String string = XmlStringUtil.formatLink((String)url, (String)('\'' + name + '\''));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatLink(url, \"'$name'\")");
        String repositoryLink = string;
        if (currentBranch == null) {
            String string2 = SpaceBundle.message("share.project.error.notification.no.current.branch.message", repositoryLink);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceBundle.message(\"sha\u2026message\", repositoryLink)");
            this.notifyError(project, string2);
            return false;
        }
        GitCommandResult gitCommandResult = this.git.push(repository2, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"git.push(repository, rem\u2026currentBranch.name, true)");
        GitCommandResult result2 = gitCommandResult;
        if (!result2.success()) {
            if (result2.getExitCode() == 128) {
                LOG.info((Object)("Couldn't push shared project. Git output: " + result2.getErrorOutputAsHtmlString()));
                this.showInitialPushNotPerformedNotification(project, url, name);
                return false;
            }
            String string3 = XmlStringUtil.wrapInHtmlLines((CharSequence[])new CharSequence[]{SpaceBundle.message("share.project.error.notification.push.failed.message", repositoryLink), result2.getErrorOutputAsHtmlString()});
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wrapInHtmlLines( // NON-\u2026utputAsHtmlString\n      )");
            this.notifyError(project, string3);
            return false;
        }
        return true;
    }

    private final void notifyError(Project project, @NlsContexts.NotificationContent String message) {
        VcsNotifier.getInstance((Project)project).notifyError("space.sharing.not.finished", SpaceBundle.message("share.project.error.notification.title", new Object[0]), message, NotificationListener.URL_OPENING_LISTENER);
    }

    public SpaceShareProjectAction() {
        Git git = Git.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"Git.getInstance()");
        this.git = git;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpaceShareProjectAction.class));
    }

    public static final /* synthetic */ SpaceShareProjectDialog.Result access$createSpaceProject(SpaceShareProjectAction $this, Project project) {
        return $this.createSpaceProject(project);
    }

    public static final /* synthetic */ void access$shareProjectOnSpace(SpaceShareProjectAction $this, Project project, VirtualFile file, SpaceShareProjectDialog.Result.ProjectCreated details) {
        $this.shareProjectOnSpace(project, file, details);
    }

    public static final /* synthetic */ void access$notifyError(SpaceShareProjectAction $this, Project project, String message) {
        $this.notifyError(project, message);
    }

    public static final /* synthetic */ KLogger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$createEmptyGitRepository(SpaceShareProjectAction $this, Project project, VirtualFile root, ProgressIndicator indicator) {
        return $this.createEmptyGitRepository(project, root, indicator);
    }

    public static final /* synthetic */ Pair access$addRemoteUrl(SpaceShareProjectAction $this, RepoDetails repoDetails, Git git, GitRepository gitRepo, ProgressIndicator indicator) {
        return $this.addRemoteUrl(repoDetails, git, gitRepo, indicator);
    }

    public static final /* synthetic */ boolean access$performFirstCommitIfRequired(SpaceShareProjectAction $this, Project project, VirtualFile root, GitRepository repository2, ProgressIndicator indicator, String name, String url) {
        return $this.performFirstCommitIfRequired(project, root, repository2, indicator, name, url);
    }

    public static final /* synthetic */ boolean access$pushCurrentBranch(SpaceShareProjectAction $this, Project project, GitRepository repository2, String remoteName, String remoteUrl, String name, String url, ProgressIndicator indicator) {
        return $this.pushCurrentBranch(project, repository2, remoteName, remoteUrl, name, url, indicator);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/vcs/share/SpaceShareProjectAction$Companion;", "", "()V", "LOG", "Llibraries/klogging/KLogger;", "intellij.space"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

