/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.plantuml;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFencePluginGeneratingProvider;
import org.intellij.plugins.markdown.extensions.common.plantuml.PlantUMLCodeGeneratingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager;", "Lcom/intellij/openapi/Disposable;", "()V", "loadedClassAndMethod", "Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager$Holder;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "dispose", "", "dropCache", "findMethod", "Ljava/lang/reflect/Method;", "loadedClass", "Ljava/lang/Class;", "findPath", "Ljava/io/File;", "generateImage", "source", "", "outputStream", "Ljava/io/OutputStream;", "loadClass", "path", "obtainCurrentHolder", "Companion", "Holder", "intellij.markdown"})
public final class PlantUMLJarManager
implements Disposable {
    private final ReentrantLock lock = new ReentrantLock();
    private Holder loadedClassAndMethod;
    private static final String className = "net.sourceforge.plantuml.SourceStringReader";
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    private final Class<?> loadClass(File path) {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{path.toURI().toURL()}, this.getClass().getClassLoader());
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (Throwable exception) {
            logger.warn("Failed to find net.sourceforge.plantuml.SourceStringReader class in downloaded PlantUML jar. Please try to download another PlantUML library version.", exception);
            classLoader.close();
            return null;
        }
    }

    private final Method findMethod(Class<?> loadedClass) {
        String methodName = "generateImage";
        try {
            return loadedClass.getDeclaredMethod(methodName, Class.forName("java.io.OutputStream"));
        }
        catch (Throwable exception) {
            logger.warn("Failed to find 'generateImage' method in the class 'net.sourceforge.plantuml.SourceStringReader'. Please try to download another PlantUML library version.", exception);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File findPath() {
        PlantUMLCodeGeneratingProvider extension;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = MarkdownCodeFencePluginGeneratingProvider.Companion.getAll();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PlantUMLCodeGeneratingProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        PlantUMLCodeGeneratingProvider plantUMLCodeGeneratingProvider = extension = (PlantUMLCodeGeneratingProvider)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return plantUMLCodeGeneratingProvider != null ? plantUMLCodeGeneratingProvider.getFullPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Holder obtainCurrentHolder() {
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (reentrantLock) {
            Method method;
            Class<?> clazz;
            File file;
            block7: {
                boolean bl3 = false;
                if (!Disposer.isDisposed((Disposable)this)) break block7;
                return null;
            }
            if (this.loadedClassAndMethod != null) return this.loadedClassAndMethod;
            if (this.findPath() == null) return null;
            File path = file;
            if (this.loadClass(path) == null) return null;
            Class<?> loadedClass = clazz;
            if (this.findMethod(loadedClass) == null) return null;
            Method method2 = method;
            this.loadedClassAndMethod = new Holder(loadedClass, method2);
            return this.loadedClassAndMethod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void generateImage(@NotNull String source, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (reentrantLock) {
            boolean bl3 = false;
            Holder holder = this.obtainCurrentHolder();
            if (holder == null) {
                return;
            }
            Object object = holder;
            Class<?> clazz = ((Holder)object).component1();
            Method method = ((Holder)object).component2();
            try {
                void loadedClass;
                object = method.invoke(loadedClass.getConstructor(String.class).newInstance(source), outputStream);
            }
            catch (Throwable exception) {
                logger.warn("Failed to invoke method.", exception);
                object = Unit.INSTANCE;
            }
            Holder holder2 = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dropCache() {
        ReentrantLock reentrantLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (reentrantLock) {
            boolean bl3 = false;
            Holder holder = this.loadedClassAndMethod;
            if (holder != null) {
                Holder holder2 = holder;
                boolean bl4 = false;
                boolean bl5 = false;
                Holder it = holder2;
                boolean bl6 = false;
                try {
                    Unit unit;
                    ClassLoader classLoader = it.getLoadedClass().getClassLoader();
                    if (!(classLoader instanceof URLClassLoader)) {
                        classLoader = null;
                    }
                    URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                    if (uRLClassLoader != null) {
                        uRLClassLoader.close();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable exception) {
                    logger.warn("Failed to close class loader.", exception);
                    Unit unit = Unit.INSTANCE;
                }
            }
            this.loadedClassAndMethod = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
        this.dropCache();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PlantUMLJarManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PlantUMLJarManager.logger = logger;
    }

    @JvmStatic
    @NotNull
    public static final PlantUMLJarManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager$Holder;", "", "loadedClass", "Ljava/lang/Class;", "method", "Ljava/lang/reflect/Method;", "(Ljava/lang/Class;Ljava/lang/reflect/Method;)V", "getLoadedClass", "()Ljava/lang/Class;", "getMethod", "()Ljava/lang/reflect/Method;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.markdown"})
    private static final class Holder {
        @NotNull
        private final Class<?> loadedClass;
        @NotNull
        private final Method method;

        @NotNull
        public final Class<?> getLoadedClass() {
            return this.loadedClass;
        }

        @NotNull
        public final Method getMethod() {
            return this.method;
        }

        public Holder(@NotNull Class<?> loadedClass, @NotNull Method method) {
            Intrinsics.checkNotNullParameter(loadedClass, (String)"loadedClass");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.loadedClass = loadedClass;
            this.method = method;
        }

        @NotNull
        public final Class<?> component1() {
            return this.loadedClass;
        }

        @NotNull
        public final Method component2() {
            return this.method;
        }

        @NotNull
        public final Holder copy(@NotNull Class<?> loadedClass, @NotNull Method method) {
            Intrinsics.checkNotNullParameter(loadedClass, (String)"loadedClass");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            return new Holder(loadedClass, method);
        }

        public static /* synthetic */ Holder copy$default(Holder holder, Class clazz, Method method, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = holder.loadedClass;
            }
            if ((n & 2) != 0) {
                method = holder.method;
            }
            return holder.copy(clazz, method);
        }

        @NotNull
        public String toString() {
            return "Holder(loadedClass=" + this.loadedClass + ", method=" + this.method + ")";
        }

        public int hashCode() {
            Class<?> clazz = this.loadedClass;
            Method method = this.method;
            return (clazz != null ? clazz.hashCode() : 0) * 31 + (method != null ? ((Object)method).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Holder)) break block3;
                    Holder holder = (Holder)object;
                    if (!Intrinsics.areEqual(this.loadedClass, holder.loadedClass) || !Intrinsics.areEqual((Object)this.method, (Object)holder.method)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager$Companion;", "", "()V", "className", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLJarManager;", "intellij.markdown"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PlantUMLJarManager getInstance() {
            boolean $i$f$service = false;
            Class<PlantUMLJarManager> serviceClass$iv = PlantUMLJarManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (PlantUMLJarManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

