/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.commandRunner;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingRunConfigurationProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentProjectProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownConfigurableExtension;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionsUtil;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.MarkdownRunner;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownFileEditorUtils;
import org.intellij.plugins.markdown.injection.alias.LanguageGuesser;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 /2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002/0B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u001a\u0010 \u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u0016\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bJ\u0016\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u001aJ\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u000bH\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u000bH\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014\u00a8\u00061"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$SplitLayoutListener;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "provider", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;)V", "hash2Cmd", "", "", "getPanel", "()Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "scripts", "", "getScripts", "()Ljava/util/List;", "splitEditor", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview;", "styles", "getStyles", "canProvide", "", "resourceName", "dispose", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "onLayoutChange", "oldLayout", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "newLayout", "onPageReady", "ready", "processCodeBlock", "codeFenceRawContent", "language", "processCodeLine", "rawCodeLine", "inBlock", "runBlock", "encodedLine", "runLine", "Companion", "Provider", "intellij.markdown"})
public final class CommandRunnerExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider,
MarkdownEditorWithPreview.SplitLayoutListener {
    @NotNull
    private final List<String> scripts;
    @NotNull
    private final List<String> styles;
    private final Map<String, String> hash2Cmd;
    private MarkdownEditorWithPreview splitEditor;
    @NotNull
    private final ResourceProvider resourceProvider;
    @NotNull
    private final MarkdownHtmlPanel panel;
    private final Provider provider;
    private static final String RUN_LINE_EVENT = "runLine";
    private static final String RUN_BLOCK_EVENT = "runBlock";
    private static final String PAGE_READY_EVENT = "pageReady";
    private static final String LAYOUT_CHANGE_EVENT = "layoutChange";
    private static final String RUN_LINE_ICON = "run.png";
    private static final String RUN_BLOCK_ICON = "runrun.png";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    public void onLayoutChange(@Nullable TextEditorWithPreview.Layout oldLayout, @NotNull TextEditorWithPreview.Layout newLayout) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)newLayout, (String)"newLayout");
            BrowserPipe browserPipe = this.panel.getBrowserPipe();
            if (browserPipe == null) break block0;
            browserPipe.send(LAYOUT_CHANGE_EVENT, newLayout.name());
        }
    }

    private final void onPageReady(String ready) {
        block1: {
            MarkdownEditorWithPreview markdownEditorWithPreview = this.splitEditor;
            if (markdownEditorWithPreview == null) break block1;
            MarkdownEditorWithPreview markdownEditorWithPreview2 = markdownEditorWithPreview;
            boolean bl = false;
            boolean bl2 = false;
            MarkdownEditorWithPreview it = markdownEditorWithPreview2;
            boolean bl3 = false;
            BrowserPipe browserPipe = this.panel.getBrowserPipe();
            if (browserPipe != null) {
                browserPipe.send(LAYOUT_CHANGE_EVENT, it.getLayout().name());
            }
        }
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getScripts().contains(resourceName) || this.getStyles().contains(resourceName);
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return ResourceProvider.Companion.loadInternalResource$default(ResourceProvider.Companion, Reflection.getOrCreateKotlinClass(this.getClass()), resourceName, null, 4, null);
    }

    @NotNull
    public final String processCodeLine(@NotNull String rawCodeLine, boolean inBlock) {
        Intrinsics.checkNotNullParameter((Object)rawCodeLine, (String)"rawCodeLine");
        Project project = this.panel.getProject();
        VirtualFile file = this.panel.getVirtualFile();
        if (project != null && file != null) {
            VirtualFile virtualFile = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.parent");
            String string = rawCodeLine;
            boolean bl = false;
            if (Companion.matches(project, virtualFile.getCanonicalPath(), true, ((Object)StringsKt.trim((CharSequence)string)).toString())) {
                String hash = MarkdownUtil.INSTANCE.md5(rawCodeLine, "");
                this.hash2Cmd.put(hash, rawCodeLine);
                String cssClass = "run-icon hidden" + (inBlock ? " code-block" : "");
                return "<a class='" + cssClass + "' href='#' role='button' data-command='Run:" + hash + "'>" + "<img src='" + PreviewStaticServer.Companion.getStaticUrl(this.provider, RUN_LINE_ICON) + "'>" + "</a>";
            }
        }
        return "";
    }

    @NotNull
    public final String processCodeBlock(@NotNull String codeFenceRawContent, @NotNull String language) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)codeFenceRawContent, (String)"codeFenceRawContent");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Language lang = LanguageGuesser.guessLanguageForInjection(language);
            List list = MarkdownRunner.Companion.getEP_NAME().getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"MarkdownRunner.EP_NAME.extensionList");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MarkdownRunner it = (MarkdownRunner)element$iv;
                boolean bl = false;
                if (!it.isApplicable(lang)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        MarkdownRunner runner = v1;
        if (runner == null) {
            return "";
        }
        String hash = MarkdownUtil.INSTANCE.md5(codeFenceRawContent, "");
        this.hash2Cmd.put(hash, codeFenceRawContent);
        String cssClass = "run-icon hidden code-block";
        return "<a class='" + cssClass + "' href='#' role='button' " + "data-command='Run:" + hash + "' " + "data-commandtype='block'" + ">" + "<img src='" + PreviewStaticServer.Companion.getStaticUrl(this.provider, RUN_BLOCK_ICON) + "'>" + "</a>";
    }

    private final void runLine(String encodedLine) {
        String executorId = StringsKt.substringBefore$default((String)encodedLine, (String)":", null, (int)2, null);
        String cmdHash = StringsKt.substringAfter$default((String)encodedLine, (String)":", null, (int)2, null);
        String command = this.hash2Cmd.get(cmdHash);
        if (command == null) {
            LOG.error("Command index " + cmdHash + " not found. Please attach .md file to error report. commandCache = " + this.hash2Cmd);
            return;
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        Executor executor2 = executor;
        Project project = this.panel.getProject();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        if (project != null && virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"virtualFile.parent");
            String string = virtualFile2.getCanonicalPath();
            Executor executor3 = executor2;
            Intrinsics.checkNotNullExpressionValue((Object)executor3, (String)"executor");
            Companion.execute(project, string, true, command, executor3);
        }
    }

    private final void runBlock(String encodedLine) {
        String executorId = StringsKt.substringBefore$default((String)encodedLine, (String)":", null, (int)2, null);
        String cmdHash = StringsKt.substringAfter$default((String)encodedLine, (String)":", null, (int)2, null);
        String command = this.hash2Cmd.get(cmdHash);
        if (command == null) {
            LOG.error("Command hash " + cmdHash + " not found. Please attach .md file to error report.\n" + this.hash2Cmd);
            return;
        }
        List list = MarkdownRunner.Companion.getEP_NAME().getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"MarkdownRunner.EP_NAME.extensionList");
        MarkdownRunner runner = (MarkdownRunner)CollectionsKt.first((List)list);
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        Executor executor2 = executor;
        Project project = this.panel.getProject();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        if (project != null && virtualFile != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(runner, command, project, virtualFile, executor2){
                final /* synthetic */ MarkdownRunner $runner;
                final /* synthetic */ String $command;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Executor $executor;

                public final void run() {
                    VirtualFile virtualFile = this.$virtualFile.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"virtualFile.parent");
                    String string = virtualFile.getCanonicalPath();
                    Executor executor = this.$executor;
                    Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"executor");
                    this.$runner.run(this.$command, this.$project, string, executor);
                }
                {
                    this.$runner = markdownRunner;
                    this.$command = string;
                    this.$project = project;
                    this.$virtualFile = virtualFile;
                    this.$executor = executor;
                }
            });
        }
    }

    public void dispose() {
        Map<VirtualFile, CommandRunnerExtension> map = this.provider.getExtensions();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        boolean bl = false;
        Map<VirtualFile, CommandRunnerExtension> map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
        }
        TypeIntrinsics.asMutableMap(map2).remove(virtualFile);
    }

    @NotNull
    public final MarkdownHtmlPanel getPanel() {
        return this.panel;
    }

    public CommandRunnerExtension(@NotNull MarkdownHtmlPanel panel2, @NotNull Provider provider) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.panel = panel2;
        this.provider = provider;
        this.scripts = CollectionsKt.listOf((Object)"commandRunner/commandRunner.js");
        this.styles = CollectionsKt.listOf((Object)"commandRunner/commandRunner.css");
        boolean bl = false;
        this.hash2Cmd = new LinkedHashMap();
        BrowserPipe browserPipe = this.panel.getBrowserPipe();
        if (browserPipe != null) {
            Function1 function1 = (Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((CommandRunnerExtension)this.receiver).runLine(p1);
                }
            };
            browserPipe.subscribe(RUN_LINE_EVENT, new BrowserPipe.Handler(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void messageReceived(String data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)data), (String)"invoke(...)");
                }

                public kotlin.Function getFunctionDelegate() {
                    return this.function;
                }

                public boolean equals(Object object) {
                    return object instanceof BrowserPipe.Handler && object instanceof FunctionAdapter && Intrinsics.areEqual((Object)this.function, (Object)((FunctionAdapter)object).getFunctionDelegate());
                }

                public int hashCode() {
                    return this.function.hashCode();
                }
            });
        }
        BrowserPipe browserPipe2 = this.panel.getBrowserPipe();
        if (browserPipe2 != null) {
            Function1 function1 = (Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((CommandRunnerExtension)this.receiver).runBlock(p1);
                }
            };
            browserPipe2.subscribe(RUN_BLOCK_EVENT, new /* invalid duplicate definition of identical inner class */);
        }
        BrowserPipe browserPipe3 = this.panel.getBrowserPipe();
        if (browserPipe3 != null) {
            Function1 function1 = (Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((CommandRunnerExtension)this.receiver).onPageReady(p1);
                }
            };
            browserPipe3.subscribe(PAGE_READY_EVENT, new /* invalid duplicate definition of identical inner class */);
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(this){
            final /* synthetic */ CommandRunnerExtension this$0;
            {
                this.this$0 = commandRunnerExtension;
            }

            public final void run() {
                block0: {
                    boolean bl = false;
                    Project project = this.this$0.getPanel().getProject();
                    Intrinsics.checkNotNull((Object)project);
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"panel.project!!");
                    VirtualFile virtualFile = this.this$0.getPanel().getVirtualFile();
                    Intrinsics.checkNotNull((Object)virtualFile);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"panel.virtualFile!!");
                    MarkdownEditorWithPreview markdownEditorWithPreview = MarkdownFileEditorUtils.findMarkdownSplitEditor(project, virtualFile);
                    if (markdownEditorWithPreview == null) break block0;
                    MarkdownEditorWithPreview markdownEditorWithPreview2 = markdownEditorWithPreview;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    MarkdownEditorWithPreview it = markdownEditorWithPreview2;
                    boolean bl4 = false;
                    CommandRunnerExtension.access$setSplitEditor$p(this.this$0, it);
                    it.addLayoutListener(this.this$0);
                }
            }
        };
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
        application.invokeLater(runnable, modalityState);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public final void dispose() {
                block2: {
                    Function1 function1;
                    BrowserPipe browserPipe = this.getPanel().getBrowserPipe();
                    if (browserPipe != null) {
                        function1 = (Function1)new Function1<String, Unit>(this){

                            public final void invoke(@NotNull String p1) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                ((CommandRunnerExtension)this.receiver).runLine(p1);
                            }
                        };
                        browserPipe.removeSubscription(CommandRunnerExtension.RUN_LINE_EVENT, new /* invalid duplicate definition of identical inner class */);
                    }
                    BrowserPipe browserPipe2 = this.getPanel().getBrowserPipe();
                    if (browserPipe2 != null) {
                        function1 = (Function1)new Function1<String, Unit>(this){

                            public final void invoke(@NotNull String p1) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                ((CommandRunnerExtension)this.receiver).runBlock(p1);
                            }
                        };
                        browserPipe2.removeSubscription(CommandRunnerExtension.RUN_BLOCK_EVENT, new /* invalid duplicate definition of identical inner class */);
                    }
                    MarkdownEditorWithPreview markdownEditorWithPreview = splitEditor;
                    if (markdownEditorWithPreview == null) break block2;
                    markdownEditorWithPreview.removeLayoutListener(this);
                }
            }
        });
        this.resourceProvider = this;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommandRunnerExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return MarkdownBrowserPreviewExtension.DefaultImpls.getPriority(this);
    }

    @Override
    public int compareTo(@NotNull MarkdownBrowserPreviewExtension other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MarkdownBrowserPreviewExtension.DefaultImpls.compareTo(this, other);
    }

    public static final /* synthetic */ void access$setSplitEditor$p(CommandRunnerExtension $this, MarkdownEditorWithPreview markdownEditorWithPreview) {
        $this.splitEditor = markdownEditorWithPreview;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownConfigurableExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "displayName", "getDisplayName", "extensions", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "getExtensions", "()Ljava/util/Map;", "icons", "", "getIcons", "()Ljava/util/List;", "id", "getId", "canProvide", "", "resourceName", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider,
    MarkdownConfigurableExtension,
    ResourceProvider {
        @NotNull
        private final Map<VirtualFile, CommandRunnerExtension> extensions;
        @NotNull
        private final List<String> icons;

        @NotNull
        public final Map<VirtualFile, CommandRunnerExtension> getExtensions() {
            return this.extensions;
        }

        @Override
        @Nullable
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            if (!this.isEnabled() || panel2.getVirtualFile() == null || panel2.getProject() == null) {
                return null;
            }
            VirtualFile virtualFile = panel2.getVirtualFile();
            Intrinsics.checkNotNull((Object)virtualFile);
            this.extensions.computeIfAbsent(virtualFile, new Function(this, panel2){
                final /* synthetic */ Provider this$0;
                final /* synthetic */ MarkdownHtmlPanel $panel;

                @NotNull
                public final CommandRunnerExtension apply(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new CommandRunnerExtension(this.$panel, this.this$0);
                }
                {
                    this.this$0 = provider;
                    this.$panel = markdownHtmlPanel;
                }
            });
            Map<VirtualFile, CommandRunnerExtension> map = this.extensions;
            VirtualFile virtualFile2 = panel2.getVirtualFile();
            boolean bl = false;
            return map.get(virtualFile2);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = MarkdownBundle.message("markdown.extensions.commandrunner.display.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026mandrunner.display.name\")");
            return string;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = MarkdownBundle.message("markdown.extensions.commandrunner.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026mmandrunner.description\")");
            return string;
        }

        @Override
        @NotNull
        public String getId() {
            return "CommandRunnerExtension";
        }

        @NotNull
        public final List<String> getIcons() {
            return this.icons;
        }

        @Override
        public boolean canProvide(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            return this.icons.contains(resourceName);
        }

        @Override
        @Nullable
        public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            switch (resourceName) {
                case "run.png": {
                    icon = AllIcons.RunConfigurations.TestState.Run;
                    break;
                }
                case "runrun.png": {
                    icon = AllIcons.RunConfigurations.TestState.Run_run;
                    break;
                }
                default: {
                    return null;
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"when (resourceName) {\n  \u2026se -> return null\n      }");
            Icon icon2 = icon;
            String format = StringsKt.substringAfterLast$default((String)resourceName, (String)".", null, (int)2, null);
            return new ResourceProvider.Resource(Companion.icon2Stream(icon2, format), null, 2, null);
        }

        public Provider() {
            boolean bl = false;
            this.extensions = new LinkedHashMap();
            PreviewStaticServer.Companion.getInstance().registerResourceProvider(this);
            this.icons = CollectionsKt.listOf((Object[])new String[]{CommandRunnerExtension.RUN_LINE_ICON, CommandRunnerExtension.RUN_BLOCK_ICON});
        }

        @Override
        public boolean isEnabled() {
            return MarkdownConfigurableExtension.DefaultImpls.isEnabled(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0002J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004J(\u0010$\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Companion;", "", "()V", "LAYOUT_CHANGE_EVENT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PAGE_READY_EVENT", "RUN_BLOCK_EVENT", "RUN_BLOCK_ICON", "RUN_LINE_EVENT", "RUN_LINE_ICON", "checkForCLI", "", "it", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingProvider;", "createDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "localSession", "workingDirectory", "executor", "Lcom/intellij/execution/Executor;", "execute", "command", "getRunnerByFile", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "icon2Stream", "", "icon", "Ljavax/swing/Icon;", "format", "matches", "intellij.markdown"})
    public static final class Companion {
        @Nullable
        public final CommandRunnerExtension getRunnerByFile(@Nullable VirtualFile file) {
            CommandRunnerExtension commandRunnerExtension;
            Object v1;
            Object v0;
            block4: {
                MarkdownExtensionsUtil this_$iv = MarkdownExtensionsUtil.INSTANCE;
                boolean $i$f$findBrowserExtensionProvider = false;
                Iterable iterable = MarkdownBrowserPreviewExtension.Provider.Companion.getAll();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    MarkdownBrowserPreviewExtension.Provider it$iv = (MarkdownBrowserPreviewExtension.Provider)t;
                    boolean bl3 = false;
                    if (!(it$iv instanceof Provider)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = v1 = null;
            }
            if (!(v0 instanceof Provider)) {
                v1 = null;
            }
            Provider provider = v1;
            Object object = provider;
            if (provider != null && (object = ((Provider)object).getExtensions()) != null) {
                Object object2 = object;
                boolean bl = false;
                commandRunnerExtension = (CommandRunnerExtension)object2.get(file);
            } else {
                commandRunnerExtension = null;
            }
            return commandRunnerExtension;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command) {
            boolean bl;
            block2: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                CharSequence charSequence = command;
                boolean bl2 = false;
                String trimmedCmd = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                charSequence = trimmedCmd;
                bl2 = false;
                if (charSequence.length() == 0) {
                    return false;
                }
                DataContext dataContext = org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension$Companion.createDataContext$default(this, project, localSession, workingDirectory, null, 8, null);
                ExtensionPointName extensionPointName = RunAnythingProvider.EP_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"RunAnythingProvider.EP_NAME");
                List list = extensionPointName.getExtensionList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"RunAnythingProvider.EP_NAME.extensionList");
                Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)matches.1.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    RunAnythingProvider provider = (RunAnythingProvider)element$iv;
                    boolean bl3 = false;
                    if (!(provider.findMatchingValue(dataContext, trimmedCmd) != null)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull Executor executor) {
            boolean bl;
            block4: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                DataContext dataContext = this.createDataContext(project, localSession, workingDirectory, executor);
                Object object = command;
                boolean bl2 = false;
                String trimmedCmd = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
                ExtensionPointName extensionPointName = RunAnythingProvider.EP_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"RunAnythingProvider.EP_NAME");
                List list = extensionPointName.getExtensionList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"RunAnythingProvider.EP_NAME.extensionList");
                object = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RunAnythingProvider provider = (RunAnythingProvider)element$iv;
                        boolean bl3 = false;
                        Object object2 = provider.findMatchingValue(dataContext, trimmedCmd);
                        if (object2 != null) {
                            Object object3 = object2;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Object it = object3;
                            boolean bl6 = false;
                            provider.execute(dataContext, it);
                            return true;
                        }
                        if (!false) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final DataContext createDataContext(Project project, boolean localSession, String workingDirectory, Executor executor) {
            VirtualFile virtualFile = localSession && workingDirectory != null ? LocalFileSystem.getInstance().findFileByPath(workingDirectory) : null;
            SimpleDataContext.Builder builder = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(RunAnythingAction.EXECUTOR_KEY, (Object)executor);
            boolean bl = false;
            boolean bl2 = false;
            SimpleDataContext.Builder $this$apply = builder;
            boolean bl3 = false;
            if (virtualFile != null) {
                $this$apply.add(CommonDataKeys.VIRTUAL_FILE, (Object)virtualFile);
                String string = virtualFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.path");
                $this$apply.add(RunAnythingProvider.EXECUTING_CONTEXT, (Object)new RunAnythingContext.RecentDirectoryContext(string));
            }
            DataContext dataContext = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"SimpleDataContext.builde\u2026       }\n        .build()");
            return dataContext;
        }

        static /* synthetic */ DataContext createDataContext$default(Companion companion, Project project, boolean bl, String string, Executor executor, int n, Object object) {
            if ((n & 8) != 0) {
                executor = null;
            }
            return companion.createDataContext(project, bl, string, executor);
        }

        private final boolean checkForCLI(RunAnythingProvider<?> it) {
            return !(it instanceof RunAnythingCommandProvider) && !(it instanceof RunAnythingRecentProjectProvider) && !(it instanceof RunAnythingRunConfigurationProvider);
        }

        @NotNull
        public final byte[] icon2Stream(@NotNull Icon icon, @NotNull String format) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Font font = EditorUtil.getEditorFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"EditorUtil.getEditorFont()");
            float fontSize = JBCefApp.normalizeScaledSize((int)(font.getSize() + 1));
            Icon icon2 = IconUtil.scaleByFont((Icon)icon, null, (float)fontSize);
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"IconUtil.scaleByFont(icon, null, fontSize)");
            Icon scaledIcon = icon2;
            BufferedImage bufferedImage = ImageUtil.createImage((ScaleContext)ScaleContext.create(), (double)scaledIcon.getIconWidth(), (double)scaledIcon.getIconHeight(), (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.createImage(Sc\u2026tUtil.RoundingMode.FLOOR)");
            BufferedImage image = bufferedImage;
            scaledIcon.paintIcon(null, image.getGraphics(), 0, 0);
            ImageIO.write((RenderedImage)image, format, output);
            byte[] byArray = output.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"output.toByteArray()");
            return byArray;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$checkForCLI(Companion $this, RunAnythingProvider it) {
            return $this.checkForCLI(it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

