/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;

public class TerminalSplitActionBase
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    private final boolean myVertically;

    private TerminalSplitActionBase(@NotNull Supplier<String> text, @Nullable Icon icon, boolean vertically) {
        if (text == null) {
            TerminalSplitActionBase.$$$reportNull$$$0(0);
        }
        this.getTemplatePresentation().setText(text);
        this.getTemplatePresentation().setIcon(icon);
        this.myVertically = vertically;
    }

    @Override
    public void actionPerformedInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content) {
        JBTerminalWidget terminalWidget;
        if (e == null) {
            TerminalSplitActionBase.$$$reportNull$$$0(1);
        }
        if (project == null) {
            TerminalSplitActionBase.$$$reportNull$$$0(2);
        }
        if (content == null) {
            TerminalSplitActionBase.$$$reportNull$$$0(3);
        }
        if ((terminalWidget = TerminalSplitActionBase.getContextTerminal(e, content)) != null) {
            TerminalView.getInstance(project).split(terminalWidget, this.myVertically);
        }
    }

    @Nullable
    static JBTerminalWidget getContextTerminal(@NotNull AnActionEvent e, @NotNull Content content) {
        JBTerminalWidget terminal;
        if (e == null) {
            TerminalSplitActionBase.$$$reportNull$$$0(4);
        }
        if (content == null) {
            TerminalSplitActionBase.$$$reportNull$$$0(5);
        }
        if ((terminal = (JBTerminalWidget)e.getDataContext().getData(JBTerminalWidget.TERMINAL_DATA_KEY)) != null && UIUtil.isAncestor((Component)content.getComponent(), (Component)terminal)) {
            return terminal;
        }
        return TerminalView.getWidgetByContent(content);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/terminal/action/TerminalSplitActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformedInTerminalToolWindow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextTerminal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Horizontal
    extends TerminalSplitActionBase {
        private Horizontal() {
            super(ActionsBundle.messagePointer((String)"action.SplitHorizontally.text", (Object[])new Object[0]), AllIcons.Actions.SplitHorizontally, false);
        }
    }

    public static final class Vertical
    extends TerminalSplitActionBase {
        private Vertical() {
            super(ActionsBundle.messagePointer((String)"action.SplitVertically.text", (Object[])new Object[0]), AllIcons.Actions.SplitVertically, true);
        }
    }
}

