/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.instrumentation;

import com.intellij.compiler.instrumentation.FailSafeMethodVisitor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jps.intellilang.instrumentation.PatternInstrumenter;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;

class InstrumentationAdapter
extends FailSafeMethodVisitor
implements Opcodes {
    private static final String RETURN_VALUE_NAME = "$returnvalue$";
    private final PatternInstrumenter myInstrumenter;
    private final Type[] myArgTypes;
    private final Type myReturnType;
    private final String myClassName;
    private final String myMethodName;
    private final boolean myDoAssert;
    private final boolean myIsStatic;
    private int myParamAnnotationOffset;
    private final List<PatternValue> myParameterPatterns = new ArrayList<PatternValue>();
    private PatternValue myMethodPattern;
    private Label myCheckReturnLabel;

    InstrumentationAdapter(PatternInstrumenter instrumenter, MethodVisitor mv, Type[] argTypes, Type returnType, String className, String methodName, boolean doAssert, boolean isStatic, int paramAnnotationOffset) {
        super(589824, mv);
        this.myInstrumenter = instrumenter;
        this.myDoAssert = doAssert;
        this.myArgTypes = argTypes;
        this.myReturnType = returnType;
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myIsStatic = isStatic;
        this.myParamAnnotationOffset = paramAnnotationOffset;
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        if (this.myParamAnnotationOffset != 0 && parameterCount == this.myArgTypes.length) {
            this.myParamAnnotationOffset = 0;
        }
        super.visitAnnotableParameterCount(parameterCount, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        String annotationClassName;
        String pattern;
        AnnotationVisitor av = this.mv.visitParameterAnnotation(parameter, desc, visible);
        if (PatternInstrumenter.isStringType(this.myArgTypes[parameter + this.myParamAnnotationOffset]) && (pattern = this.myInstrumenter.getAnnotationPattern(annotationClassName = Type.getType((String)desc).getClassName())) != null) {
            String shortName = annotationClassName.substring(annotationClassName.lastIndexOf(46) + 1);
            PatternValue patternValue = new PatternValue(parameter + this.myParamAnnotationOffset, shortName, pattern);
            this.myParameterPatterns.add(patternValue);
            if (pattern == "((((") {
                return new MyAnnotationVisitor(av, patternValue);
            }
        }
        return av;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String annotationClassName;
        String pattern;
        AnnotationVisitor av = this.mv.visitAnnotation(desc, visible);
        if (PatternInstrumenter.isStringType(this.myReturnType) && (pattern = this.myInstrumenter.getAnnotationPattern(annotationClassName = Type.getType((String)desc).getClassName())) != null) {
            String shortName = annotationClassName.substring(annotationClassName.lastIndexOf(46) + 1);
            this.myMethodPattern = new PatternValue(-1, shortName, pattern);
            if (pattern == "((((") {
                return new MyAnnotationVisitor(av, this.myMethodPattern);
            }
        }
        return av;
    }

    public void visitCode() {
        for (PatternValue parameter : this.myParameterPatterns) {
            int var = this.myIsStatic ? 0 : 1;
            for (int l = 0; l < parameter.parameterIndex; ++l) {
                var += this.myArgTypes[l].getSize();
            }
            Label checked = new Label();
            this.addPatternTest(parameter.patternIndex, checked, var);
            String message = MessageFormat.format("Argument {0} for @{1} parameter of {2}.{3} does not match pattern {4}", parameter.parameterIndex, parameter.annotation, this.myClassName, this.myMethodName, parameter.pattern);
            this.addPatternAssertion(message, false);
            this.mv.visitLabel(checked);
        }
        if (this.myMethodPattern != null) {
            this.myCheckReturnLabel = new Label();
        }
    }

    public void visitInsn(int opcode) {
        if (opcode == 176 && this.myCheckReturnLabel != null) {
            this.mv.visitJumpInsn(167, this.myCheckReturnLabel);
        } else {
            this.mv.visitInsn(opcode);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        try {
            if (this.myCheckReturnLabel != null) {
                int var = maxLocals + 1;
                this.mv.visitLabel(this.myCheckReturnLabel);
                this.mv.visitVarInsn(58, var);
                Label checked = new Label();
                this.addPatternTest(this.myMethodPattern.patternIndex, checked, var);
                String message = MessageFormat.format("Return value of method {0}.{1} annotated as @{2} does not match pattern {3}", this.myClassName, this.myMethodName, this.myMethodPattern.annotation, this.myMethodPattern.pattern);
                this.addPatternAssertion(message, true);
                this.mv.visitLabel(checked);
                this.mv.visitLocalVariable(RETURN_VALUE_NAME, "Ljava/lang/String;", null, this.myCheckReturnLabel, checked, var);
                this.mv.visitVarInsn(25, var);
                this.mv.visitInsn(176);
            }
            super.visitMaxs(maxStack, maxLocals);
        }
        catch (Throwable e) {
            this.myInstrumenter.registerError(this.myMethodName, "visitMaxs", e);
        }
    }

    private void addPatternTest(int patternIndex, Label label, int varIndex) {
        if (this.myDoAssert) {
            this.mv.visitFieldInsn(178, this.myClassName, "$assertionsDisabled", "Z");
            this.mv.visitJumpInsn(154, label);
        }
        this.mv.visitVarInsn(25, varIndex);
        this.mv.visitJumpInsn(198, label);
        this.mv.visitFieldInsn(178, this.myClassName, "$_PATTERN_CACHE_$", "[Ljava/util/regex/Pattern;");
        this.mv.visitIntInsn(16, patternIndex);
        this.mv.visitInsn(50);
        this.mv.visitVarInsn(25, varIndex);
        this.mv.visitMethodInsn(182, "java/util/regex/Pattern", "matcher", "(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;", false);
        this.mv.visitMethodInsn(182, "java/util/regex/Matcher", "matches", "()Z", false);
        this.mv.visitJumpInsn(154, label);
    }

    private void addPatternAssertion(String message, boolean isMethod) {
        if (this.myDoAssert) {
            this.addThrow("java/lang/AssertionError", "(Ljava/lang/Object;)V", message);
        } else if (isMethod) {
            this.addThrow("java/lang/IllegalStateException", "(Ljava/lang/String;)V", message);
        } else {
            this.addThrow("java/lang/IllegalArgumentException", "(Ljava/lang/String;)V", message);
        }
        this.myInstrumenter.markInstrumented();
    }

    private void addThrow(String throwableClass, String ctorSignature, String message) {
        this.mv.visitTypeInsn(187, throwableClass);
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn((Object)message);
        this.mv.visitMethodInsn(183, throwableClass, "<init>", ctorSignature, false);
        this.mv.visitInsn(191);
    }

    private class PatternValue {
        final int parameterIndex;
        final String annotation;
        String pattern = null;
        int patternIndex = -1;

        PatternValue(int parameterIndex, String annotation, String pattern) {
            this.parameterIndex = parameterIndex;
            this.annotation = annotation;
            if (pattern != "((((") {
                this.set(pattern);
            }
        }

        void set(String s) {
            assert (this.pattern == null);
            this.pattern = s;
            this.patternIndex = InstrumentationAdapter.this.myInstrumenter.addPattern(this.pattern);
        }
    }

    private static class MyAnnotationVisitor
    extends AnnotationVisitor {
        private final PatternValue myPatternValue;

        MyAnnotationVisitor(AnnotationVisitor annotationvisitor, PatternValue v) {
            super(589824, annotationvisitor);
            this.myPatternValue = v;
        }

        public void visit(String name, Object value) {
            this.av.visit(name, value);
            if ("value".equals(name) && value instanceof String) {
                this.myPatternValue.set((String)value);
            }
        }
    }
}

