/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionBean
extends CustomLoadingExtensionPointBean<IntentionAction> {
    private static final Logger LOG = Logger.getInstance(IntentionActionBean.class);
    @Tag
    @RequiredElement
    public String className;
    @Tag
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String category;
    @Tag
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String categoryKey;
    @Tag
    public String bundleName;
    @Tag
    public String descriptionDirectoryName;

    @Override
    @Nullable
    protected String getImplementationClassName() {
        return this.className;
    }

    public String @Nullable [] getCategories() {
        String baseName;
        if (this.categoryKey == null) {
            return this.category == null ? null : this.category.split("/");
        }
        String string = baseName = this.bundleName != null ? this.bundleName : this.getPluginDescriptor().getResourceBundleBaseName();
        if (baseName == null) {
            LOG.error("No resource bundle specified for " + this.getPluginDescriptor());
            return null;
        }
        ResourceBundle bundle = DynamicBundle.INSTANCE.getResourceBundle(baseName, this.getLoaderForClass());
        String[] keys = this.categoryKey.split("/");
        if (keys.length > 1) {
            String[] result = new String[keys.length];
            for (int i2 = 0; i2 < keys.length; ++i2) {
                result[i2] = AbstractBundle.message((ResourceBundle)bundle, (String)keys[i2], (Object[])new Object[0]);
            }
            return result;
        }
        return AbstractBundle.message((ResourceBundle)bundle, (String)this.categoryKey, (Object[])new Object[0]).split("/");
    }

    public String getDescriptionDirectoryName() {
        return this.descriptionDirectoryName;
    }
}

