/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.cacheBuilder;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;

final class CacheBuilderEP
implements PluginAware {
    private static final Logger LOG = Logger.getInstance(CacheBuilderEP.class);
    @Attribute(value="fileType")
    public String fileType;
    @Attribute(value="wordsScannerClass")
    public String wordsScannerClass;
    private transient Class<WordsScanner> cachedClass;
    private transient PluginDescriptor pluginDescriptor;

    private CacheBuilderEP() {
    }

    String getFileType() {
        return this.fileType;
    }

    WordsScanner getWordsScanner() {
        try {
            Class aClass = this.cachedClass;
            Application app = ApplicationManager.getApplication();
            if (aClass == null) {
                this.cachedClass = aClass = app.loadClass(this.wordsScannerClass, this.pluginDescriptor);
            }
            return (WordsScanner)app.instantiateClass(aClass, this.pluginDescriptor.getPluginId());
        }
        catch (PluginException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error((Throwable)new PluginException(e, this.pluginDescriptor.getPluginId()));
            return null;
        }
    }

    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            CacheBuilderEP.$$$reportNull$$$0(0);
        }
        this.pluginDescriptor = pluginDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/lang/cacheBuilder/CacheBuilderEP", "setPluginDescriptor"));
    }
}

