/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import java.util.Comparator;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionManagerEx
extends ActionManager {
    public static ActionManagerEx getInstanceEx() {
        return (ActionManagerEx)ActionManagerEx.getInstance();
    }

    @NotNull
    public abstract ActionToolbar createActionToolbar(@NotNull String var1, @NotNull ActionGroup var2, boolean var3, boolean var4);

    @ApiStatus.Internal
    public abstract void fireBeforeActionPerformed(@NotNull AnAction var1, @NotNull AnActionEvent var2);

    @ApiStatus.Internal
    public abstract void fireAfterActionPerformed(@NotNull AnAction var1, @NotNull AnActionEvent var2, @NotNull AnActionResult var3);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public final void fireBeforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action == null) {
            ActionManagerEx.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            ActionManagerEx.$$$reportNull$$$0(1);
        }
        if (event == null) {
            ActionManagerEx.$$$reportNull$$$0(2);
        }
        this.fireBeforeActionPerformed(action, event);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public final void fireAfterActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action == null) {
            ActionManagerEx.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ActionManagerEx.$$$reportNull$$$0(4);
        }
        if (event == null) {
            ActionManagerEx.$$$reportNull$$$0(5);
        }
        this.fireAfterActionPerformed(action, event, AnActionResult.PERFORMED);
    }

    public abstract void fireBeforeEditorTyping(char var1, @NotNull DataContext var2);

    public abstract void fireAfterEditorTyping(char var1, @NotNull DataContext var2);

    public abstract String getLastPreformedActionId();

    public abstract String getPrevPreformedActionId();

    @NotNull
    public abstract Comparator<String> getRegistrationOrderComparator();

    @Nullable
    public static KeyStroke getKeyStroke(@NotNull String s) {
        if (s == null) {
            ActionManagerEx.$$$reportNull$$$0(6);
        }
        KeyStroke result = null;
        try {
            result = KeyStroke.getKeyStroke(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null && s.length() >= 2 && s.charAt(s.length() - 2) == ' ') {
            try {
                String s1 = s.substring(0, s.length() - 1) + Character.toUpperCase(s.charAt(s.length() - 1));
                result = KeyStroke.getKeyStroke(s1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public abstract String @NotNull [] getPluginActions(@NotNull PluginId var1);

    public abstract boolean isActionPopupStackEmpty();

    public abstract void addActionPopupMenuListener(@NotNull ActionPopupMenuListener var1, @NotNull Disposable var2);

    @ApiStatus.Internal
    public static void doWithLazyActionManager(@NotNull Consumer<? super ActionManager> whatToDo) {
        ActionManager created;
        if (whatToDo == null) {
            ActionManagerEx.$$$reportNull$$$0(7);
        }
        if ((created = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class)) == null) {
            ForkJoinPool.commonPool().execute(() -> {
                ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
                ApplicationManager.getApplication().invokeLater(() -> whatToDo.accept(actionManager), ModalityState.any());
            });
        } else {
            whatToDo.accept(created);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whatToDo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ActionManagerEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fireBeforeActionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fireAfterActionPerformed";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeyStroke";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doWithLazyActionManager";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

