/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class DialogAwareDataContext
implements DataContext {
    private static final DataKey[] keys = new DataKey[]{CommonDataKeys.PROJECT, PlatformCoreDataKeys.PROJECT_FILE_DIRECTORY, CommonDataKeys.EDITOR, CommonDataKeys.VIRTUAL_FILE, CommonDataKeys.PSI_FILE};
    private final Map<String, Object> values = new HashMap<String, Object>();

    DialogAwareDataContext(DataContext context) {
        for (DataKey key : keys) {
            this.values.put(key.getName(), key.getData(context));
        }
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DialogAwareDataContext.$$$reportNull$$$0(0);
        }
        if (this.values.containsKey(dataId)) {
            return this.values.get(dataId);
        }
        Editor editor = (Editor)this.values.get(CommonDataKeys.EDITOR.getName());
        if (editor != null) {
            return DataManager.getInstance().getDataContext(editor.getContentComponent()).getData(dataId);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/editor/actionSystem/DialogAwareDataContext", "getData"));
    }
}

