/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteBundle;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import com.intellij.remote.ext.UnknownTypeRemoteCredentialHandler;
import org.jetbrains.annotations.Nls;

public abstract class CredentialsType<T> {
    public static final ExtensionPointName<CredentialsType<?>> EP_NAME = new ExtensionPointName("com.intellij.remote.credentialsType");
    public static final Key<UnknownCredentialsHolder> UNKNOWN_CREDENTIALS = Key.create((String)"UNKNOWN_CREDENTIALS");
    public static final CredentialsType<UnknownCredentialsHolder> UNKNOWN = new CredentialsType<UnknownCredentialsHolder>(RemoteBundle.message("credentials.type.filetype.description.unknown", new Object[0]), ""){

        @Override
        public Key<UnknownCredentialsHolder> getCredentialsKey() {
            return UNKNOWN_CREDENTIALS;
        }

        @Override
        public RemoteCredentialsHandler getHandler(UnknownCredentialsHolder credentials) {
            return new UnknownTypeRemoteCredentialHandler(credentials);
        }

        @Override
        public UnknownCredentialsHolder createCredentials() {
            return new UnknownCredentialsHolder();
        }
    };
    @Nls(capitalization=Nls.Capitalization.Title)
    private final String myName;
    private final String myPrefix;
    private final String mySystemIndependentPrefix;
    private final String mySystemDependentPrefix;

    protected CredentialsType(@Nls(capitalization=Nls.Capitalization.Title) String name, String prefix) {
        this.myName = name;
        this.myPrefix = prefix;
        this.mySystemDependentPrefix = FileUtil.toSystemDependentName((String)prefix);
        this.mySystemIndependentPrefix = FileUtil.toSystemIndependentName((String)prefix);
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getName() {
        return this.myName;
    }

    public T getCredentials(UserDataHolderBase dataHolder) {
        return (T)dataHolder.getUserData(this.getCredentialsKey());
    }

    public void putCredentials(UserDataHolderBase dataHolder, T credentials) {
        dataHolder.putUserData(this.getCredentialsKey(), credentials);
    }

    public abstract Key<T> getCredentialsKey();

    public abstract RemoteCredentialsHandler getHandler(T var1);

    public boolean hasPrefix(String path2) {
        return path2.startsWith(this.myPrefix) || path2.startsWith(this.mySystemDependentPrefix) || path2.startsWith(this.mySystemIndependentPrefix);
    }

    public abstract T createCredentials();

    public int getWeight() {
        return Integer.MAX_VALUE;
    }

    public void saveCredentials(RemoteSdkAdditionalData data, CredentialsCase ... cases) {
        for (CredentialsCase credentialsCase : cases) {
            if (credentialsCase.getType() != this) continue;
            T credentials = this.createCredentials();
            credentialsCase.process(credentials);
            data.setCredentials(this.getCredentialsKey(), credentials);
        }
    }
}

