/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.AuthType;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RemoteCredentials {
    @NlsSafe
    @NotNull
    public String getHost();

    public int getPort();

    @NlsSafe
    @NotNull
    public String getLiteralPort();

    @Transient
    @NlsSafe
    @Nullable
    public String getUserName();

    @Nullable
    public String getPassword();

    @Transient
    @Nullable
    public String getPassphrase();

    @NotNull
    public AuthType getAuthType();

    @NlsSafe
    @NotNull
    public String getPrivateKeyFile();

    public boolean isStorePassword();

    public boolean isStorePassphrase();

    default public boolean shouldUseOpenSshConfig() {
        return this.getAuthType() == AuthType.OPEN_SSH || this.isOpenSshConfigUsageForced();
    }

    default public boolean isOpenSshConfigUsageForced() {
        return false;
    }

    @ApiStatus.Experimental
    @Nullable
    default public SshConnectionConfigPatch getConnectionConfigPatch() {
        return null;
    }

    default public boolean isSkippingHostKeyVerification() {
        return false;
    }
}

