/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.panels;

import com.intellij.ui.components.panels.LayoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HorizontalLayout
implements LayoutManager2 {
    public static final int FILL = -1;
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";
    public static final String CENTER = "CENTER";
    private final ArrayList<Component> myLeft;
    private final ArrayList<Component> myRight;
    private final ArrayList<Component> myCenter;
    private final int myAlignment;
    private final JBValue myGap;

    public HorizontalLayout(int gap) {
        this(gap, -1);
    }

    public HorizontalLayout(int gap, int alignment) {
        this((JBValue)new JBValue.Float((float)Math.max(0, gap)), alignment);
    }

    public HorizontalLayout(@NotNull JBValue gap, int alignment) {
        if (gap == null) {
            HorizontalLayout.$$$reportNull$$$0(0);
        }
        this.myLeft = new ArrayList();
        this.myRight = new ArrayList();
        this.myCenter = new ArrayList();
        this.myGap = gap;
        switch (alignment) {
            case -1: 
            case 0: 
            case 1: 
            case 3: {
                this.myAlignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported alignment: " + alignment);
            }
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("unsupported constraints: " + constraints);
        }
        this.addLayoutComponent((String)constraints, component);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (name == null || LEFT.equalsIgnoreCase(name)) {
                this.myLeft.add(component);
            } else if (CENTER.equalsIgnoreCase(name)) {
                this.myCenter.add(component);
            } else if (RIGHT.equalsIgnoreCase(name)) {
                this.myRight.add(component);
            } else {
                throw new IllegalArgumentException("unsupported name: " + name);
            }
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.myLeft.remove(component);
        this.myRight.remove(component);
        this.myCenter.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize(container, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getPreferredSize(container, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        int gap = this.myGap.get();
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension left = this.getPreferredSize(this.myLeft);
            Dimension right = this.getPreferredSize(this.myRight);
            Dimension center = this.getPreferredSize(this.myCenter);
            Insets insets = container.getInsets();
            int width = container.getWidth() - insets.left - insets.right;
            int height = container.getHeight() - insets.top - insets.bottom;
            int leftX = 0;
            if (left != null) {
                leftX = gap + this.layout(this.myLeft, 0, height, insets);
            }
            int rightX = width;
            if (right != null) {
                rightX -= right.width;
            }
            if (rightX < leftX) {
                rightX = leftX;
            }
            if (center != null) {
                int centerRightX;
                int centerX = (width - center.width) / 2;
                if (centerX > leftX && (centerRightX = centerX + center.width + gap + gap) > rightX) {
                    centerX = rightX - center.width - gap - gap;
                }
                if (centerX < leftX) {
                    centerX = leftX;
                }
                if (rightX < (centerX = gap + this.layout(this.myCenter, centerX, height, insets))) {
                    rightX = centerX;
                }
            }
            if (right != null) {
                this.layout(this.myRight, rightX, height, insets);
            }
        }
    }

    private int layout(List<? extends Component> list, int x, int height, Insets insets) {
        int gap = this.myGap.get();
        for (Component component : list) {
            if (!component.isVisible()) continue;
            Dimension size = LayoutUtil.getPreferredSize(component);
            int y = 0;
            if (this.myAlignment == -1) {
                size.height = height;
            } else if (this.myAlignment != 1) {
                y = height - size.height;
                if (this.myAlignment == 0) {
                    y /= 2;
                }
            }
            component.setBounds(x + insets.left, y + insets.top, size.width, size.height);
            x += size.width + gap;
        }
        return x;
    }

    private static Dimension join(Dimension result, int gap, Dimension size) {
        if (size == null) {
            return result;
        }
        if (result == null) {
            return new Dimension(size);
        }
        result.width += gap + size.width;
        if (result.height < size.height) {
            result.height = size.height;
        }
        return result;
    }

    private Dimension getPreferredSize(List<? extends Component> list) {
        int gap = this.myGap.get();
        Dimension result = null;
        for (Component component : list) {
            if (!component.isVisible()) continue;
            result = HorizontalLayout.join(result, gap, LayoutUtil.getPreferredSize(component));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getPreferredSize(Container container, boolean aligned) {
        int gap2 = 2 * this.myGap.get();
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension left = this.getPreferredSize(this.myLeft);
            Dimension right = this.getPreferredSize(this.myRight);
            Dimension center = this.getPreferredSize(this.myCenter);
            Dimension result = HorizontalLayout.join(HorizontalLayout.join(HorizontalLayout.join(null, gap2, left), gap2, center), gap2, right);
            if (result == null) {
                result = new Dimension();
            } else if (aligned && center != null) {
                int leftWidth = left == null ? 0 : left.width;
                int rightWidth = right == null ? 0 : right.width;
                result.width += Math.abs(leftWidth - rightWidth);
            }
            JBInsets.addTo((Dimension)result, (Insets)container.getInsets());
            return result;
        }
    }

    @NotNull
    public List<? extends Component> getComponents() {
        List list = ContainerUtil.concat((List[])new List[]{this.myLeft, this.myCenter, this.myRight});
        if (list == null) {
            HorizontalLayout.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/panels/HorizontalLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/panels/HorizontalLayout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

