/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.util.Pair;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FutureResult<T>
implements Future<T> {
    private final Semaphore mySema = new Semaphore(0);
    private volatile Pair<Object, Boolean> myValue;

    @Contract(pure=true)
    public FutureResult() {
    }

    @Contract(pure=true)
    public FutureResult(@Nullable T result) {
        this.set(result);
    }

    public synchronized void set(@Nullable T result) {
        this.assertNotSet();
        this.myValue = Pair.create(result, (Object)true);
        this.mySema.release();
    }

    public synchronized void setException(@NotNull Throwable e) {
        if (e == null) {
            FutureResult.$$$reportNull$$$0(0);
        }
        this.assertNotSet();
        this.myValue = Pair.create((Object)e, (Object)false);
        this.mySema.release();
    }

    public synchronized void reset() {
        try {
            if (this.isDone()) {
                this.mySema.acquire();
            }
        }
        catch (InterruptedException ignore) {
            return;
        }
        this.myValue = null;
    }

    private void assertNotSet() {
        if (this.isDone()) {
            throw new IllegalStateException("Result is already set");
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.myValue != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.mySema.acquire();
        try {
            T t = this.doGet();
            return t;
        }
        finally {
            this.mySema.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public T get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            FutureResult.$$$reportNull$$$0(1);
        }
        if (!this.mySema.tryAcquire(timeout, (TimeUnit)unit)) {
            throw new TimeoutException();
        }
        try {
            T t = this.doGet();
            return t;
        }
        finally {
            this.mySema.release();
        }
    }

    @Nullable
    public T tryGet() throws ExecutionException {
        return this.doGet();
    }

    @Nullable
    private T doGet() throws ExecutionException {
        Pair<Object, Boolean> pair = this.myValue;
        if (pair == null) {
            return null;
        }
        if (!((Boolean)pair.second).booleanValue()) {
            throw new ExecutionException(((Throwable)pair.first).getMessage(), (Throwable)pair.first);
        }
        return (T)pair.first;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/concurrency/FutureResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setException";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

