/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import org.jetbrains.annotations.NotNull;

public class VcsSelection {
    private final Document myDocument;
    private final int mySelectionStartLineNumber;
    private final int mySelectionEndLineNumber;
    private final @NlsActions.ActionText String myActionName;
    @NlsContexts.DialogTitle
    private final String myDialogTitle;

    public VcsSelection(@NotNull Document document, TextRange textRange, String actionName) {
        if (document == null) {
            VcsSelection.$$$reportNull$$$0(0);
        }
        this.myDocument = document;
        int startOffset = textRange.getStartOffset();
        this.mySelectionStartLineNumber = document.getLineNumber(startOffset);
        int endOffset = textRange.getEndOffset();
        this.mySelectionEndLineNumber = endOffset >= document.getTextLength() ? document.getLineCount() - 1 : document.getLineNumber(endOffset);
        this.myActionName = VcsBundle.message("show.history.action.name.template", actionName);
        this.myDialogTitle = VcsBundle.message("show.history.dialog.title.template", actionName);
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            VcsSelection.$$$reportNull$$$0(1);
        }
        return document;
    }

    public int getSelectionStartLineNumber() {
        return this.mySelectionStartLineNumber;
    }

    public int getSelectionEndLineNumber() {
        return this.mySelectionEndLineNumber;
    }

    @NlsActions.ActionText
    public String getActionName() {
        return this.myActionName;
    }

    @NlsContexts.DialogTitle
    public String getDialogTitle() {
        return this.myDialogTitle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

