/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GitRenameBranchOperation
extends GitBranchOperation {
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    @NlsSafe
    private final String myCurrentName;
    @NotNull
    @NlsSafe
    private final String myNewName;

    GitRenameBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull @NlsSafe String currentName, @NotNull @NlsSafe String newName, @NotNull List<? extends GitRepository> repositories) {
        if (project == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(2);
        }
        if (currentName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(4);
        }
        if (repositories == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(5);
        }
        super(project, git, uiHandler, repositories);
        this.myCurrentName = currentName;
        this.myNewName = newName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    @Override
    protected void execute() {
        while (this.hasMoreRepositories()) {
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.renameBranch(repository, this.myCurrentName, this.myNewName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                repository.update();
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError(GitBundle.message("git.rename.branch.could.not.rename.from.to", this.myCurrentName, this.myNewName), result2);
            return;
        }
        this.notifySuccess();
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository : repositories) {
            result2.append(repository, this.myGit.renameBranch(repository, this.myNewName, this.myCurrentName, new GitLineHandlerListener[0]));
            repository.update();
        }
        if (result2.totalSuccess()) {
            this.myNotifier.notifySuccess("git.branch.rename.rollback.success", GitBundle.message("git.rename.branch.rollback.successful", new Object[0]), GitBundle.message("git.rename.branch.renamed.back.to", this.myCurrentName));
        } else {
            this.myNotifier.notifyError("git.branch.rename.rollback.failed", GitBundle.message("git.rename.branch.rollback.failed", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        String string = GitBundle.message("git.rename.branch.was.renamed.to", HtmlChunk.text((String)this.myCurrentName).code().bold(), HtmlChunk.text((String)this.myNewName).code().bold());
        if (string == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    protected String getRollbackProposal() {
        String string = new HtmlBuilder().append(GitBundle.message("git.rename.branch.has.succeeded.for.the.following.repositories", this.getSuccessfulRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("git.rename.branch.you.may.rename.branch.back", this.myCurrentName)).toString();
        if (string == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        String string = GitBundle.message("rename.branch.operation.name", new Object[0]);
        if (string == null) {
            GitRenameBranchOperation.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitRenameBranchOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitRenameBranchOperation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

