/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitImplBase;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitObjectType;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitPushParams;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitImpl
extends GitImplBase {
    private static final Logger LOG = Logger.getInstance(Git.class);
    public static final List<String> REBASE_CONFIG_PARAMS = Collections.singletonList("core.commentChar=\u0001");

    @Override
    @NotNull
    public GitCommandResult init(@NotNull Project project, @NotNull VirtualFile root, GitLineHandlerListener ... listeners) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(1);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(2);
        }
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.INIT);
        for (GitLineHandlerListener listener : listeners) {
            h2.addLineListener(listener);
        }
        h2.setSilent(false);
        h2.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(3);
        }
        return gitCommandResult;
    }

    @Override
    public Set<FilePath> ignoredFilePaths(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<? extends FilePath> paths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(5);
        }
        HashSet<FilePath> ignoredFiles = new HashSet<FilePath>();
        if (paths == null) {
            ignoredFiles.addAll(this.ignoredFilePathsNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkPaths((VirtualFile)root, paths)) {
                ignoredFiles.addAll(this.ignoredFilePathsNoChunk(project, root, relativePaths));
            }
        }
        return ignoredFiles;
    }

    @Override
    public Set<FilePath> ignoredFilePathsNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> paths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(6);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(7);
        }
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.STATUS);
        h2.setSilent(true);
        h2.addParameters("--ignored", "--porcelain", "-z");
        if (paths != null) {
            h2.addParameters(paths);
        }
        h2.endOptions();
        String output = this.runCommand(h2).getOutputOrThrow(new int[0]);
        return GitImpl.parseFiles(root, output, "!! ");
    }

    @NotNull
    private static Set<FilePath> parseFiles(@NotNull VirtualFile root, @Nullable String output, @NotNull String fileStatusPrefix) throws VcsException {
        if (root == null) {
            GitImpl.$$$reportNull$$$0(8);
        }
        if (fileStatusPrefix == null) {
            GitImpl.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmptyOrSpaces((String)output)) {
            Set<FilePath> set = Collections.emptySet();
            if (set == null) {
                GitImpl.$$$reportNull$$$0(10);
            }
            return set;
        }
        HashSet<FilePath> files = new HashSet<FilePath>();
        for (String relPath : output.split("\u0000")) {
            ProgressManager.checkCanceled();
            if (!relPath.startsWith(fileStatusPrefix)) continue;
            String relativePath = relPath.substring(fileStatusPrefix.length());
            files.add(GitContentRevision.createPath(root, relativePath, relativePath.endsWith("/")));
        }
        HashSet<FilePath> hashSet = files;
        if (hashSet == null) {
            GitImpl.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> untrackedFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<? extends VirtualFile> files) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(12);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(13);
        }
        Set set = ContainerUtil.map2SetNotNull(this.untrackedFilePaths(project, root, files != null ? ContainerUtil.mapNotNull(files, VcsUtil::getFilePath) : null), FilePath::getVirtualFile);
        if (set == null) {
            GitImpl.$$$reportNull$$$0(14);
        }
        return set;
    }

    @Override
    public Set<FilePath> untrackedFilePaths(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> files) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(15);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(16);
        }
        HashSet<FilePath> untrackedFiles = new HashSet<FilePath>();
        if (files == null) {
            untrackedFiles.addAll(this.untrackedFilePathsNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
                untrackedFiles.addAll(this.untrackedFilePathsNoChunk(project, root, relativePaths));
            }
        }
        return untrackedFiles;
    }

    @Override
    @NotNull
    public Collection<FilePath> untrackedFilePathsNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> relativePaths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(17);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(18);
        }
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.LS_FILES);
        h2.setSilent(true);
        h2.addParameters("--exclude-standard", "--others", "-z");
        h2.endOptions();
        if (relativePaths != null) {
            h2.addParameters(relativePaths);
        }
        String output = this.runCommand(h2).getOutputOrThrow(new int[0]);
        return GitImpl.parseFiles(root, output, "");
    }

    @Override
    @NotNull
    public GitCommandResult clone(@Nullable Project project, @NotNull File parentDirectory, @NotNull String url, @NotNull String clonedDirectoryName, GitLineHandlerListener ... listeners) {
        if (parentDirectory == null) {
            GitImpl.$$$reportNull$$$0(19);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(20);
        }
        if (clonedDirectoryName == null) {
            GitImpl.$$$reportNull$$$0(21);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(22);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            Project defaultProject = ProjectManager.getInstance().getDefaultProject();
            GitLineHandler handler = new GitLineHandler(defaultProject, parentDirectory, GitCommand.CLONE);
            handler.setSilent(false);
            handler.setStderrSuppressed(false);
            handler.setUrl(url);
            handler.addParameters("--progress");
            if (GitVersionSpecialty.CLONE_RECURSE_SUBMODULES.existsIn(project, handler.getExecutable()) && AdvancedSettings.getBoolean((String)"git.clone.recurse.submodules")) {
                handler.addParameters("--recurse-submodules");
            }
            handler.addParameters(url);
            handler.endOptions();
            handler.addParameters(clonedDirectoryName);
            GitImpl.addListeners(handler, listeners);
            return handler;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(23);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult config(@NotNull GitRepository repository, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(24);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CONFIG);
        h2.addParameters(params);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(25);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult diff(@NotNull GitRepository repository, @NotNull List<String> parameters, @NotNull String range) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(26);
        }
        if (parameters == null) {
            GitImpl.$$$reportNull$$$0(27);
        }
        if (range == null) {
            GitImpl.$$$reportNull$$$0(28);
        }
        GitLineHandler diff = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.DIFF);
        diff.addParameters(parameters);
        diff.addParameters(range);
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(diff);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(29);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkAttr(@NotNull GitRepository repository, @NotNull Collection<String> attributes, @NotNull Collection<? extends VirtualFile> files) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(30);
        }
        if (attributes == null) {
            GitImpl.$$$reportNull$$$0(31);
        }
        if (files == null) {
            GitImpl.$$$reportNull$$$0(32);
        }
        List relativeFilePaths = ContainerUtil.map(files, file -> VcsFileUtil.relativePath((VirtualFile)repository.getRoot(), (VirtualFile)file));
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECK_ATTR);
        h2.addParameters("--stdin");
        h2.addParameters(new ArrayList<String>(attributes));
        h2.endOptions();
        h2.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(relativeFilePaths, h2.getCharset()));
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(33);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository repository, @NotNull String message) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(34);
        }
        if (message == null) {
            GitImpl.$$$reportNull$$$0(35);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        h2.addParameters("save");
        h2.addParameters(message);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(36);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(37);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(38);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        handler.addParameters("pop");
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(39);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult merge(@NotNull GitRepository repository, @NotNull String branchToMerge, @Nullable List<String> additionalParams, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(40);
        }
        if (branchToMerge == null) {
            GitImpl.$$$reportNull$$$0(41);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(42);
        }
        GitLineHandler mergeHandler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.MERGE);
        mergeHandler.setSilent(false);
        mergeHandler.addParameters(branchToMerge);
        if (additionalParams != null) {
            mergeHandler.addParameters(additionalParams);
        }
        for (GitLineHandlerListener listener : listeners) {
            mergeHandler.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(mergeHandler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(43);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository, @NotNull String reference, @Nullable String newBranch, boolean force, boolean detach, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(44);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(45);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(46);
        }
        GitCommandResult gitCommandResult = this.checkout(repository, reference, newBranch, force, detach, false, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(47);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository, @NotNull String reference, @Nullable String newBranch, boolean force, boolean detach, boolean withReset, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(48);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(49);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(50);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h2.setSilent(false);
        h2.setStdoutSuppressed(false);
        if (force) {
            h2.addParameters("--force");
        }
        if (newBranch == null) {
            h2.addParameters(new String[]{detach ? reference + "^0" : reference});
        } else {
            h2.addParameters(withReset ? "-B" : "-b", newBranch, reference);
        }
        h2.endOptions();
        for (GitLineHandlerListener listener : listeners) {
            h2.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(51);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository repository, @NotNull String branchName, @Nullable GitLineHandlerListener listener) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(52);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(53);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h2.setSilent(false);
        h2.setStdoutSuppressed(false);
        h2.addParameters("-b");
        h2.addParameters(branchName);
        if (listener != null) {
            h2.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(54);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository repository, @NotNull String tagName, @Nullable GitLineHandlerListener listener, @NotNull String reference) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(55);
        }
        if (tagName == null) {
            GitImpl.$$$reportNull$$$0(56);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(57);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h2.setSilent(false);
        h2.addParameters(tagName);
        if (!reference.isEmpty()) {
            h2.addParameters(reference);
        }
        if (listener != null) {
            h2.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(58);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult deleteTag(@NotNull GitRepository repository, @NotNull String tagName, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(59);
        }
        if (tagName == null) {
            GitImpl.$$$reportNull$$$0(60);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(61);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h2.setSilent(false);
        h2.addParameters("-d");
        h2.addParameters(tagName);
        for (GitLineHandlerListener listener : listeners) {
            h2.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(62);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository repository, @NotNull String branchName, boolean force, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(63);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(64);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(65);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h2.setSilent(false);
        h2.setStdoutSuppressed(false);
        h2.addParameters(force ? "-D" : "-d");
        h2.addParameters(branchName);
        for (GitLineHandlerListener listener : listeners) {
            h2.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(66);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String startPoint) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(67);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(68);
        }
        if (startPoint == null) {
            GitImpl.$$$reportNull$$$0(69);
        }
        GitCommandResult gitCommandResult = this.branchCreate(repository, branchName, startPoint, false);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(70);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String startPoint, boolean force) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(71);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(72);
        }
        if (startPoint == null) {
            GitImpl.$$$reportNull$$$0(73);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h2.setStdoutSuppressed(false);
        if (force) {
            h2.addParameters("-f");
        }
        h2.addParameters(branchName);
        h2.addParameters(startPoint);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(74);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult setUpstream(@NotNull GitRepository repository, @NotNull String upstreamBranchName, @NotNull String branchName) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(75);
        }
        if (upstreamBranchName == null) {
            GitImpl.$$$reportNull$$$0(76);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(77);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h2.setStdoutSuppressed(false);
        if (GitVersionSpecialty.KNOWS_SET_UPSTREAM_TO.existsIn(repository)) {
            h2.addParameters("--set-upstream-to", upstreamBranchName, branchName);
        } else {
            h2.addParameters("--set-upstream", branchName, upstreamBranchName);
        }
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(78);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult renameBranch(@NotNull GitRepository repository, @NotNull String currentName, @NotNull String newName, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(79);
        }
        if (currentName == null) {
            GitImpl.$$$reportNull$$$0(80);
        }
        if (newName == null) {
            GitImpl.$$$reportNull$$$0(81);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(82);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h2.setSilent(false);
        h2.setStdoutSuppressed(false);
        h2.addParameters("-m", currentName, newName);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(83);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult reset(@NotNull GitRepository repository, @NotNull GitResetMode mode, @NotNull String target, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(84);
        }
        if (mode == null) {
            GitImpl.$$$reportNull$$$0(85);
        }
        if (target == null) {
            GitImpl.$$$reportNull$$$0(86);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(87);
        }
        return this.reset(repository, mode.getArgument(), target, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository repository, @Nullable String revision) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(88);
        }
        return this.reset(repository, "--merge", revision, new GitLineHandlerListener[0]);
    }

    @NotNull
    private GitCommandResult reset(@NotNull GitRepository repository, @NotNull String argument, @Nullable String target, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(89);
        }
        if (argument == null) {
            GitImpl.$$$reportNull$$$0(90);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(91);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.RESET);
        handler.addParameters(argument);
        if (target != null) {
            handler.addParameters(target);
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(92);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult tip(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(93);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(94);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        h2.addParameters("-1");
        h2.addParameters(branchName);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(95);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull String remote, @Nullable String url, @NotNull String spec, boolean updateTracking, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(96);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(97);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(98);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(99);
        }
        return this.doPush(repository, remote, Collections.singleton(url), spec, false, updateTracking, false, Collections.emptyList(), null, listeners);
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull GitPushParams pushParams, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(100);
        }
        if (pushParams == null) {
            GitImpl.$$$reportNull$$$0(101);
        }
        return this.doPush(repository, pushParams.getRemote().getName(), pushParams.getRemote().getPushUrls(), pushParams.getSpec(), pushParams.isForce(), pushParams.shouldSetupTracking(), pushParams.shouldSkipHooks(), pushParams.getForceWithLease(), pushParams.getTagMode(), listeners);
    }

    @NotNull
    private GitCommandResult doPush(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull Collection<String> remoteUrls, @NotNull String spec, boolean force, boolean updateTracking, boolean skipHook, List<? extends GitPushParams.ForceWithLease> forceWithLease, @Nullable String tagMode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(102);
        }
        if (remoteName == null) {
            GitImpl.$$$reportNull$$$0(103);
        }
        if (remoteUrls == null) {
            GitImpl.$$$reportNull$$$0(104);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(105);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(106);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.PUSH);
            h2.setUrls(remoteUrls);
            h2.setSilent(false);
            h2.setStdoutSuppressed(false);
            GitImpl.addListeners(h2, listeners);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(repository)) {
                h2.addParameters("--progress");
            }
            h2.addParameters("--porcelain");
            h2.addParameters(remoteName);
            h2.addParameters(spec);
            if (updateTracking) {
                h2.addParameters("--set-upstream");
            }
            if (GitVersionSpecialty.SUPPORTS_FORCE_PUSH_WITH_LEASE.existsIn(repository) && !forceWithLease.isEmpty()) {
                for (GitPushParams.ForceWithLease lease : forceWithLease) {
                    String parameter = lease.getParameter();
                    if (parameter != null) {
                        h2.addParameters("--force-with-lease=" + parameter);
                        continue;
                    }
                    h2.addParameters("--force-with-lease");
                }
            } else if (force) {
                h2.addParameters("--force");
            }
            if (tagMode != null) {
                h2.addParameters(tagMode);
            }
            if (skipHook) {
                h2.addParameters("--no-verify");
            }
            return h2;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(107);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult show(@NotNull GitRepository repository, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(108);
        }
        if (params == null) {
            GitImpl.$$$reportNull$$$0(109);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.SHOW);
        handler.addParameters(params);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(110);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository, @NotNull String hash, boolean autoCommit, boolean addCherryPickedFromSuffix, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(111);
        }
        if (hash == null) {
            GitImpl.$$$reportNull$$$0(112);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(113);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHERRY_PICK);
        if (addCherryPickedFromSuffix) {
            handler.addParameters("-x");
        }
        if (!autoCommit) {
            handler.addParameters("-n");
        }
        handler.addParameters(hash);
        GitImpl.addListeners(handler, listeners);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(114);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository repository) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(115);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.LS_FILES);
        h2.addParameters("--unmerged");
        h2.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(116);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<? extends GitLineHandlerListener> listeners, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(117);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(118);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(119);
        }
        GitCommandResult gitCommandResult = this.fetch(repository, remote, listeners, (GitAuthenticationGate)null, params);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(120);
        }
        return gitCommandResult;
    }

    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<? extends GitLineHandlerListener> listeners, @Nullable GitAuthenticationGate authenticationGate, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(121);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(122);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(123);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.FETCH);
            if (authenticationGate != null) {
                h2.setAuthenticationGate(authenticationGate);
            }
            h2.setSilent(false);
            h2.setStdoutSuppressed(false);
            h2.setUrls(remote.getUrls());
            h2.addParameters(remote.getName());
            h2.addParameters(params);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(repository)) {
                h2.addParameters("--progress");
            }
            if (GitVersionSpecialty.SUPPORTS_FETCH_PRUNE.existsIn(repository)) {
                h2.addParameters("--prune");
            }
            GitImpl.addListeners(h2, listeners);
            return h2;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(124);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult addRemote(@NotNull GitRepository repository, @NotNull String name, @NotNull String url) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(125);
        }
        if (name == null) {
            GitImpl.$$$reportNull$$$0(126);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(127);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h2.addParameters("add", name, url);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(128);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult removeRemote(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(129);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(130);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h2.addParameters("remove", remote.getName());
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(131);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult renameRemote(@NotNull GitRepository repository, @NotNull String oldName, @NotNull String newName) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(132);
        }
        if (oldName == null) {
            GitImpl.$$$reportNull$$$0(133);
        }
        if (newName == null) {
            GitImpl.$$$reportNull$$$0(134);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h2.addParameters("rename", oldName, newName);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(135);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult setRemoteUrl(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull String newUrl) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(136);
        }
        if (remoteName == null) {
            GitImpl.$$$reportNull$$$0(137);
        }
        if (newUrl == null) {
            GitImpl.$$$reportNull$$$0(138);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h2.addParameters("set-url", remoteName, newUrl);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(139);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String url) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(140);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(141);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(142);
        }
        return this.doLsRemote(project, workingDir, url, Collections.singleton(url), Collections.emptyList(), new String[0]);
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(143);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(144);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(145);
        }
        GitCommandResult gitCommandResult = this.lsRemoteRefs(project, workingDir, remote, Collections.emptyList(), additionalParameters);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(146);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemoteRefs(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, @NotNull List<String> refs, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(147);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(148);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(149);
        }
        if (refs == null) {
            GitImpl.$$$reportNull$$$0(150);
        }
        return this.doLsRemote(project, VfsUtilCore.virtualToIoFile((VirtualFile)workingDir), remote.getName(), remote.getUrls(), refs, additionalParameters);
    }

    @Override
    @NotNull
    public GitCommandResult remotePrune(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(151);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(152);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE.writeLockingCommand());
            h2.setStdoutSuppressed(false);
            h2.addParameters("prune");
            h2.addParameters(remote.getName());
            h2.setUrls(remote.getUrls());
            return h2;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(153);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebase(@NotNull GitRepository repository, @NotNull GitRebaseParams parameters, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(154);
        }
        if (parameters == null) {
            GitImpl.$$$reportNull$$$0(155);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(156);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(parameters.asCommandLineArguments());
        GitImpl.addListeners(handler, listeners);
        if (parameters.isInteractive()) {
            GitRebaseEditorHandler editorHandler = parameters.getEditorHandler();
            if (editorHandler == null) {
                editorHandler = this.createEditor(project, root, handler, true);
            }
            return this.runWithEditor(handler, editorHandler);
        }
        GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.normal(this.runCommand(handler));
        if (gitRebaseCommandResult == null) {
            GitImpl.$$$reportNull$$$0(157);
        }
        return gitRebaseCommandResult;
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseAbort(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(158);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(159);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REBASE);
        handler.addParameters("--abort");
        GitImpl.addListeners(handler, listeners);
        GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.normal(this.runCommand(handler));
        if (gitRebaseCommandResult == null) {
            GitImpl.$$$reportNull$$$0(160);
        }
        return gitRebaseCommandResult;
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseContinue(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(161);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(162);
        }
        return this.rebaseResume(repository, GitRebaseResumeMode.CONTINUE, listeners);
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseSkip(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(163);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(164);
        }
        return this.rebaseResume(repository, GitRebaseResumeMode.SKIP, listeners);
    }

    @NotNull
    private GitRebaseCommandResult rebaseResume(@NotNull GitRepository repository, @NotNull GitRebaseResumeMode rebaseMode, GitLineHandlerListener @NotNull [] listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(165);
        }
        if (rebaseMode == null) {
            GitImpl.$$$reportNull$$$0(166);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(167);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(rebaseMode.asCommandLineArgument());
        GitImpl.addListeners(handler, listeners);
        return this.runWithEditor(handler, this.createEditor(project, root, handler, false));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private GitRebaseCommandResult runWithEditor(@NotNull GitLineHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(168);
        }
        if (editorHandler == null) {
            GitImpl.$$$reportNull$$$0(169);
        }
        GitHandlerRebaseEditorManager ignored = GitHandlerRebaseEditorManager.prepareEditor(handler, editorHandler);
        GitCommandResult result2 = this.runCommand(handler);
        if (editorHandler.wasCommitListEditorCancelled()) {
            GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.cancelledInCommitList(result2);
            GitRebaseCommandResult gitRebaseCommandResult2 = gitRebaseCommandResult;
            if (gitRebaseCommandResult2 == null) {
                GitImpl.$$$reportNull$$$0(170);
            }
            return gitRebaseCommandResult2;
        }
        if (editorHandler.wasUnstructuredEditorCancelled()) {
            GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.cancelledInCommitMessage(result2);
            GitRebaseCommandResult gitRebaseCommandResult3 = gitRebaseCommandResult;
            if (gitRebaseCommandResult3 == null) {
                GitImpl.$$$reportNull$$$0(171);
            }
            return gitRebaseCommandResult3;
        }
        GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.normal(result2);
        GitRebaseCommandResult gitRebaseCommandResult4 = gitRebaseCommandResult;
        if (gitRebaseCommandResult4 == null) {
            GitImpl.$$$reportNull$$$0(172);
        }
        return gitRebaseCommandResult4;
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @VisibleForTesting
    @NotNull
    protected GitInteractiveRebaseEditorHandler createEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, boolean commitListAware) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(173);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(174);
        }
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(175);
        }
        GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(project, root);
        if (!commitListAware) {
            editor.setRebaseEditorShown();
        }
        GitInteractiveRebaseEditorHandler gitInteractiveRebaseEditorHandler = editor;
        if (gitInteractiveRebaseEditorHandler == null) {
            GitImpl.$$$reportNull$$$0(176);
        }
        return gitInteractiveRebaseEditorHandler;
    }

    @Override
    @NotNull
    public GitCommandResult revert(@NotNull GitRepository repository, @NotNull String commit, boolean autoCommit, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(177);
        }
        if (commit == null) {
            GitImpl.$$$reportNull$$$0(178);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(179);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REVERT);
        handler.addParameters(commit);
        if (!autoCommit) {
            handler.addParameters("--no-commit");
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(180);
        }
        return gitCommandResult;
    }

    @Override
    @Nullable
    public Hash resolveReference(@NotNull GitRepository repository, @NotNull String ref) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(181);
        }
        if (ref == null) {
            GitImpl.$$$reportNull$$$0(182);
        }
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(repository.getProject(), root, GitCommand.REV_PARSE);
        handler.addParameters("--verify");
        handler.addParameters(ref + "^{commit}");
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String output = result2.getOutputAsJoinedString();
        if (result2.success()) {
            if (VcsLogUtil.HASH_REGEX.matcher(output).matches()) {
                return HashImpl.build((String)output);
            }
            LOG.error("Invalid output for git rev-parse " + ref + " in " + root + ": " + output);
            return null;
        }
        LOG.debug("Reference [" + ref + "] is unknown to Git in " + root);
        return null;
    }

    @NotNull
    private GitCommandResult doLsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String remoteId, @NotNull Collection<String> authenticationUrls, @NotNull List<String> refs, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(183);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(184);
        }
        if (remoteId == null) {
            GitImpl.$$$reportNull$$$0(185);
        }
        if (authenticationUrls == null) {
            GitImpl.$$$reportNull$$$0(186);
        }
        if (refs == null) {
            GitImpl.$$$reportNull$$$0(187);
        }
        GitCommandResult gitCommandResult = this.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> {
            GitLineHandler h2 = new GitLineHandler(project, workingDir, GitCommand.LS_REMOTE);
            h2.addParameters(additionalParameters);
            h2.addParameters(remoteId);
            h2.addParameters(refs);
            h2.setUrls(authenticationUrls);
            return h2;
        }));
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(188);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getObjectType(@NotNull GitRepository repository, @NotNull String object) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(189);
        }
        if (object == null) {
            GitImpl.$$$reportNull$$$0(190);
        }
        GitLineHandler h2 = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CAT_FILE);
        h2.setSilent(true);
        h2.addParameters("-t", object);
        GitCommandResult gitCommandResult = this.runCommand(h2);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(191);
        }
        return gitCommandResult;
    }

    @Override
    @Nullable
    public GitObjectType getObjectTypeEnum(@NotNull GitRepository repository, @NotNull String object) {
        GitCommandResult result2;
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(192);
        }
        if (object == null) {
            GitImpl.$$$reportNull$$$0(193);
        }
        if (!(result2 = this.getObjectType(repository, object)).success()) {
            return null;
        }
        String string = result2.getOutputAsJoinedString();
        try {
            return GitObjectType.valueOf(StringUtil.toUpperCase((String)string));
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static void addListeners(@NotNull GitLineHandler handler, GitLineHandlerListener ... listeners) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(194);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(195);
        }
        GitImpl.addListeners(handler, Arrays.asList(listeners));
    }

    private static void addListeners(@NotNull GitLineHandler handler, @NotNull List<? extends GitLineHandlerListener> listeners) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(196);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(197);
        }
        for (GitLineHandlerListener gitLineHandlerListener : listeners) {
            handler.addLineListener(gitLineHandlerListener);
        }
    }

    @NotNull
    public static String runBundledCommand(@Nullable Project project, String ... args) throws VcsException {
        String string;
        if (project != null && !TrustedProjects.isTrusted((Project)project)) {
            throw new IllegalStateException("Shouldn't be possible to run a Git command in the safe mode");
        }
        try {
            GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(project);
            GeneralCommandLine command = gitExecutable.createBundledCommandLine(project, args);
            command.setCharset(StandardCharsets.UTF_8);
            final StringBuilder output = new StringBuilder();
            OSProcessHandler handler = new OSProcessHandler(command);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        output.append(event.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "git4idea/commands/GitImpl$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            handler.startNotify();
            handler.waitFor();
            string = output.toString();
        }
        catch (ExecutionException e) {
            throw new VcsException((Throwable)e);
        }
        if (string == null) {
            GitImpl.$$$reportNull$$$0(198);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 23: 
            case 25: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: 
            case 83: 
            case 92: 
            case 95: 
            case 107: 
            case 110: 
            case 114: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 139: 
            case 146: 
            case 153: 
            case 157: 
            case 160: 
            case 170: 
            case 171: 
            case 172: 
            case 176: 
            case 180: 
            case 188: 
            case 191: 
            case 198: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 23: 
            case 25: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: 
            case 83: 
            case 92: 
            case 95: 
            case 107: 
            case 110: 
            case 114: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 139: 
            case 146: 
            case 153: 
            case 157: 
            case 160: 
            case 170: 
            case 171: 
            case 172: 
            case 176: 
            case 180: 
            case 188: 
            case 191: 
            case 198: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 13: 
            case 16: 
            case 18: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 22: 
            case 38: 
            case 42: 
            case 46: 
            case 50: 
            case 61: 
            case 65: 
            case 82: 
            case 87: 
            case 91: 
            case 99: 
            case 106: 
            case 113: 
            case 119: 
            case 123: 
            case 156: 
            case 159: 
            case 162: 
            case 164: 
            case 167: 
            case 179: 
            case 195: 
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 23: 
            case 25: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: 
            case 83: 
            case 92: 
            case 95: 
            case 107: 
            case 110: 
            case 114: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 139: 
            case 146: 
            case 153: 
            case 157: 
            case 160: 
            case 170: 
            case 171: 
            case 172: 
            case 176: 
            case 180: 
            case 188: 
            case 191: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatusPrefix";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 20: 
            case 127: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clonedDirectoryName";
                break;
            }
            case 24: 
            case 26: 
            case 30: 
            case 34: 
            case 37: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 75: 
            case 79: 
            case 84: 
            case 88: 
            case 89: 
            case 93: 
            case 96: 
            case 100: 
            case 102: 
            case 108: 
            case 111: 
            case 115: 
            case 117: 
            case 121: 
            case 125: 
            case 129: 
            case 132: 
            case 136: 
            case 151: 
            case 154: 
            case 158: 
            case 161: 
            case 163: 
            case 165: 
            case 177: 
            case 181: 
            case 189: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 27: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToMerge";
                break;
            }
            case 45: 
            case 49: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 53: 
            case 64: 
            case 68: 
            case 72: 
            case 77: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstreamBranchName";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 81: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 97: 
            case 118: 
            case 122: 
            case 130: 
            case 145: 
            case 149: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 98: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushParams";
                break;
            }
            case 103: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrls";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUrl";
                break;
            }
            case 141: 
            case 144: 
            case 148: 
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 150: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseMode";
                break;
            }
            case 168: 
            case 175: 
            case 194: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorHandler";
                break;
            }
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteId";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationUrls";
                break;
            }
            case 190: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "untrackedFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "config";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAttr";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "stashSave";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "stashPop";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 47: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "checkout";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "checkoutNewBranch";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTag";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteTag";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "branchDelete";
                break;
            }
            case 70: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "branchCreate";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpstream";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "renameBranch";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "reset";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "tip";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "doPush";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "cherryPick";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedFiles";
                break;
            }
            case 120: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "addRemote";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRemote";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "renameRemote";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoteUrl";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemote";
                break;
            }
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "remotePrune";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "rebase";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseAbort";
                break;
            }
            case 170: 
            case 171: 
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithEditor";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "revert";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "doLsRemote";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 198: {
                objectArray = objectArray2;
                objectArray2[1] = "runBundledCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 23: 
            case 25: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: 
            case 83: 
            case 92: 
            case 95: 
            case 107: 
            case 110: 
            case 114: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 139: 
            case 146: 
            case 153: 
            case 157: 
            case 160: 
            case 170: 
            case 171: 
            case 172: 
            case 176: 
            case 180: 
            case 188: 
            case 191: 
            case 198: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ignoredFilePaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ignoredFilePathsNoChunk";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseFiles";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFilePaths";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFilePathsNoChunk";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "config";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAttr";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "stashSave";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "stashPop";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranch";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createNewTag";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "deleteTag";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "branchDelete";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "branchCreate";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "setUpstream";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "renameBranch";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "resetMerge";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "tip";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "doPush";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "addRemote";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "removeRemote";
                break;
            }
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "renameRemote";
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "setRemoteUrl";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "lsRemote";
                break;
            }
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "lsRemoteRefs";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "remotePrune";
                break;
            }
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "rebaseAbort";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "rebaseContinue";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSkip";
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "rebaseResume";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "runWithEditor";
                break;
            }
            case 173: 
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 177: 
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "doLsRemote";
                break;
            }
            case 189: 
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "getObjectType";
                break;
            }
            case 192: 
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypeEnum";
                break;
            }
            case 194: 
            case 195: 
            case 196: 
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "addListeners";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 11: 
            case 14: 
            case 23: 
            case 25: 
            case 29: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 58: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: 
            case 83: 
            case 92: 
            case 95: 
            case 107: 
            case 110: 
            case 114: 
            case 116: 
            case 120: 
            case 124: 
            case 128: 
            case 131: 
            case 135: 
            case 139: 
            case 146: 
            case 153: 
            case 157: 
            case 160: 
            case 170: 
            case 171: 
            case 172: 
            case 176: 
            case 180: 
            case 188: 
            case 191: 
            case 198: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

