/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.i18n.GitBundleExtensions;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.MergeConflictMultipleCommitInfoDialog;
import git4idea.merge.RefInfo;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\u001a!\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0012\u0010\u0007\u001a\u00020\u00022\b\b\u0001\u0010\b\u001a\u00020\u0002H\u0000\u001a\u001e\u0010\t\u001a\u00020\u00022\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a*\u0010\f\u001a\u00020\u00022\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u00022\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a!\u0010\u000f\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0001\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0001\u001a,\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0002H\u0000\u001a@\u0010\u0019\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u001c\u0010\u001a\u001a\u0018\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u0003\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u001bH\u0000\u001a \u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u0014\u001a\u00020\u00022\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0000\u001a\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u000bH\u0002\u001a\u0012\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u001a\u0012\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0006H\u0003\u001a\u0012\u0010&\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u001a\u001c\u0010'\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\b\b\u0001\u0010(\u001a\u00020\u0002H\u0002\u001a\f\u0010)\u001a\u00020**\u00020+H\u0002\u00a8\u0006,"}, d2={"getCurrentBranchNameSet", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "roots", "", "Lgit4idea/repo/GitRepository;", "getDefaultLeftPanelTitleForBranch", "branchName", "getDefaultRightPanelTitleForBranch", "baseHash", "Lcom/intellij/vcs/log/Hash;", "getDescriptionForRebase", "rebasingBranch", "baseBranch", "getMergeBranchNameSet", "getSingleCurrentBranchName", "getSingleMergeBranchName", "getTitleWithCommitDetailsCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "title", "repository", "file", "Lcom/intellij/openapi/vcs/FilePath;", "commit", "getTitleWithCommitsRangeDetailsCustomizer", "range", "Lkotlin/Pair;", "getTitleWithShowDetailsAction", "Ljavax/swing/JPanel;", "action", "Lkotlin/Function0;", "", "resolveBranchName", "Lgit4idea/merge/RefInfo;", "hash", "resolveMergeBranch", "resolveMergeBranchOrCherryPick", "resolveRebaseOntoBranch", "tryResolveRef", "ref", "toInt", "", "", "intellij.vcs.git"})
public final class GitDefaultMergeDialogCustomizerKt {
    @NotNull
    public static final String getDescriptionForRebase(@NlsSafe @Nullable String rebasingBranch, @NlsSafe @Nullable String baseBranch, @Nullable Hash baseHash) {
        String string;
        if (baseBranch != null) {
            Object[] objectArray = new Object[5];
            objectArray[0] = GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null);
            String string2 = rebasingBranch;
            if (string2 == null) {
                string2 = "";
            }
            HtmlChunk.Element element = HtmlChunk.text((String)string2).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"text(rebasingBranch ?: \"\").bold()");
            objectArray[1] = element;
            HtmlChunk.Element element2 = HtmlChunk.text((String)baseBranch).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"text(baseBranch).bold()");
            objectArray[2] = element2;
            objectArray[3] = GitDefaultMergeDialogCustomizerKt.toInt(baseHash != null);
            Object object = baseHash;
            if (object == null || (object = object.toShortString()) == null) {
                object = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"baseHash?.toShortString() ?: \"\"");
            objectArray[4] = object;
            string = GitBundleExtensions.html("merge.dialog.description.rebase.with.onto.branch.label.text", objectArray);
        } else if (baseHash != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null);
            String string3 = rebasingBranch;
            if (string3 == null) {
                string3 = "";
            }
            HtmlChunk.Element element = HtmlChunk.text((String)string3).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"text(rebasingBranch ?: \"\").bold()");
            objectArray[1] = element;
            HtmlChunk.Element element3 = HtmlChunk.text((String)baseHash.toShortString()).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"text(baseHash.toShortString()).bold()");
            objectArray[2] = element3;
            string = GitBundleExtensions.html("merge.dialog.description.rebase.with.hash.label.text", objectArray);
        } else {
            Object[] objectArray = new Object[2];
            objectArray[0] = GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null);
            String string4 = rebasingBranch;
            if (string4 == null) {
                string4 = "";
            }
            HtmlChunk.Element element = HtmlChunk.text((String)string4).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"text(rebasingBranch ?: \"\").bold()");
            objectArray[1] = element;
            string = GitBundleExtensions.html("merge.dialog.description.rebase.without.onto.info.label.text", objectArray);
        }
        return string;
    }

    @NotNull
    public static final String getDefaultLeftPanelTitleForBranch(@NlsSafe @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        Object[] objectArray = new Object[1];
        HtmlChunk.Element element = HtmlChunk.text((String)branchName).bold();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"text(branchName).bold()");
        objectArray[0] = element;
        return GitBundleExtensions.html("merge.dialog.diff.left.title.default.branch.label.text", objectArray);
    }

    @NotNull
    public static final String getDefaultRightPanelTitleForBranch(@NlsSafe @Nullable String branchName, @Nullable Hash baseHash) {
        String string;
        if (branchName != null) {
            Object[] objectArray = new Object[3];
            HtmlChunk.Element element = HtmlChunk.text((String)branchName).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"text(branchName).bold()");
            objectArray[0] = element;
            objectArray[1] = GitDefaultMergeDialogCustomizerKt.toInt(baseHash != null);
            Object object = baseHash;
            if (object == null || (object = object.toShortString()) == null) {
                object = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"baseHash?.toShortString() ?: \"\"");
            objectArray[2] = object;
            string = GitBundleExtensions.html("merge.dialog.diff.right.title.default.with.onto.branch.label.text", objectArray);
        } else if (baseHash != null) {
            Object[] objectArray = new Object[1];
            HtmlChunk.Element element = HtmlChunk.text((String)baseHash.toShortString()).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"text(baseHash.toShortString()).bold()");
            objectArray[0] = element;
            string = GitBundleExtensions.html("merge.dialog.diff.right.title.default.with.hash.label.text", objectArray);
        } else {
            String string2 = GitBundle.message("merge.dialog.diff.right.title.default.without.onto.info.label.text", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"merge\u2026ut.onto.info.label.text\")");
        }
        return string;
    }

    @NlsSafe
    private static final String resolveMergeBranchOrCherryPick(GitRepository repository) {
        RefInfo mergeBranch = GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository);
        if (mergeBranch != null) {
            return mergeBranch.getPresentable();
        }
        RefInfo rebaseOntoBranch = GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository);
        if (rebaseOntoBranch != null) {
            return rebaseOntoBranch.getPresentable();
        }
        Hash cherryHead = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, "CHERRY_PICK_HEAD");
        if (cherryHead != null) {
            return "cherry-pick";
        }
        return null;
    }

    private static final RefInfo resolveMergeBranch(GitRepository repository) {
        Hash hash = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, "MERGE_HEAD");
        if (hash == null) {
            return null;
        }
        Hash mergeHead = hash;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repository, mergeHead);
    }

    private static final RefInfo resolveRebaseOntoBranch(GitRepository repository) {
        Hash hash = GitRebaseUtils.getOntoHash(repository.getProject(), repository.getRoot());
        if (hash == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"GitRebaseUtils.getOntoHa\u2026tory.root) ?: return null");
        Hash ontoHash = hash;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(repository.getProject()).getRepositoryForRoot(repository.getRoot());
        if (gitRepository == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"GitRepositoryManager.get\u2026tory.root) ?: return null");
        GitRepository repo = gitRepository;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repo, ontoHash);
    }

    private static final RefInfo resolveBranchName(GitRepository repository, Hash hash) {
        Collection<GitLocalBranch> collection = repository.getBranches().findLocalBranchesByHash(hash);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.branches.findLocalBranchesByHash(hash)");
        Collection<GitBranch> branches2 = collection;
        if (branches2.isEmpty()) {
            Collection<GitRemoteBranch> collection2 = repository.getBranches().findRemoteBranchesByHash(hash);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"repository.branches.findRemoteBranchesByHash(hash)");
            branches2 = collection2;
        }
        GitBranch gitBranch = (GitBranch)CollectionsKt.singleOrNull((Iterable)branches2);
        return new RefInfo(hash, gitBranch != null ? gitBranch.getName() : null);
    }

    private static final Hash tryResolveRef(GitRepository repository, @NlsSafe String ref) {
        try {
            GitRevisionNumber gitRevisionNumber = GitRevisionNumber.resolve(repository.getProject(), repository.getRoot(), ref);
            Intrinsics.checkNotNullExpressionValue((Object)gitRevisionNumber, (String)"GitRevisionNumber.resolv\u2026ct, repository.root, ref)");
            GitRevisionNumber revision = gitRevisionNumber;
            return HashImpl.build((String)revision.asString());
        }
        catch (VcsException e) {
            return null;
        }
    }

    @NlsSafe
    @Nullable
    public static final String getSingleMergeBranchName(@NotNull Collection<? extends GitRepository> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        return (String)CollectionsKt.singleOrNull((Iterable)GitDefaultMergeDialogCustomizerKt.getMergeBranchNameSet(roots));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> getMergeBranchNameSet(Collection<? extends GitRepository> roots) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = roots;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GitRepository repo = (GitRepository)element$iv$iv;
            boolean bl2 = false;
            if (GitDefaultMergeDialogCustomizerKt.resolveMergeBranchOrCherryPick(repo) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NlsSafe
    @Nullable
    public static final String getSingleCurrentBranchName(@NotNull Collection<? extends GitRepository> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        return (String)CollectionsKt.singleOrNull((Iterable)GitDefaultMergeDialogCustomizerKt.getCurrentBranchNameSet(roots));
    }

    private static final Set<String> getCurrentBranchNameSet(Collection<? extends GitRepository> roots) {
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots), (Function1)getCurrentBranchNameSet.1.INSTANCE));
    }

    @NotNull
    public static final DiffEditorTitleCustomizer getTitleWithCommitDetailsCustomizer(@Nls @NotNull String title, @NotNull GitRepository repository, @NotNull FilePath file, @NlsSafe @NotNull String commit) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return new DiffEditorTitleCustomizer(title, repository, commit, file){
            final /* synthetic */ String $title;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ String $commit;
            final /* synthetic */ FilePath $file;

            @NotNull
            public final JComponent getLabel() {
                return GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction(this.$title, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ getTitleWithCommitDetailsCustomizer.1 this$0;

                    public final void invoke() {
                        LoadingCommittedChangeListPanel panel2 = new LoadingCommittedChangeListPanel(this.this$0.$repository.getProject());
                        panel2.loadChangesInBackground(new ThrowableComputable(this){
                            final /* synthetic */ getTitleWithCommitDetailsCustomizer.1 this$0;

                            public final LoadingCommittedChangeListPanel.ChangelistData compute() {
                                GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(this.this$0.this$0.$repository.getProject(), this.this$0.this$0.$repository.getRoot(), this.this$0.this$0.$commit, true, false, false);
                                return new LoadingCommittedChangeListPanel.ChangelistData((CommittedChangeList)changeList, this.this$0.this$0.$file);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        ChangeListViewerDialog dlg = new ChangeListViewerDialog(this.this$0.$repository.getProject(), panel2);
                        dlg.setTitle(StringUtil.stripHtml((String)this.this$0.$title, (boolean)false));
                        dlg.setModal(true);
                        dlg.show();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$title = string;
                this.$repository = gitRepository;
                this.$commit = string2;
                this.$file = filePath;
            }
        };
    }

    @NotNull
    public static final DiffEditorTitleCustomizer getTitleWithCommitsRangeDetailsCustomizer(@NlsContexts.Label @NotNull String title, @NotNull GitRepository repository, @NotNull FilePath file, @NotNull Pair<String, String> range) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        return new DiffEditorTitleCustomizer(title, repository, file, range){
            final /* synthetic */ String $title;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ FilePath $file;
            final /* synthetic */ Pair $range;

            @NotNull
            public final JComponent getLabel() {
                return GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction(this.$title, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;

                    public final void invoke() {
                        boolean bl = false;
                        List details = new ArrayList<E>();
                        HashSet<E> filteredCommits = new HashSet<E>();
                        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, filteredCommits, details){
                            final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;
                            final /* synthetic */ HashSet $filteredCommits;
                            final /* synthetic */ List $details;

                            public final void run() {
                                GitLogUtil.readFullDetails(this.this$0.this$0.$repository.getProject(), this.this$0.this$0.$repository.getRoot(), (Consumer<? super GitCommit>)new Consumer(this){
                                    final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;

                                    public final void consume(GitCommit commit) {
                                        GitCommit gitCommit = commit;
                                        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitCommit), (String)"commit");
                                        VcsCommitMetadataImpl commitMetadata = new VcsCommitMetadataImpl(gitCommit.getId(), commit.getParents(), commit.getCommitTime(), commit.getRoot(), commit.getSubject(), commit.getAuthor(), commit.getFullMessage(), commit.getCommitter(), commit.getAuthorTime());
                                        if (commit.getAffectedPaths().contains(this.this$0.this$0.this$0.$file)) {
                                            this.this$0.$filteredCommits.add(commitMetadata);
                                        }
                                        this.this$0.$details.add(commitMetadata);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                }, (String)this.this$0.this$0.$range.getFirst() + ".." + (String)this.this$0.this$0.$range.getSecond());
                            }
                            {
                                this.this$0 = var1_1;
                                this.$filteredCommits = hashSet;
                                this.$details = list2;
                            }
                        }, GitBundle.message("merge.dialog.customizer.collecting.details.progress", new Object[0]), true, this.this$0.$repository.getProject());
                        Project project = this.this$0.$repository.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
                        VirtualFile virtualFile = this.this$0.$repository.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
                        MergeConflictMultipleCommitInfoDialog dlg = new MergeConflictMultipleCommitInfoDialog(project, virtualFile, details, (Set<? extends VcsCommitMetadata>)filteredCommits);
                        dlg.setTitle(StringUtil.stripHtml((String)this.this$0.$title, (boolean)false));
                        dlg.show();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$title = string;
                this.$repository = gitRepository;
                this.$file = filePath;
                this.$range = pair;
            }
        };
    }

    @NotNull
    public static final JPanel getTitleWithShowDetailsAction(@Nls @NotNull String title, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel().addToCenter((Component)new JBLabel(title).setCopyable(true));
        String string = GitBundle.message("merge.dialog.customizer.show.details.link.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"merge\u2026show.details.link.label\")");
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel.addToRight((Component)new ActionLink(string, (Function1)new Function1<ActionEvent, Unit>(action){
            final /* synthetic */ Function0 $action;

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$action.invoke();
            }
            {
                this.$action = function0;
                super(1);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"BorderLayoutPanel()\n    \u2026nk.label\")) { action() })");
        return (JPanel)borderLayoutPanel2;
    }

    private static final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }

    public static final /* synthetic */ RefInfo access$resolveMergeBranch(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository);
    }

    public static final /* synthetic */ Set access$getCurrentBranchNameSet(Collection roots) {
        return GitDefaultMergeDialogCustomizerKt.getCurrentBranchNameSet(roots);
    }

    public static final /* synthetic */ RefInfo access$resolveRebaseOntoBranch(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository);
    }

    public static final /* synthetic */ int access$toInt(boolean $this$access_u24toInt) {
        return GitDefaultMergeDialogCustomizerKt.toInt($this$access_u24toInt);
    }

    public static final /* synthetic */ Hash access$tryResolveRef(GitRepository repository, String ref) {
        return GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, ref);
    }
}

