/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vcs.ui.CommitIconTableCellRenderer;
import git4idea.rebase.interactive.dialog.GitRebaseCommitIconTableCellRenderer$WhenMappings;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import git4idea.rebase.interactive.dialog.NodeType;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lgit4idea/rebase/interactive/dialog/GitRebaseCommitIconTableCellRenderer;", "Lcom/intellij/openapi/vcs/ui/CommitIconTableCellRenderer;", "()V", "isHead", "", "nodeType", "Lgit4idea/rebase/interactive/dialog/NodeType;", "nodeWidth", "", "getNodeWidth", "()I", "customizeRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "hasFocus", "row", "column", "drawCommitIcon", "g", "Ljava/awt/Graphics2D;", "drawDoubleNode", "drawEditNode", "intellij.vcs.git"})
final class GitRebaseCommitIconTableCellRenderer
extends CommitIconTableCellRenderer {
    private boolean isHead;
    private NodeType nodeType = NodeType.SIMPLE_NODE;

    protected int getNodeWidth() {
        return GitRebaseCommitsTableView.Companion.getGRAPH_NODE_WIDTH();
    }

    public void customizeRenderer(@Nullable JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table != null && table instanceof GitRebaseCommitsTableView) {
            this.nodeType = ((GitRebaseCommitsTableView)((Object)table)).getDrawNodeType$intellij_vcs_git(row);
            this.isHead = row == ((GitRebaseCommitsTableView)((Object)table)).getRowCount() - 1;
        }
    }

    protected void drawCommitIcon(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int tableRowHeight = this.getRowHeight();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (GitRebaseCommitIconTableCellRenderer$WhenMappings.$EnumSwitchMapping$0[this.nodeType.ordinal()]) {
            case 1: {
                this.drawNode(g);
                break;
            }
            case 2: {
                this.drawDoubleNode(g);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.drawEditNode(g);
                break;
            }
        }
        if (this.nodeType != NodeType.EDIT) {
            this.drawEdge(g, tableRowHeight, false);
            if (!this.isHead) {
                this.drawEdge(g, tableRowHeight, true);
            }
        }
    }

    private final void drawDoubleNode(Graphics2D g) {
        int circleRadius = this.getNodeWidth() / 2;
        int backgroundCircleRadius = circleRadius + 1;
        int leftCircleX0 = this.getNodeCenterX();
        int y0 = this.getNodeCenterY();
        int rightCircleX0 = leftCircleX0 + circleRadius;
        CommitIconTableCellRenderer.drawCircle$default((CommitIconTableCellRenderer)this, (Graphics2D)g, (int)rightCircleX0, (int)y0, (int)0, null, (int)24, null);
        Color color = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background");
        this.drawCircle(g, leftCircleX0, y0, backgroundCircleRadius, color);
        CommitIconTableCellRenderer.drawCircle$default((CommitIconTableCellRenderer)this, (Graphics2D)g, (int)leftCircleX0, (int)y0, (int)0, null, (int)24, null);
    }

    private final void drawEditNode(Graphics2D g) {
        Icon icon = AllIcons.Actions.Pause;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Actions.Pause");
        Icon icon2 = icon;
        icon2.paintIcon(null, g, this.getNodeCenterX() - icon2.getIconWidth() / 2, this.getNodeCenterY() - icon2.getIconHeight() / 2);
    }

    public GitRebaseCommitIconTableCellRenderer() {
        super((Function0)1.INSTANCE, GitRebaseCommitsTableView.Companion.getDEFAULT_CELL_HEIGHT(), GitRebaseCommitsTableView.Companion.getGRAPH_LINE_WIDTH());
    }
}

