/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SmallMapSerializer;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.branchConfig.UrlDescriptor;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0007*\u0001\u0012\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0010J\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\fH\u0086\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myFile", "Ljava/io/File;", "myLock", "myState", "Lorg/jetbrains/idea/svn/SmallMapSerializer;", "", "", "Lorg/jetbrains/idea/svn/api/Url;", "", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchItem;", "activate", "", "createExternalizer", "org/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$createExternalizer$1", "()Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$createExternalizer$1;", "deactivate", "get", "url", "Companion", "intellij.vcs.svn"})
public final class SvnLoadedBranchesStorage {
    private final Object myLock;
    private SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> myState;
    private final File myFile;
    private final Project project;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Collection<SvnBranchItem> get(@NotNull Url url) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer = this.myState;
            collection = smallMapSerializer != null && (smallMapSerializer = smallMapSerializer.get("")) != null ? (Collection)smallMapSerializer.get(url) : null;
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activate() {
        Object object = this.myLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.myState = new SmallMapSerializer(this.myFile, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, this.createExternalizer());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void deactivate() {
        boolean bl = false;
        Map branchLocations = new LinkedHashMap();
        Map<VirtualFile, SvnBranchConfigurationNew> branchConfigurations = SvnBranchConfigurationManager.Companion.getInstance(this.project).getSvnBranchConfigManager().getMapCopy();
        for (SvnBranchConfigurationNew configuration : branchConfigurations.values()) {
            Object object = configuration.getBranchMap();
            boolean bl2 = false;
            Iterator<Map.Entry<Url, InfoStorage<List<SvnBranchItem>>>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void branchLocation;
                Map.Entry<Url, InfoStorage<List<SvnBranchItem>>> entry;
                Map.Entry<Url, InfoStorage<List<SvnBranchItem>>> entry2 = entry = iterator.next();
                boolean bl3 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl3 = false;
                InfoStorage<List<SvnBranchItem>> branches = entry2.getValue();
                branchLocations.put(branchLocation, branches.getValue());
            }
        }
        Object object = this.myLock;
        boolean bl4 = false;
        boolean bl5 = false;
        synchronized (object) {
            boolean bl6 = false;
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer = this.myState;
            Intrinsics.checkNotNull(smallMapSerializer);
            smallMapSerializer.put("", branchLocations);
            SmallMapSerializer<String, Map<Url, Collection<SvnBranchItem>>> smallMapSerializer2 = this.myState;
            Intrinsics.checkNotNull(smallMapSerializer2);
            smallMapSerializer2.force();
            this.myState = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final createExternalizer.1 createExternalizer() {
        return new DataExternalizer<Map<Url, ? extends Collection<? extends SvnBranchItem>>>(){

            /*
             * WARNING - void declaration
             */
            public void save(@NotNull DataOutput out, @NotNull Map<Url, ? extends Collection<SvnBranchItem>> branchLocations) throws IOException {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter(branchLocations, (String)"branchLocations");
                boolean bl = false;
                boolean bl2 = false;
                DataOutput $this$with = out;
                boolean bl3 = false;
                $this$with.writeInt(branchLocations.size());
                Object $this$sortedBy$iv = branchLocations.entrySet();
                boolean $i$f$sortedBy = false;
                boolean bl4 = false;
                Iterator<E> iterator = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Map.Entry it = (Map.Entry)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)((Url)it.getKey()).toDecodedString());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = ((Url)it.getKey()).toDecodedString();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                }).iterator();
                while (iterator.hasNext()) {
                    Comparator comparator;
                    void branchLocation;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                    boolean bl5 = false;
                    $this$sortedBy$iv = (Url)entry2.getKey();
                    entry2 = entry;
                    bl5 = false;
                    Collection branches = (Collection)entry2.getValue();
                    UrlDescriptor.ENCODED_URL_DESCRIPTOR.save($this$with, (Url)branchLocation);
                    $this$with.writeInt(branches.size());
                    Iterable iterable = branches;
                    Intrinsics.checkNotNullExpressionValue((Object)String.CASE_INSENSITIVE_ORDER, (String)"CASE_INSENSITIVE_ORDER");
                    boolean bl6 = false;
                    for (SvnBranchItem item : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator<T>(comparator){
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$comparator = comparator;
                        }

                        public final int compare(T a, T b) {
                            SvnBranchItem it;
                            Comparator comparator = this.$comparator;
                            boolean bl = false;
                            SvnBranchItem svnBranchItem = (SvnBranchItem)a;
                            Comparator comparator2 = comparator;
                            boolean bl2 = false;
                            String string = it.getUrl().toDecodedString();
                            it = (SvnBranchItem)b;
                            bl2 = false;
                            String string2 = it.getUrl().toDecodedString();
                            return comparator2.compare(string, string2);
                        }
                    })) {
                        UrlDescriptor.DECODED_URL_DESCRIPTOR.save($this$with, item.getUrl());
                        $this$with.writeLong(item.getCreationDateMillis());
                        $this$with.writeLong(item.getRevision());
                    }
                }
            }

            @NotNull
            public Map<Url, Collection<SvnBranchItem>> read(@NotNull DataInput in) throws IOException {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                boolean bl = false;
                boolean bl2 = false;
                DataInput $this$with = in;
                boolean bl3 = false;
                boolean bl4 = false;
                Map branchLocations = new LinkedHashMap<K, V>();
                int branchLocationsSize = $this$with.readInt();
                boolean bl5 = false;
                int n = 0;
                int n2 = branchLocationsSize;
                for (n = 0; n < n2; ++n) {
                    int it = n;
                    boolean bl6 = false;
                    Url branchLocation = UrlDescriptor.ENCODED_URL_DESCRIPTOR.read($this$with);
                    int branchesSize = $this$with.readInt();
                    boolean bl7 = false;
                    List branches = new ArrayList<E>();
                    bl7 = false;
                    int n3 = 0;
                    n3 = 0;
                    int n4 = branchesSize;
                    while (n3 < n4) {
                        int it2 = n3++;
                        boolean bl8 = false;
                        Url url = UrlDescriptor.DECODED_URL_DESCRIPTOR.read($this$with);
                        long creationDateMillis = $this$with.readLong();
                        long revision = $this$with.readLong();
                        branches.add(new SvnBranchItem(url, creationDateMillis, revision));
                    }
                    branchLocations.put(branchLocation, branches);
                }
                return branchLocations;
            }
        };
    }

    public SvnLoadedBranchesStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myLock = new Object();
        File vcsFile = new File(PathManager.getSystemPath(), "vcs");
        File file = new File(vcsFile, "svn_branches");
        file.mkdirs();
        this.myFile = new File(file, this.project.getLocationHash());
    }

    @JvmStatic
    @NotNull
    public static final SvnLoadedBranchesStorage getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/idea/svn/branchConfig/SvnLoadedBranchesStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.svn"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SvnLoadedBranchesStorage getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(SvnLoadedBranchesStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (SvnLoadedBranchesStorage)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

