/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.util.logging;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.util.logging.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016J \u0010\u000b\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016J \u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/projector/util/logging/ConsoleJvmLogger;", "Lorg/jetbrains/projector/util/logging/Logger;", "tag", "", "(Ljava/lang/String;)V", "debug", "", "t", "", "lazyMessage", "Lkotlin/Function0;", "error", "info", "Companion", "LogLevel", "projector-util-logging"})
public final class ConsoleJvmLogger
implements Logger {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;

    public ConsoleJvmLogger(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
    }

    @Override
    public void error(@Nullable Throwable t, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        PrintStream printStream = System.err;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
        ConsoleJvmLogger.Companion.log(printStream, LogLevel.ERROR, this.tag, t, (Function0<String>)lazyMessage);
    }

    @Override
    public void info(@Nullable Throwable t, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        ConsoleJvmLogger.Companion.log(printStream, LogLevel.INFO, this.tag, t, (Function0<String>)lazyMessage);
    }

    @Override
    public void debug(@Nullable Throwable t, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        ConsoleJvmLogger.Companion.log(printStream, LogLevel.DEBUG, this.tag, t, (Function0<String>)lazyMessage);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/projector/util/logging/ConsoleJvmLogger$LogLevel;", "", "prefix", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "ERROR", "INFO", "DEBUG", "projector-util-logging"})
    private static final class LogLevel
    extends Enum<LogLevel> {
        @NotNull
        private final String prefix;
        public static final /* enum */ LogLevel ERROR = new LogLevel("ERROR");
        public static final /* enum */ LogLevel INFO = new LogLevel("INFO");
        public static final /* enum */ LogLevel DEBUG = new LogLevel("DEBUG");
        private static final /* synthetic */ LogLevel[] $VALUES;

        private LogLevel(String prefix) {
            this.prefix = prefix;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        public static LogLevel[] values() {
            return (LogLevel[])$VALUES.clone();
        }

        public static LogLevel valueOf(String value) {
            return Enum.valueOf(LogLevel.class, value);
        }

        static {
            $VALUES = logLevelArray = new LogLevel[]{LogLevel.ERROR, LogLevel.INFO, LogLevel.DEBUG};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004*\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/projector/util/logging/ConsoleJvmLogger$Companion;", "", "()V", "stackTraceString", "", "", "getStackTraceString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "suffixForLog", "getSuffixForLog", "log", "", "stream", "Ljava/io/PrintStream;", "level", "Lorg/jetbrains/projector/util/logging/ConsoleJvmLogger$LogLevel;", "tag", "t", "lazyMessage", "Lkotlin/Function0;", "projector-util-logging"})
    private static final class Companion {
        private Companion() {
        }

        private final void log(PrintStream stream, LogLevel level, String tag, Throwable t, Function0<String> lazyMessage) {
            stream.println("[" + level.getPrefix() + "] :: " + tag + " :: " + lazyMessage.invoke() + this.getSuffixForLog(t));
        }

        private final String getSuffixForLog(Throwable $this$suffixForLog) {
            Throwable throwable = $this$suffixForLog;
            return throwable == null ? "" : " :: " + this.getStackTraceString($this$suffixForLog);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String getStackTraceString(Throwable $this$stackTraceString) {
            StringWriter str = new StringWriter();
            PrintWriter writer = new PrintWriter(str);
            try {
                $this$stackTraceString.printStackTrace(writer);
                String string = str.getBuffer().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.buffer.toString()");
                return string;
            }
            finally {
                try {
                    str.close();
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

