/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.impl.InstructionImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.controlflow.InstructionTypeCallback;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReadWriteInstruction
extends InstructionImpl {
    final InstructionTypeCallback EXPR_TYPE = new InstructionTypeCallback(){

        @Override
        @Nullable
        public Ref<PyType> getType(TypeEvalContext context2, @Nullable PsiElement anchor) {
            return Ref.create(ReadWriteInstruction.this.myElement instanceof PyExpression ? context2.getType((PyExpression)ReadWriteInstruction.this.myElement) : null);
        }
    };
    private final String myName;
    private final ACCESS myAccess;
    private final InstructionTypeCallback myGetType;

    private ReadWriteInstruction(ControlFlowBuilder builder, PsiElement element, String name, ACCESS access) {
        this(builder, element, name, access, null);
    }

    private ReadWriteInstruction(ControlFlowBuilder builder, PsiElement element, String name, ACCESS access, @Nullable InstructionTypeCallback getType) {
        super(builder, element);
        this.myName = name;
        this.myAccess = access;
        this.myGetType = getType != null ? getType : this.EXPR_TYPE;
    }

    public String getName() {
        return this.myName;
    }

    public ACCESS getAccess() {
        return this.myAccess;
    }

    public static ReadWriteInstruction read(ControlFlowBuilder builder, PyElement element, String name) {
        return new ReadWriteInstruction(builder, (PsiElement)element, name, ACCESS.READ);
    }

    public static ReadWriteInstruction write(ControlFlowBuilder builder, PyElement element, String name) {
        return new ReadWriteInstruction(builder, (PsiElement)element, name, ACCESS.WRITE);
    }

    public static ReadWriteInstruction newInstruction(ControlFlowBuilder builder, PsiElement element, String name, ACCESS access) {
        return new ReadWriteInstruction(builder, element, name, access);
    }

    public static ReadWriteInstruction assertType(ControlFlowBuilder builder, PsiElement element, String name, InstructionTypeCallback getType) {
        return new ReadWriteInstruction(builder, element, name, ACCESS.ASSERTTYPE, getType);
    }

    @Nullable
    public Ref<PyType> getType(TypeEvalContext context2, @Nullable PsiElement anchor) {
        return this.myGetType.getType(context2, anchor);
    }

    @NotNull
    @NonNls
    public String getElementPresentation() {
        String string = this.myAccess + " ACCESS: " + this.myName;
        if (string == null) {
            ReadWriteInstruction.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/controlflow/ReadWriteInstruction", "getElementPresentation"));
    }

    public static enum ACCESS {
        READ(true, false, false, false),
        WRITE(false, true, false, false),
        ASSERTTYPE(false, false, true, false),
        READWRITE(true, true, false, false),
        DELETE(false, false, false, true);

        private final boolean isWrite;
        private final boolean isRead;
        private final boolean isAssertType;
        private final boolean isDelete;

        private ACCESS(boolean read, boolean write, boolean assertType, boolean delete) {
            this.isRead = read;
            this.isWrite = write;
            this.isAssertType = assertType;
            this.isDelete = delete;
        }

        public boolean isWriteAccess() {
            return this.isWrite;
        }

        public boolean isReadAccess() {
            return this.isRead;
        }

        public boolean isAssertTypeAccess() {
            return this.isAssertType;
        }

        public boolean isDeleteAccess() {
            return this.isDelete;
        }
    }
}

