/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationServer;
import com.jetbrains.python.console.PythonConsoleBackendServiceDisposable;
import com.jetbrains.python.console.PythonConsoleClientUtil;
import com.jetbrains.python.console.protocol.PythonConsoleBackendService;
import com.jetbrains.python.console.protocol.PythonConsoleFrontendService;
import com.jetbrains.python.console.transport.server.ServerClosedException;
import com.jetbrains.python.console.transport.server.TNettyServer;
import com.jetbrains.python.console.transport.server.TNettyServerTransport;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyFrameListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0014J\b\u0010\u001d\u001a\u00020\fH\u0014J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/console/PydevConsoleCommunicationServer;", "Lcom/jetbrains/python/console/PydevConsoleCommunication;", "project", "Lcom/intellij/openapi/project/Project;", "host", "", "port", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;I)V", "_pythonConsoleProcess", "Ljava/lang/Process;", "client", "Lcom/jetbrains/python/console/PythonConsoleBackendServiceDisposable;", "initialPythonConsoleClient", "Lcom/jetbrains/python/console/protocol/PythonConsoleBackendService$Iface;", "isClosed", "", "isFailedOnBound", "isServerBound", "server", "Lcom/jetbrains/python/console/transport/server/TNettyServer;", "serverTransport", "Lcom/jetbrains/python/console/transport/server/TNettyServerTransport;", "stateChanged", "Ljava/util/concurrent/locks/Condition;", "stateLock", "Ljava/util/concurrent/locks/Lock;", "closeCommunication", "Ljava/util/concurrent/Future;", "getPythonConsoleBackendClient", "isCommunicationClosed", "serve", "", "setPythonConsoleProcess", "pythonConsoleProcess", "Companion", "intellij.python.community.impl"})
public final class PydevConsoleCommunicationServer
extends PydevConsoleCommunication {
    private final TNettyServerTransport serverTransport;
    private final TNettyServer server;
    private PythonConsoleBackendServiceDisposable client;
    private final Lock stateLock;
    private final Condition stateChanged;
    private PythonConsoleBackendService.Iface initialPythonConsoleClient;
    private Process _pythonConsoleProcess;
    private boolean isFailedOnBound;
    private boolean isServerBound;
    private boolean isClosed;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serve() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ PydevConsoleCommunicationServer this$0;

            public final void run() {
                PydevConsoleCommunicationServer.access$getServer$p(this.this$0).serve();
            }
            {
                this.this$0 = pydevConsoleCommunicationServer;
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
            final /* synthetic */ PydevConsoleCommunicationServer this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                TTransport clientTransport = null;
                try {
                    clientTransport = PydevConsoleCommunicationServer.access$getServerTransport$p(this.this$0).getReverseTransport();
                }
                catch (ServerClosedException e) {
                    throw (Throwable)new ProcessCanceledException((Throwable)e);
                }
                TBinaryProtocol clientProtocol = new TBinaryProtocol(clientTransport);
                PythonConsoleBackendService.Client client = new PythonConsoleBackendService.Client((TProtocol)clientProtocol);
                Lock lock = PydevConsoleCommunicationServer.access$getStateLock$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                lock.lock();
                try {
                    boolean bl3 = false;
                    if (PydevConsoleCommunicationServer.access$isClosed$p(this.this$0)) {
                        PydevConsoleCommunicationServer.access$getServer$p(this.this$0).stop();
                        throw (Throwable)new ProcessCanceledException();
                    }
                    PydevConsoleCommunicationServer.access$setInitialPythonConsoleClient$p(this.this$0, client);
                    PydevConsoleCommunicationServer.access$getStateChanged$p(this.this$0).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                PyDebugValueExecutionService executionService = PyDebugValueExecutionService.getInstance(PydevConsoleCommunicationServer.access$getMyProject$p(this.this$0));
                executionService.sessionStarted(this.this$0);
                this.this$0.addFrameListener(new PyFrameListener(this, executionService){
                    final /* synthetic */ serve.2 this$0;
                    final /* synthetic */ PyDebugValueExecutionService $executionService;

                    public void frameChanged() {
                        this.$executionService.cancelSubmittedTasks(this.this$0.this$0);
                    }

                    public void sessionStopped() {
                        this.$executionService.cancelSubmittedTasks(this.this$0.this$0);
                    }
                    {
                        this.this$0 = this$0;
                        this.$executionService = $captured_local_variable$1;
                    }
                });
            }
            {
                this.this$0 = pydevConsoleCommunicationServer;
            }
        });
        Lock lock = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            try {
                this.serverTransport.waitForBind();
                this.isServerBound = true;
                this.isFailedOnBound = !this.isServerBound;
            }
            catch (Throwable throwable) {
                this.isFailedOnBound = !this.isServerBound;
                this.stateChanged.signalAll();
                throw throwable;
            }
            this.stateChanged.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPythonConsoleProcess(@NotNull Process pythonConsoleProcess) {
        Intrinsics.checkNotNullParameter((Object)pythonConsoleProcess, (String)"pythonConsoleProcess");
        Lock lock = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            if (this.isClosed) {
                throw (Throwable)new PydevConsoleCommunication.CommunicationClosedException();
            }
            if (!this.isServerBound) {
                LOG.warn("Python Console process is set before IDE server is bound, the process may not be able to connect to the server");
            }
            this._pythonConsoleProcess = pythonConsoleProcess;
            this.stateChanged.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected PythonConsoleBackendServiceDisposable getPythonConsoleBackendClient() {
        Lock lock = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            while (!this.isClosed && !this.isFailedOnBound) {
                PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable = this.client;
                if (pythonConsoleBackendServiceDisposable != null) {
                    PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable2 = pythonConsoleBackendServiceDisposable;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    PythonConsoleBackendServiceDisposable it = pythonConsoleBackendServiceDisposable2;
                    boolean bl6 = false;
                    PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable3 = it;
                    return pythonConsoleBackendServiceDisposable3;
                }
                PythonConsoleBackendService.Iface initialPythonConsoleClient = this.initialPythonConsoleClient;
                Process pythonConsoleProcess = this._pythonConsoleProcess;
                if (initialPythonConsoleClient != null && pythonConsoleProcess != null) {
                    PythonConsoleBackendServiceDisposable newClient;
                    ClassLoader classLoader = PydevConsoleCommunication.class.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"PydevConsoleCommunication::class.java.classLoader");
                    this.client = newClient = PythonConsoleClientUtil.synchronizedPythonConsoleClient(classLoader, initialPythonConsoleClient, pythonConsoleProcess);
                    PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable4 = newClient;
                    return pythonConsoleBackendServiceDisposable4;
                }
                this.stateChanged.await();
            }
            throw (Throwable)new PydevConsoleCommunication.CommunicationClosedException();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Future<?> closeCommunication() {
        block16: {
            ProgressIndicatorProvider progressIndicatorProvider = ProgressIndicatorProvider.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressIndicatorProvider, (String)"ProgressIndicatorProvider.getInstance()");
            ProgressIndicator progressIndicator = progressIndicatorProvider.getProgressIndicator();
            Object object = this.stateLock;
            boolean bl = false;
            boolean bl2 = false;
            object.lock();
            try {
                boolean bl3 = false;
                try {
                    this.isClosed = true;
                }
                finally {
                    this.stateChanged.signalAll();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                object.unlock();
            }
            try {
                PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable = this.client;
                if (pythonConsoleBackendServiceDisposable != null) {
                    object = pythonConsoleBackendServiceDisposable;
                    bl = false;
                    boolean bl4 = false;
                    Object $this$apply = object;
                    boolean bl5 = false;
                    ProgressIndicator progressIndicator2 = progressIndicator;
                    if (progressIndicator2 != null) {
                        progressIndicator2.setText2(PyBundle.message("debugger.sending.close.message", new Object[0]));
                    }
                    $this$apply.close();
                    $this$apply.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Process process2 = this._pythonConsoleProcess;
            if (process2 == null) break block16;
            object = process2;
            bl = false;
            boolean bl6 = false;
            Object it = object;
            boolean bl7 = false;
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2(PyBundle.message("debugger.waiting.to.finish", new Object[0]));
            }
            try {
                do {
                    ProgressIndicator progressIndicator4 = progressIndicator;
                    if (progressIndicator4 == null) continue;
                    progressIndicator4.checkCanceled();
                } while (!((Process)it).waitFor(500L, TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommunicationClosed() {
        Lock lock = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            bl2 = this.isClosed;
        }
        finally {
            lock.unlock();
        }
        return bl2;
    }

    public PydevConsoleCommunicationServer(@NotNull Project project, @NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(project);
        this.stateLock = new ReentrantLock();
        Condition condition = this.stateLock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"stateLock.newCondition()");
        this.stateChanged = condition;
        PythonConsoleFrontendService.Iface iface = this.createPythonConsoleFrontendHandler();
        Intrinsics.checkNotNullExpressionValue((Object)iface, (String)"createPythonConsoleFrontendHandler()");
        PythonConsoleFrontendService.Iface serverHandler = iface;
        PythonConsoleFrontendService.Processor<PythonConsoleFrontendService.Iface> serverProcessor = new PythonConsoleFrontendService.Processor<PythonConsoleFrontendService.Iface>(serverHandler);
        this.serverTransport = new TNettyServerTransport(host, port);
        this.server = new TNettyServer(this.serverTransport, (TProcessor)serverProcessor);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(PydevConsoleCommunicationServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Pydev\u2026cationServer::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ TNettyServer access$getServer$p(PydevConsoleCommunicationServer $this) {
        return $this.server;
    }

    public static final /* synthetic */ TNettyServerTransport access$getServerTransport$p(PydevConsoleCommunicationServer $this) {
        return $this.serverTransport;
    }

    public static final /* synthetic */ Lock access$getStateLock$p(PydevConsoleCommunicationServer $this) {
        return $this.stateLock;
    }

    public static final /* synthetic */ boolean access$isClosed$p(PydevConsoleCommunicationServer $this) {
        return $this.isClosed;
    }

    public static final /* synthetic */ void access$setClosed$p(PydevConsoleCommunicationServer $this, boolean bl) {
        $this.isClosed = bl;
    }

    public static final /* synthetic */ PythonConsoleBackendService.Iface access$getInitialPythonConsoleClient$p(PydevConsoleCommunicationServer $this) {
        return $this.initialPythonConsoleClient;
    }

    public static final /* synthetic */ void access$setInitialPythonConsoleClient$p(PydevConsoleCommunicationServer $this, PythonConsoleBackendService.Iface iface) {
        $this.initialPythonConsoleClient = iface;
    }

    public static final /* synthetic */ Condition access$getStateChanged$p(PydevConsoleCommunicationServer $this) {
        return $this.stateChanged;
    }

    public static final /* synthetic */ Project access$getMyProject$p(PydevConsoleCommunicationServer $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/console/PydevConsoleCommunicationServer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

