/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.completion;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.impl.LightNamedElement;

public class PydevConsoleElement
extends LightNamedElement {
    private final String myDescription;

    public PydevConsoleElement(PsiManager manager, String name, String description) {
        super(manager, PythonLanguage.getInstance(), name);
        this.myDescription = description;
    }

    @Override
    public String toString() {
        return "PydevConsoleElement " + this.myDescription;
    }

    @NlsSafe
    public static String generateDoc(PydevConsoleElement pydevConsoleElement) {
        String description = pydevConsoleElement.myDescription;
        int index = description.indexOf("\n\n");
        if (index != -1) {
            StringBuilder builder = new StringBuilder();
            builder.append("<b>").append(description.subSequence(0, index)).append("</b>").append("<hr/>").append(description.substring(index + 2));
            return StringUtil.replace((String)builder.toString(), (String)"\n", (String)"<br/>");
        }
        return StringUtil.replace((String)description, (String)"\n", (String)"<br/>");
    }
}

