/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.console.PydevConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.console.pydev.ConsoleCommunicationListener;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugSessionFactory;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.PydevDebugConsoleExecuteActionHandler;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.DebugAwareConfiguration;
import com.jetbrains.python.run.EnvironmentController;
import com.jetbrains.python.run.PlainEnvironmentController;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonModuleExecution;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.TargetEnvironmentController;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class PyDebugRunner
implements ProgramRunner<RunnerSettings> {
    @NonNls
    public static final String PY_DEBUG_RUNNER = "PyDebugRunner";
    @NonNls
    public static final String DEBUGGER_MAIN = "pydev/pydevd.py";
    @NonNls
    public static final String CLIENT_PARAM = "--client";
    @NonNls
    public static final String PORT_PARAM = "--port";
    @NonNls
    public static final String FILE_PARAM = "--file";
    @NonNls
    public static final String MODULE_PARAM = "--module";
    @NonNls
    public static final String MULTIPROCESS_PARAM = "--multiprocess";
    @NonNls
    public static final String IDE_PROJECT_ROOTS = "IDE_PROJECT_ROOTS";
    @NonNls
    public static final String LIBRARY_ROOTS = "LIBRARY_ROOTS";
    @NonNls
    public static final String PYTHON_ASYNCIO_DEBUG = "PYTHONASYNCIODEBUG";
    @NonNls
    public static final String GEVENT_SUPPORT = "GEVENT_SUPPORT";
    @NonNls
    public static final String PYDEVD_FILTERS = "PYDEVD_FILTERS";
    @NonNls
    public static final String PYDEVD_FILTER_LIBRARIES = "PYDEVD_FILTER_LIBRARIES";
    @NonNls
    public static final String PYDEVD_USE_CYTHON = "PYDEVD_USE_CYTHON";
    @NonNls
    public static final String CYTHON_EXTENSIONS_DIR = new File(PathManager.getSystemPath(), "cythonExtensions").toString();
    @NonNls
    private static final String PYTHONPATH_ENV_NAME = "PYTHONPATH";

    @NotNull
    public String getRunnerId() {
        return PY_DEBUG_RUNNER;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PyDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            PyDebugRunner.$$$reportNull$$$0(1);
        }
        if (!"Debug".equals(executorId)) {
            return false;
        }
        if (profile instanceof WrappingRunConfiguration) {
            return PyDebugRunner.isDebuggable((RunProfile)((WrappingRunConfiguration)profile).getPeer());
        }
        return PyDebugRunner.isDebuggable(profile);
    }

    private static boolean isDebuggable(@NotNull RunProfile profile) {
        if (profile == null) {
            PyDebugRunner.$$$reportNull$$$0(2);
        }
        if (profile instanceof DebugAwareConfiguration) {
            return ((DebugAwareConfiguration)profile).canRunUnderDebug();
        }
        return profile instanceof AbstractPythonRunConfiguration;
    }

    protected Promise<@NotNull XDebugSession> createSession(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment environment) {
        if (state2 == null) {
            PyDebugRunner.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(4);
        }
        return AppUIExecutor.onUiThread().submit(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments()).thenAsync(ignored -> Experiments.getInstance().isFeatureEnabled("python.use.targets.api.for.run.configurations") ? this.createSessionUsingTargetsApi(state2, environment) : this.createSessionLegacy(state2, environment));
    }

    @NotNull
    private Promise<XDebugSession> createSessionUsingTargetsApi(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment environment) {
        if (state2 == null) {
            PyDebugRunner.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(6);
        }
        PythonCommandLineState pyState = (PythonCommandLineState)state2;
        RunProfile profile = environment.getRunProfile();
        Promise promise = Promises.runAsync(() -> {
            try {
                ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
                int serverLocalPort = serverSocket.getLocalPort();
                PythonDebuggerScriptTargetedCommandLineBuilder debuggerScriptCommandLineBuilder = new PythonDebuggerScriptTargetedCommandLineBuilder(environment.getProject(), pyState, profile, serverLocalPort);
                ExecutionResult result = pyState.execute(environment.getExecutor(), debuggerScriptCommandLineBuilder);
                return Pair.create((Object)serverSocket, (Object)result);
            }
            catch (ExecutionException err) {
                throw new RuntimeException(err.getMessage(), err);
            }
        }).thenAsync(pair -> AppUIExecutor.onUiThread().submit(() -> {
            ServerSocket serverSocket = (ServerSocket)pair.getFirst();
            ExecutionResult result = (ExecutionResult)pair.getSecond();
            return this.createXDebugSession(environment, pyState, serverSocket, result);
        }));
        if (promise == null) {
            PyDebugRunner.$$$reportNull$$$0(7);
        }
        return promise;
    }

    @NotNull
    private XDebugSession createXDebugSession(final @NotNull ExecutionEnvironment environment, final PythonCommandLineState pyState, final ServerSocket serverSocket, final ExecutionResult result) throws ExecutionException {
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(8);
        }
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyDebugProcess pyDebugProcess = PyDebugRunner.this.createDebugProcess(session, serverSocket, result, pyState);
                PyDebugRunner.createConsoleCommunicationAndSetupActions(environment.getProject(), result, pyDebugProcess, session);
                PyDebugProcess pyDebugProcess2 = pyDebugProcess;
                if (pyDebugProcess2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pyDebugProcess2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (xDebugSession == null) {
            PyDebugRunner.$$$reportNull$$$0(9);
        }
        return xDebugSession;
    }

    @NotNull
    private Promise<XDebugSession> createSessionLegacy(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment environment) {
        if (state2 == null) {
            PyDebugRunner.$$$reportNull$$$0(10);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(11);
        }
        PythonCommandLineState pyState = (PythonCommandLineState)state2;
        RunProfile profile = environment.getRunProfile();
        Sdk sdk = pyState.getSdk();
        PyDebugSessionFactory sessionCreator = PyDebugSessionFactory.findExtension(sdk);
        if (sessionCreator != null) {
            CancellablePromise cancellablePromise = AppUIExecutor.onWriteThread().submit(() -> sessionCreator.createSession(pyState, environment));
            if (cancellablePromise == null) {
                PyDebugRunner.$$$reportNull$$$0(12);
            }
            return cancellablePromise;
        }
        Promise promise = Promises.runAsync(() -> {
            try {
                ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
                int serverLocalPort = serverSocket.getLocalPort();
                ExecutionResult result = pyState.execute(environment.getExecutor(), this.createCommandLinePatchers(environment.getProject(), pyState, profile, serverLocalPort));
                return Pair.create((Object)serverSocket, (Object)result);
            }
            catch (ExecutionException err) {
                throw new RuntimeException(err.getMessage(), err);
            }
        }).thenAsync(pair -> AppUIExecutor.onUiThread().submit(() -> {
            ServerSocket serverSocket = (ServerSocket)pair.getFirst();
            ExecutionResult result = (ExecutionResult)pair.getSecond();
            return this.createXDebugSession(environment, pyState, serverSocket, result);
        }));
        if (promise == null) {
            PyDebugRunner.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @NotNull
    protected PyDebugProcess createDebugProcess(@NotNull XDebugSession session, ServerSocket serverSocket, ExecutionResult result, PythonCommandLineState pyState) {
        if (session == null) {
            PyDebugRunner.$$$reportNull$$$0(14);
        }
        return new PyDebugProcess(session, serverSocket, result.getExecutionConsole(), result.getProcessHandler(), pyState.isMultiprocessDebug());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        XDebugSession session;
        if (state2 == null) {
            PyDebugRunner.$$$reportNull$$$0(15);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(16);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        PythonCommandLineState pyState = (PythonCommandLineState)state2;
        Sdk sdk = pyState.getSdk();
        PyDebugSessionFactory sessionCreator = PyDebugSessionFactory.findExtension(sdk);
        if (sessionCreator != null) {
            session = sessionCreator.createSession(pyState, environment);
        } else {
            ServerSocket serverSocket = PythonCommandLineState.createServerSocket();
            int serverLocalPort = serverSocket.getLocalPort();
            RunProfile profile = environment.getRunProfile();
            ExecutionResult result = pyState.execute(environment.getExecutor(), this.createCommandLinePatchers(environment.getProject(), pyState, profile, serverLocalPort));
            session = this.createXDebugSession(environment, pyState, serverSocket, result);
        }
        this.initSession(session, state2, environment.getExecutor());
        RunContentDescriptor runContentDescriptor = session.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            PyDebugRunner.$$$reportNull$$$0(17);
        }
        return runContentDescriptor;
    }

    protected @NotNull Promise<@Nullable RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state2) throws ExecutionException {
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(18);
        }
        if (state2 == null) {
            PyDebugRunner.$$$reportNull$$$0(19);
        }
        Promise promise = this.createSession(state2, environment).thenAsync(session -> AppUIExecutor.onUiThread().submit(() -> {
            this.initSession((XDebugSession)session, state2, environment.getExecutor());
            return session.getRunContentDescriptor();
        }));
        if (promise == null) {
            PyDebugRunner.$$$reportNull$$$0(20);
        }
        return promise;
    }

    public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        RunProfileState state2;
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(21);
        }
        if ((state2 = environment.getState()) != null) {
            ExecutionManager.getInstance((Project)environment.getProject()).startRunProfile(environment, () -> {
                try {
                    return this.executeWithLegacyWorkaround(environment, state2);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
    }

    private @NotNull Promise<@Nullable RunContentDescriptor> executeWithLegacyWorkaround(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state2) throws ExecutionException {
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(22);
        }
        if (state2 == null) {
            PyDebugRunner.$$$reportNull$$$0(23);
        }
        boolean callExecute = true;
        try {
            callExecute = this.getClass().getDeclaredMethod("doExecute", RunProfileState.class, ExecutionEnvironment.class).getDeclaringClass().equals(PyDebugRunner.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (callExecute) {
            Promise<RunContentDescriptor> promise = this.execute(environment, state2);
            if (promise == null) {
                PyDebugRunner.$$$reportNull$$$0(24);
            }
            return promise;
        }
        CancellablePromise cancellablePromise = AppUIExecutor.onUiThread().submit(() -> this.doExecute(state2, environment));
        if (cancellablePromise == null) {
            PyDebugRunner.$$$reportNull$$$0(25);
        }
        return cancellablePromise;
    }

    protected void initSession(XDebugSession session, RunProfileState state2, Executor executor) {
    }

    public static int findIndex(List<String> paramList, String paramName) {
        for (int i = 0; i < paramList.size(); ++i) {
            if (!paramName.equals(paramList.get(i))) continue;
            return i + 1;
        }
        return -1;
    }

    public static void createConsoleCommunicationAndSetupActions(@NotNull Project project, @NotNull ExecutionResult result, @NotNull PyDebugProcess debugProcess, @NotNull XDebugSession session) {
        ExecutionConsole console;
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(26);
        }
        if (result == null) {
            PyDebugRunner.$$$reportNull$$$0(27);
        }
        if (debugProcess == null) {
            PyDebugRunner.$$$reportNull$$$0(28);
        }
        if (session == null) {
            PyDebugRunner.$$$reportNull$$$0(29);
        }
        if ((console = result.getExecutionConsole()) instanceof PythonDebugLanguageConsoleView) {
            ProcessHandler processHandler = result.getProcessHandler();
            PyDebugRunner.initDebugConsoleView(project, debugProcess, (PythonDebugLanguageConsoleView)console, processHandler, session);
        }
    }

    public static PythonDebugConsoleCommunication initDebugConsoleView(Project project, PyDebugProcess debugProcess, PythonDebugLanguageConsoleView console, ProcessHandler processHandler, final XDebugSession session) {
        PythonConsoleView pythonConsoleView = console.getPydevConsoleView();
        PythonDebugConsoleCommunication debugConsoleCommunication = new PythonDebugConsoleCommunication(project, debugProcess, pythonConsoleView);
        pythonConsoleView.setConsoleCommunication(debugConsoleCommunication);
        PydevDebugConsoleExecuteActionHandler consoleExecuteActionHandler = new PydevDebugConsoleExecuteActionHandler((LanguageConsoleView)pythonConsoleView, processHandler, debugConsoleCommunication);
        pythonConsoleView.setExecutionHandler(consoleExecuteActionHandler);
        debugProcess.getSession().addSessionListener((XDebugSessionListener)consoleExecuteActionHandler);
        new LanguageConsoleBuilder((LanguageConsoleView)pythonConsoleView).processHandler(processHandler).initActions((BaseConsoleExecuteActionHandler)consoleExecuteActionHandler, "py");
        debugConsoleCommunication.addCommunicationListener(new ConsoleCommunicationListener(){

            @Override
            public void commandExecuted(boolean more) {
                session.rebuildViews();
            }

            @Override
            public void inputRequested() {
            }
        });
        return debugConsoleCommunication;
    }

    @Nullable
    public static CommandLinePatcher createRunConfigPatcher(RunProfileState state2, RunProfile profile) {
        AbstractPythonRunConfiguration runConfigPatcher = null;
        if (state2 instanceof PythonCommandLineState && profile instanceof AbstractPythonRunConfiguration) {
            runConfigPatcher = (AbstractPythonRunConfiguration)profile;
        }
        return runConfigPatcher;
    }

    public CommandLinePatcher[] createCommandLinePatchers(Project project, PythonCommandLineState state2, RunProfile profile, int serverLocalPort) {
        return new CommandLinePatcher[]{this.createDebugServerPatcher(project, state2, serverLocalPort, profile), PyDebugRunner.createRunConfigPatcher((RunProfileState)state2, profile)};
    }

    public static boolean patchExeParams(ParametersList parametersList) {
        int moduleParamsIndex = parametersList.getParamsGroups().indexOf(parametersList.getParamsGroup("Module"));
        ParamsGroup oldModuleParams = parametersList.removeParamsGroup(moduleParamsIndex);
        if (oldModuleParams == null) {
            return false;
        }
        boolean isModule = false;
        ParamsGroup newModuleParams = new ParamsGroup("Module");
        for (String param : oldModuleParams.getParameters()) {
            if (!param.equals("-m")) {
                newModuleParams.addParameter(param);
                continue;
            }
            isModule = true;
        }
        parametersList.addParamsGroupAt(moduleParamsIndex, newModuleParams);
        return isModule;
    }

    private CommandLinePatcher createDebugServerPatcher(final Project project, final PythonCommandLineState pyState, final int serverLocalPort, final RunProfile profile) {
        return new CommandLinePatcher(){

            @Override
            public void patchCommandLine(GeneralCommandLine commandLine) {
                ParametersList parametersList = commandLine.getParametersList();
                @NotNull ParamsGroup debugParams = parametersList.getParamsGroup("Debugger");
                assert (debugParams != null);
                boolean isModule = PyDebugRunner.patchExeParams(parametersList);
                PyDebugRunner.this.fillDebugParameters(project, debugParams, serverLocalPort, pyState, commandLine, profile, isModule);
                @NotNull ParamsGroup exeParams = parametersList.getParamsGroup("Exe Options");
                PythonSdkFlavor flavor = pyState.getSdkFlavor();
                if (flavor != null) {
                    assert (exeParams != null);
                    for (String option : flavor.getExtraDebugOptions()) {
                        exeParams.addParameter(option);
                    }
                }
            }
        };
    }

    private void fillDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, int serverLocalPort, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd, @Nullable RunProfile runProfile, boolean isModule) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(30);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(31);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(32);
        }
        if (cmd == null) {
            PyDebugRunner.$$$reportNull$$$0(33);
        }
        PythonHelper.DEBUGGER.addToGroup(debugParams, cmd);
        if (isModule) {
            debugParams.addParameter(MODULE_PARAM);
        }
        this.configureDebugParameters(project, debugParams, pyState, cmd);
        PyDebugRunner.configureDebugEnvironment(project, cmd.getEnvironment(), runProfile);
        PyDebugRunner.configureDebugConnectionParameters(debugParams, serverLocalPort);
    }

    @NotNull
    private PythonScriptExecution prepareDebuggerScriptExecution(@NotNull Project project, @NotNull Function<TargetEnvironment, HostPort> serverPortOnTarget, @NotNull PythonCommandLineState pyState, @NotNull PythonExecution originalPythonScript, @Nullable RunProfile runProfile, @NotNull HelpersAwareTargetEnvironmentRequest request) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(34);
        }
        if (serverPortOnTarget == null) {
            PyDebugRunner.$$$reportNull$$$0(35);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(36);
        }
        if (originalPythonScript == null) {
            PyDebugRunner.$$$reportNull$$$0(37);
        }
        if (request == null) {
            PyDebugRunner.$$$reportNull$$$0(38);
        }
        final PythonScriptExecution debuggerScript = PythonScripts.prepareHelperScriptExecution(PythonHelper.DEBUGGER, request);
        TargetEnvironmentRequest targetEnvironmentRequest = request.getTargetEnvironmentRequest();
        PythonScripts.extendEnvs(debuggerScript, originalPythonScript.getEnvs(), targetEnvironmentRequest.getTargetPlatform());
        debuggerScript.setWorkingDir(originalPythonScript.getWorkingDir());
        originalPythonScript.accept(new PythonExecution.Visitor(){

            @Override
            public void visit(@NotNull PythonScriptExecution pythonScriptExecution) {
                if (pythonScriptExecution == null) {
                    4.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void visit(@NotNull PythonModuleExecution pythonModuleExecution) {
                if (pythonModuleExecution == null) {
                    4.$$$reportNull$$$0(1);
                }
                debuggerScript.addParameter(PyDebugRunner.MODULE_PARAM);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonScriptExecution";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonModuleExecution";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/debugger/PyDebugRunner$4";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.configureDebugParameters(project, pyState, debuggerScript, false);
        boolean isLocalTarget = targetEnvironmentRequest instanceof LocalTargetEnvironment;
        PyDebugRunner.configureDebugEnvironment(project, new TargetEnvironmentController(debuggerScript.getEnvs(), targetEnvironmentRequest), runProfile, isLocalTarget);
        PyDebugRunner.configureClientModeDebugConnectionParameters(debuggerScript, serverPortOnTarget);
        originalPythonScript.accept(new PythonExecution.Visitor(){

            @Override
            public void visit(@NotNull PythonScriptExecution pythonScriptExecution) {
                Function<TargetEnvironment, String> scriptPath;
                if (pythonScriptExecution == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((scriptPath = pythonScriptExecution.getPythonScriptPath()) == null) {
                    throw new IllegalArgumentException("Python script path must be set");
                }
                debuggerScript.addParameter(scriptPath);
            }

            @Override
            public void visit(@NotNull PythonModuleExecution pythonModuleExecution) {
                String moduleName;
                if (pythonModuleExecution == null) {
                    5.$$$reportNull$$$0(1);
                }
                if ((moduleName = pythonModuleExecution.getModuleName()) == null) {
                    throw new IllegalArgumentException("Python module name must be set");
                }
                debuggerScript.addParameter(moduleName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonScriptExecution";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pythonModuleExecution";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/debugger/PyDebugRunner$5";
                objectArray[2] = "visit";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        debuggerScript.getParameters().addAll(originalPythonScript.getParameters());
        PythonScriptExecution pythonScriptExecution = debuggerScript;
        if (pythonScriptExecution == null) {
            PyDebugRunner.$$$reportNull$$$0(39);
        }
        return pythonScriptExecution;
    }

    public static void configureDebugEnvironment(@NotNull Project project, Map<String, String> environment, @Nullable RunProfile runProfile) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(40);
        }
        PyDebugRunner.configureDebugEnvironment(project, new PlainEnvironmentController(environment), runProfile, true);
    }

    private static void configureDebugEnvironment(@NotNull Project project, @NotNull EnvironmentController environmentController, @Nullable RunProfile runProfile, boolean addCythonExtensionsToPythonPath) {
        AbstractPythonRunConfiguration runConfiguration;
        PyDebuggerSettings debuggerSettings;
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(41);
        }
        if (environmentController == null) {
            PyDebugRunner.$$$reportNull$$$0(42);
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportGeventDebugging()) {
            environmentController.putFixedValue(GEVENT_SUPPORT, "True");
        }
        if ((debuggerSettings = PyDebuggerSettings.getInstance()).isSteppingFiltersEnabled()) {
            environmentController.putFixedValue(PYDEVD_FILTERS, debuggerSettings.getSteppingFiltersForProject(project));
        }
        if (debuggerSettings.isLibrariesFilterEnabled()) {
            environmentController.putFixedValue(PYDEVD_FILTER_LIBRARIES, "True");
        }
        if (debuggerSettings.getValuesPolicy() != PyDebugValue.ValuesPolicy.SYNC) {
            environmentController.putFixedValue(PyDebugValue.POLICY_ENV_VARS.get((Object)debuggerSettings.getValuesPolicy()), "True");
        }
        PydevConsoleRunnerFactory.putIPythonEnvFlag(project, environmentController);
        if (addCythonExtensionsToPythonPath) {
            environmentController.appendTargetPathToPathsValue(PYTHONPATH_ENV_NAME, CYTHON_EXTENSIONS_DIR);
        }
        PyDebugRunner.addProjectRootsToEnv(project, environmentController);
        AbstractPythonRunConfiguration abstractPythonRunConfiguration = runConfiguration = runProfile instanceof AbstractPythonRunConfiguration ? (AbstractPythonRunConfiguration)runProfile : null;
        if (runConfiguration != null) {
            LanguageLevel langLevel;
            PythonSdkFlavor flavor;
            Sdk sdk = runConfiguration.getSdk();
            if (sdk != null && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null && ((langLevel = flavor.getLanguageLevel(sdk)) == LanguageLevel.PYTHON34 || langLevel == LanguageLevel.PYTHON35)) {
                environmentController.putFixedValue(PYDEVD_USE_CYTHON, "NO");
            }
            PyDebugRunner.addSdkRootsToEnv(environmentController, runConfiguration);
            environmentController.appendTargetPathToPathsValue(PYTHONPATH_ENV_NAME, runConfiguration.getWorkingDirectorySafe());
        }
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(43);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(44);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(45);
        }
        if (cmd == null) {
            PyDebugRunner.$$$reportNull$$$0(46);
        }
        if (pyState.isMultiprocessDebug()) {
            debugParams.addParameter("--multiproc");
        }
        PyDebugRunner.configureCommonDebugParameters(project, debugParams);
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull PythonCommandLineState pyState, @NotNull PythonExecution debuggerScript, boolean debuggerScriptInServerMode) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(47);
        }
        if (pyState == null) {
            PyDebugRunner.$$$reportNull$$$0(48);
        }
        if (debuggerScript == null) {
            PyDebugRunner.$$$reportNull$$$0(49);
        }
        if (pyState.isMultiprocessDebug() && !debuggerScriptInServerMode) {
            debuggerScript.addParameter("--multiproc");
        }
        PyDebugRunner.configureCommonDebugParameters(project, debuggerScript);
    }

    public static void configureCommonDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(50);
        }
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(51);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            debugParams.addParameter("--DEBUG");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSaveCallSignatures()) {
            debugParams.addParameter("--save-signatures");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportQtDebugging()) {
            String pyQtBackend = StringUtil.toLowerCase((String)PyDebuggerOptionsProvider.getInstance(project).getPyQtBackend());
            debugParams.addParameter(String.format("--qt-support=%s", pyQtBackend));
        }
    }

    public static void configureCommonDebugParameters(@NotNull Project project, @NotNull PythonExecution debuggerScript) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(52);
        }
        if (debuggerScript == null) {
            PyDebugRunner.$$$reportNull$$$0(53);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            debuggerScript.addParameter("--DEBUG");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSaveCallSignatures()) {
            debuggerScript.addParameter("--save-signatures");
        }
        if (PyDebuggerOptionsProvider.getInstance(project).isSupportQtDebugging()) {
            String pyQtBackend = StringUtil.toLowerCase((String)PyDebuggerOptionsProvider.getInstance(project).getPyQtBackend());
            debuggerScript.addParameter(String.format("--qt-support=%s", pyQtBackend));
        }
    }

    public static void disableBuiltinBreakpoint(@Nullable Sdk sdk, Map<String, String> env) {
        PythonSdkFlavor flavor;
        if (sdk != null && (flavor = PythonSdkFlavor.getFlavor(sdk)) != null && flavor.getLanguageLevel(sdk) == LanguageLevel.PYTHON37) {
            env.put("PYTHONBREAKPOINT", "0");
        }
    }

    private static void configureDebugConnectionParameters(@NotNull ParamsGroup debugParams, int serverLocalPort) {
        String[] debuggerArgs;
        if (debugParams == null) {
            PyDebugRunner.$$$reportNull$$$0(54);
        }
        for (String s : debuggerArgs = new String[]{CLIENT_PARAM, "127.0.0.1", PORT_PARAM, String.valueOf(serverLocalPort), FILE_PARAM}) {
            debugParams.addParameter(s);
        }
    }

    private static void configureClientModeDebugConnectionParameters(@NotNull PythonExecution debuggerScript, @NotNull Function<TargetEnvironment, HostPort> serverPortOnTarget) {
        if (debuggerScript == null) {
            PyDebugRunner.$$$reportNull$$$0(55);
        }
        if (serverPortOnTarget == null) {
            PyDebugRunner.$$$reportNull$$$0(56);
        }
        debuggerScript.addParameter(CLIENT_PARAM);
        debuggerScript.addParameter(serverPortOnTarget.andThen(HostPort::getHost));
        debuggerScript.addParameter(PORT_PARAM);
        debuggerScript.addParameter(serverPortOnTarget.andThen(HostPort::getPort).andThen(Object::toString));
        debuggerScript.addParameter(FILE_PARAM);
    }

    static void configureServerModeDebugConnectionParameters(@NotNull PythonExecution debuggerScript, @NotNull Function<TargetEnvironment, Integer> serverPortOnTarget) {
        if (debuggerScript == null) {
            PyDebugRunner.$$$reportNull$$$0(57);
        }
        if (serverPortOnTarget == null) {
            PyDebugRunner.$$$reportNull$$$0(58);
        }
        debuggerScript.addParameter(PORT_PARAM);
        debuggerScript.addParameter(serverPortOnTarget.andThen(Object::toString));
        debuggerScript.addParameter(FILE_PARAM);
    }

    private static void addProjectRootsToEnv(@NotNull Project project, @NotNull EnvironmentController environment) {
        if (project == null) {
            PyDebugRunner.$$$reportNull$$$0(59);
        }
        if (environment == null) {
            PyDebugRunner.$$$reportNull$$$0(60);
        }
        ArrayList<String> roots = new ArrayList<String>();
        for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            roots.add(contentRoot.getPath());
        }
        environment.putTargetPathsValue(IDE_PROJECT_ROOTS, roots);
    }

    private static void addSdkRootsToEnv(@NotNull EnvironmentController environmentController, @NotNull AbstractPythonRunConfiguration runConfiguration) {
        Sdk sdk;
        if (environmentController == null) {
            PyDebugRunner.$$$reportNull$$$0(61);
        }
        if (runConfiguration == null) {
            PyDebugRunner.$$$reportNull$$$0(62);
        }
        if ((sdk = runConfiguration.getSdk()) != null) {
            ArrayList<String> roots = new ArrayList<String>();
            for (VirtualFile contentRoot : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                roots.add(contentRoot.getPath());
            }
            environmentController.putFixedValue(LIBRARY_ROOTS, StringUtil.join(roots, (String)File.pathSeparator));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 15: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner";
                break;
            }
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 26: 
            case 30: 
            case 34: 
            case 40: 
            case 41: 
            case 43: 
            case 47: 
            case 50: 
            case 52: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 31: 
            case 44: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 32: 
            case 36: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyState";
                break;
            }
            case 33: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 35: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverPortOnTarget";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPythonScript";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 42: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentController";
                break;
            }
            case 49: 
            case 53: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerScript";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionUsingTargetsApi";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createXDebugSession";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionLegacy";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "executeWithLegacyWorkaround";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDebuggerScriptExecution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDebuggable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSession";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSessionUsingTargetsApi";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 39: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createXDebugSession";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createSessionLegacy";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "executeWithLegacyWorkaround";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleCommunicationAndSetupActions";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fillDebugParameters";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "prepareDebuggerScriptExecution";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugEnvironment";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugParameters";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "configureCommonDebugParameters";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "configureDebugConnectionParameters";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "configureClientModeDebugConnectionParameters";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "configureServerModeDebugConnectionParameters";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addProjectRootsToEnv";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addSdkRootsToEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 24: 
            case 25: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PythonDebuggerScriptTargetedCommandLineBuilder
    implements PythonScriptTargetedCommandLineBuilder {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PythonCommandLineState myPyState;
        @NotNull
        private final RunProfile myProfile;
        private final int myIdeDebugServerLocalPort;

        private PythonDebuggerScriptTargetedCommandLineBuilder(@NotNull Project project, @NotNull PythonCommandLineState pyState, RunProfile profile, int ideDebugServerPort) {
            if (project == null) {
                PythonDebuggerScriptTargetedCommandLineBuilder.$$$reportNull$$$0(0);
            }
            if (pyState == null) {
                PythonDebuggerScriptTargetedCommandLineBuilder.$$$reportNull$$$0(1);
            }
            if (profile == null) {
                PythonDebuggerScriptTargetedCommandLineBuilder.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myPyState = pyState;
            this.myProfile = profile;
            this.myIdeDebugServerLocalPort = ideDebugServerPort;
        }

        @Override
        @NotNull
        public PythonExecution build(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull PythonExecution pythonScript) {
            if (helpersAwareTargetRequest == null) {
                PythonDebuggerScriptTargetedCommandLineBuilder.$$$reportNull$$$0(3);
            }
            if (pythonScript == null) {
                PythonDebuggerScriptTargetedCommandLineBuilder.$$$reportNull$$$0(4);
            }
            TargetEnvironment.LocalPortBinding ideServerPortBinding = new TargetEnvironment.LocalPortBinding(this.myIdeDebugServerLocalPort, null);
            helpersAwareTargetRequest.getTargetEnvironmentRequest().getLocalPortBindings().add(ideServerPortBinding);
            Function ideServerPortBindingValue = TargetEnvironmentFunctions.getTargetEnvironmentValue((TargetEnvironment.LocalPortBinding)ideServerPortBinding);
            PythonScriptExecution debuggerScript = PyDebugRunner.this.prepareDebuggerScriptExecution(this.myProject, ideServerPortBindingValue, this.myPyState, pythonScript, this.myProfile, helpersAwareTargetRequest);
            PythonSdkFlavor flavor = this.myPyState.getSdkFlavor();
            ArrayList<String> interpreterParameters = new ArrayList<String>(this.myPyState.getConfiguredInterpreterParameters());
            if (flavor != null) {
                interpreterParameters.addAll(flavor.getExtraDebugOptions());
            }
            PythonScriptExecution pythonScriptExecution = debuggerScript;
            if (pythonScriptExecution == null) {
                PythonDebuggerScriptTargetedCommandLineBuilder.$$$reportNull$$$0(5);
            }
            return pythonScriptExecution;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helpersAwareTargetRequest";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pythonScript";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyDebugRunner$PythonDebuggerScriptTargetedCommandLineBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyDebugRunner$PythonDebuggerScriptTargetedCommandLineBuilder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

