/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev.dataviewer;

public class DataViewerCommandResult {
    private final ResultType type;
    private final String log;
    public static final DataViewerCommandResult NOT_IMPLEMENTED = DataViewerCommandResult.makeErrorResult(ResultType.NOT_IMPLEMENTED_ERROR, "Not implemented");

    public boolean isSuccess() {
        return this.type == ResultType.OK;
    }

    public ResultType getErrorType() {
        return this.type;
    }

    public String getLog() {
        return this.log;
    }

    public static DataViewerCommandResult makeErrorResult(ResultType error, String log) {
        assert (error != ResultType.OK);
        return new DataViewerCommandResult(error, log);
    }

    public static DataViewerCommandResult makeSuccessResult(String data) {
        return new DataViewerCommandResult(ResultType.OK, data);
    }

    private DataViewerCommandResult(ResultType type, String log) {
        this.type = type;
        this.log = log;
    }

    public static DataViewerCommandResult errorFromExportTraceback(String response) {
        if (response.startsWith("FileNotFoundError") || response.startsWith("OSError")) {
            return DataViewerCommandResult.makeErrorResult(ResultType.FILE_NOT_FOUND_ERROR, response);
        }
        return DataViewerCommandResult.makeErrorResult(ResultType.UNHANDLED_ERROR, response);
    }

    public static enum ResultType {
        OK,
        FILE_NOT_FOUND_ERROR,
        NOT_IMPLEMENTED_ERROR,
        UNHANDLED_ERROR;

    }
}

