/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ChainedComparisonsQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChainedComparisonsInspection
extends PyInspection {
    private static final String INSPECTION_SHORT_NAME = "PyChainedComparisonsInspection";
    public boolean ignoreConstantInTheMiddle = false;

    @Nullable
    public JComponent createOptionsPanel() {
        JCheckBox checkBox = PythonUiService.getInstance().createInspectionCheckBox(PyPsiBundle.message("INSP.chained.comparisons.ignore.statements.with.constant.in.the.middle", new Object[0]), (InspectionProfileEntry)this, "ignoreConstantInTheMiddle");
        JPanel rootPanel = new JPanel(new BorderLayout());
        if (checkBox != null) {
            rootPanel.add((Component)checkBox, "First");
        }
        return rootPanel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyChainedComparisonsInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, this.ignoreConstantInTheMiddle, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DontSimplifyStatementsWithConstantInTheMiddleQuickFix
    implements LocalQuickFix {
        private DontSimplifyStatementsWithConstantInTheMiddleQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.chained.comparisons.ignore.statements.with.constant.in.the.middle", new Object[0]);
            if (string == null) {
                DontSimplifyStatementsWithConstantInTheMiddleQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                DontSimplifyStatementsWithConstantInTheMiddleQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                DontSimplifyStatementsWithConstantInTheMiddleQuickFix.$$$reportNull$$$0(2);
            }
            PsiFile file = descriptor2.getStartElement().getContainingFile();
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
                ((PyChainedComparisonsInspection)it.getUnwrappedTool((String)PyChainedComparisonsInspection.INSPECTION_SHORT_NAME, (PsiElement)file)).ignoreConstantInTheMiddle = true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection$DontSimplifyStatementsWithConstantInTheMiddleQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection$DontSimplifyStatementsWithConstantInTheMiddleQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        boolean myIsLeft;
        boolean myIsRight;
        PyElementType myOperator;
        boolean getInnerRight;
        boolean isConstantInTheMiddle;
        boolean ignoreConstantInTheMiddle;

        Visitor(@Nullable ProblemsHolder holder, boolean ignoreConstantInTheMiddle, @NotNull TypeEvalContext context2) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context2);
            this.ignoreConstantInTheMiddle = ignoreConstantInTheMiddle;
        }

        @Override
        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.myIsLeft = false;
            this.myIsRight = false;
            this.myOperator = null;
            this.getInnerRight = false;
            PyBinaryExpression leftExpression = PyUtil.as(node.getLeftExpression(), PyBinaryExpression.class);
            PyBinaryExpression rightExpression = PyUtil.as(node.getRightExpression(), PyBinaryExpression.class);
            if (leftExpression != null && rightExpression != null && node.getOperator() == PyTokenTypes.AND_KEYWORD) {
                boolean applicable = false;
                if (leftExpression.getOperator() == PyTokenTypes.AND_KEYWORD) {
                    PyBinaryExpression leftLeft = PyUtil.as(leftExpression.getLeftExpression(), PyBinaryExpression.class);
                    PyBinaryExpression leftRight = PyUtil.as(leftExpression.getRightExpression(), PyBinaryExpression.class);
                    if (leftLeft != null && (this.isRightSimplified(leftLeft, rightExpression) || this.isLeftSimplified(leftLeft, rightExpression))) {
                        applicable = true;
                        this.getInnerRight = false;
                    } else if (leftRight != null && (this.isRightSimplified(leftRight, rightExpression) || this.isLeftSimplified(leftRight, rightExpression))) {
                        applicable = true;
                        this.getInnerRight = true;
                    }
                } else if (this.isRightSimplified(leftExpression, rightExpression) || this.isLeftSimplified(leftExpression, rightExpression)) {
                    applicable = true;
                }
                if (applicable) {
                    if (this.isConstantInTheMiddle) {
                        if (!this.ignoreConstantInTheMiddle) {
                            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.simplify.chained.comparison", new Object[0]), new ChainedComparisonsQuickFix(this.myIsLeft, this.myIsRight, this.getInnerRight), new DontSimplifyStatementsWithConstantInTheMiddleQuickFix());
                        }
                    } else {
                        this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.simplify.chained.comparison", new Object[0]), new ChainedComparisonsQuickFix(this.myIsLeft, this.myIsRight, this.getInnerRight));
                    }
                }
            }
        }

        private boolean isRightSimplified(@NotNull PyBinaryExpression leftExpression, @NotNull PyBinaryExpression rightExpression) {
            PyExpression leftRight;
            if (leftExpression == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (rightExpression == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((leftRight = leftExpression.getRightExpression()) instanceof PyBinaryExpression && PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)((PyBinaryExpression)leftRight).getOperator()) && this.isRightSimplified((PyBinaryExpression)leftRight, rightExpression)) {
                return true;
            }
            this.myOperator = leftExpression.getOperator();
            if (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)this.myOperator) && leftRight != null) {
                if (leftRight.getText().equals(this.getLeftExpression(rightExpression, true).getText())) {
                    this.myIsLeft = false;
                    this.myIsRight = true;
                    this.isConstantInTheMiddle = leftRight instanceof PyLiteralExpression;
                    return true;
                }
                PyExpression right = this.getSmallestRight(rightExpression, true);
                if (right != null && leftRight.getText().equals(right.getText())) {
                    this.myIsLeft = false;
                    this.myIsRight = false;
                    this.isConstantInTheMiddle = leftRight instanceof PyLiteralExpression;
                    return true;
                }
            }
            return false;
        }

        private static boolean isOpposite(PyElementType op1, PyElementType op2) {
            if (!(op1 != PyTokenTypes.GT && op1 != PyTokenTypes.GE || op2 != PyTokenTypes.LT && op2 != PyTokenTypes.LE)) {
                return true;
            }
            return !(op2 != PyTokenTypes.GT && op2 != PyTokenTypes.GE || op1 != PyTokenTypes.LT && op1 != PyTokenTypes.LE);
        }

        private boolean isLeftSimplified(PyBinaryExpression leftExpression, PyBinaryExpression rightExpression) {
            PyExpression leftLeft = leftExpression.getLeftExpression();
            if (leftLeft instanceof PyBinaryExpression && PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)((PyBinaryExpression)leftLeft).getOperator()) && this.isLeftSimplified((PyBinaryExpression)leftLeft, rightExpression)) {
                return true;
            }
            this.myOperator = leftExpression.getOperator();
            if (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)this.myOperator) && leftLeft != null) {
                if (leftLeft.getText().equals(this.getLeftExpression(rightExpression, false).getText())) {
                    this.myIsLeft = true;
                    this.myIsRight = true;
                    this.isConstantInTheMiddle = leftLeft instanceof PyLiteralExpression;
                    return true;
                }
                PyExpression right = this.getSmallestRight(rightExpression, false);
                if (right != null && leftLeft.getText().equals(right.getText())) {
                    this.myIsLeft = true;
                    this.myIsRight = false;
                    this.isConstantInTheMiddle = leftLeft instanceof PyLiteralExpression;
                    return true;
                }
            }
            return false;
        }

        private PyExpression getLeftExpression(PyBinaryExpression expression, boolean isRight) {
            PyExpression result = expression;
            while (result instanceof PyBinaryExpression && (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)result.getOperator()) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)result.getOperator()))) {
                boolean opposite = Visitor.isOpposite(result.getOperator(), this.myOperator);
                if (isRight && opposite || !isRight && !opposite) break;
                result = result.getLeftExpression();
            }
            return result;
        }

        @Nullable
        private PyExpression getSmallestRight(PyBinaryExpression expression, boolean isRight) {
            PyExpression result = expression;
            while (result instanceof PyBinaryExpression && (PyTokenTypes.RELATIONAL_OPERATIONS.contains((IElementType)result.getOperator()) || PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)result.getOperator()))) {
                boolean opposite = Visitor.isOpposite(result.getOperator(), this.myOperator);
                if (isRight && !opposite || !isRight && opposite) break;
                result = result.getRightExpression();
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyChainedComparisonsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyBinaryExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRightSimplified";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

