/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyShadowingNamesInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyShadowingNamesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyShadowingNamesInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyShadowingNamesInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context2);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.processElement(node);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.processElement(node);
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (node.isSelf()) {
                return;
            }
            this.processElement(node);
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (!node.isQualified()) {
                this.processElement(node);
            }
        }

        private void processElement(@NotNull PsiNameIdentifierOwner element) {
            ScopeOwner owner;
            if (element == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if ((owner = ScopeUtil.getScopeOwner((PsiElement)element)) instanceof PyClass) {
                return;
            }
            String name = element.getName();
            if (name != null) {
                ScopeOwner nextOwner;
                PsiElement problemElement;
                PsiElement identifier = element.getNameIdentifier();
                Object object = problemElement = identifier != null ? identifier : element;
                if ("_".equals(name) || name.startsWith("_") && element instanceof PyParameter) {
                    return;
                }
                if (owner != null && (nextOwner = ScopeUtil.getScopeOwner((PsiElement)owner)) != null) {
                    PyResolveProcessor processor2 = new PyResolveProcessor(name);
                    PyResolveUtil.scopeCrawlUp(processor2, nextOwner, null, name, null);
                    for (PsiElement resolved : processor2.getElements()) {
                        if (resolved == null) continue;
                        PyComprehensionElement comprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)resolved, PyComprehensionElement.class);
                        if (comprehension != null && PyUtil.isOwnScopeComprehension(comprehension)) {
                            return;
                        }
                        Scope scope = ControlFlowCache.getScope(owner);
                        if (scope.isGlobal(name) || scope.isNonlocal(name)) {
                            return;
                        }
                        if (Arrays.stream((PyInspectionExtension[])PyInspectionExtension.EP_NAME.getExtensions()).anyMatch(o -> o.ignoreShadowed(resolved))) {
                            return;
                        }
                        this.registerProblem(problemElement, PyPsiBundle.message("INSP.shadows.name.from.outer.scope", name), ProblemHighlightType.WEAK_WARNING, null, PythonUiService.getInstance().createPyRenameElementQuickFix(problemElement));
                        return;
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyShadowingNamesInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyNamedParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

