/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveUnnecessaryBackslashQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnnecessaryBackslashInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyUnnecessaryBackslashInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyUnnecessaryBackslashInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context2) {
            if (context2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context2);
        }

        @Override
        public void visitPyParameterList(@NotNull PyParameterList list) {
            if (list == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.findProblem((PsiElement)list);
        }

        @Override
        public void visitPyArgumentList(@NotNull PyArgumentList list) {
            if (list == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.findProblem((PsiElement)list);
        }

        @Override
        public void visitPyTupleExpression(@NotNull PyTupleExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (node.getParent() instanceof PyParenthesizedExpression) {
                this.findProblem((PsiElement)node);
            }
        }

        @Override
        public void visitPyParenthesizedExpression(@NotNull PyParenthesizedExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            Stack stack = new Stack();
            stack.push((Object)expression);
            while (!stack.isEmpty()) {
                PsiElement element = (PsiElement)stack.pop();
                if (element instanceof PyTupleExpression) continue;
                this.findProblem(element);
                if (element == null) continue;
                for (PsiElement psiElement : element.getChildren()) {
                    stack.push((Object)psiElement);
                }
            }
        }

        @Override
        public void visitPyDictLiteralExpression(@NotNull PyDictLiteralExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPyListLiteralExpression(@NotNull PyListLiteralExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPySetLiteralExpression(@NotNull PySetLiteralExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression stringLiteralExpression) {
            PsiElement parent;
            if (stringLiteralExpression == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if ((parent = stringLiteralExpression.getParent()) instanceof PyListLiteralExpression || parent instanceof PyParenthesizedExpression || parent instanceof PySetLiteralExpression || parent instanceof PyKeyValueExpression || parent instanceof PyNamedParameter || parent instanceof PyArgumentList) {
                this.findProblem(stringLiteralExpression);
            }
        }

        private void findProblem(@Nullable PsiElement expression) {
            PsiWhiteSpace[] children2 = (PsiWhiteSpace[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, PsiWhiteSpace.class);
            if (children2 != null) {
                for (PsiWhiteSpace ws : children2) {
                    if (!ws.getText().contains("\\")) continue;
                    this.registerProblem((PsiElement)ws, PyPsiBundle.message("INSP.unnecessary.backslash.unnecessary.backslash.in.expression", new Object[0]), new RemoveUnnecessaryBackslashQuickFix());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringLiteralExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyParameterList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyArgumentList";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTupleExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyParenthesizedExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyDictLiteralExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyListLiteralExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPySetLiteralExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyStringLiteralExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

