/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.lexer.PyStringLiteralLexer;
import org.jetbrains.annotations.NotNull;

public abstract class PyStringLiteralLexerBase
extends LexerBase {
    protected static final Logger LOG = Logger.getInstance(PyStringLiteralLexer.class);
    protected final IElementType myOriginalLiteralToken;
    protected CharSequence myBuffer;
    protected int myBufferEnd;
    protected int myStart;
    protected int myEnd;
    protected int myBaseLexerState;
    private boolean mySeenEscapedSpacesOnly;

    public PyStringLiteralLexerBase(IElementType originalLiteralToken) {
        this.myOriginalLiteralToken = originalLiteralToken;
    }

    public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            PyStringLiteralLexerBase.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.mySeenEscapedSpacesOnly = true;
        this.myBufferEnd = endOffset;
        this.myBaseLexerState = initialState;
        this.handleStart(buffer, initialState);
        this.myEnd = this.locateToken(this.myStart);
    }

    protected void handleStart(@NotNull CharSequence buffer, int initialState) {
        if (buffer == null) {
            PyStringLiteralLexerBase.$$$reportNull$$$0(1);
        }
    }

    protected abstract boolean isRaw();

    protected abstract boolean isUnicodeMode();

    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (!this.isEscape()) {
            this.mySeenEscapedSpacesOnly = false;
            return this.myOriginalLiteralToken;
        }
        return this.getEscapeSequenceType();
    }

    @NotNull
    public IElementType getEscapeSequenceType() {
        if (this.myStart + 1 >= this.myEnd) {
            IElementType iElementType = StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            if (iElementType == null) {
                PyStringLiteralLexerBase.$$$reportNull$$$0(2);
            }
            return iElementType;
        }
        char nextChar = this.myBuffer.charAt(this.myStart + 1);
        this.mySeenEscapedSpacesOnly &= nextChar == ' ';
        if (nextChar == '\n' || nextChar == ' ' && (this.mySeenEscapedSpacesOnly || this.isTrailingSpace(this.myStart + 2))) {
            IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            if (iElementType == null) {
                PyStringLiteralLexerBase.$$$reportNull$$$0(3);
            }
            return iElementType;
        }
        if (nextChar == 'u' || nextChar == 'U') {
            if (this.isUnicodeMode()) {
                int width = nextChar == 'u' ? 4 : 8;
                for (int i = this.myStart + 2; i < this.myStart + width + 2; ++i) {
                    if (i < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) continue;
                    IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                    if (iElementType == null) {
                        PyStringLiteralLexerBase.$$$reportNull$$$0(4);
                    }
                    return iElementType;
                }
                IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.$$$reportNull$$$0(5);
                }
                return iElementType;
            }
            IElementType iElementType = this.myOriginalLiteralToken;
            if (iElementType == null) {
                PyStringLiteralLexerBase.$$$reportNull$$$0(6);
            }
            return iElementType;
        }
        if (nextChar == 'x') {
            for (int i = this.myStart + 2; i < this.myStart + 4; ++i) {
                if (i < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) continue;
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.$$$reportNull$$$0(7);
                }
                return iElementType;
            }
            IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            if (iElementType == null) {
                PyStringLiteralLexerBase.$$$reportNull$$$0(8);
            }
            return iElementType;
        }
        if (nextChar == 'N' && this.isUnicodeMode()) {
            int i = this.myStart + 2;
            if (i >= this.myEnd || this.myBuffer.charAt(i) != '{') {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.$$$reportNull$$$0(9);
                }
                return iElementType;
            }
            ++i;
            while (i < this.myEnd && this.myBuffer.charAt(i) != '}') {
                ++i;
            }
            if (i >= this.myEnd) {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.$$$reportNull$$$0(10);
                }
                return iElementType;
            }
            IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            if (iElementType == null) {
                PyStringLiteralLexerBase.$$$reportNull$$$0(11);
            }
            return iElementType;
        }
        switch (nextChar) {
            case '\"': 
            case '\'': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '\\': 
            case 'a': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.$$$reportNull$$$0(12);
                }
                return iElementType;
            }
        }
        IElementType iElementType = this.myOriginalLiteralToken;
        if (iElementType == null) {
            PyStringLiteralLexerBase.$$$reportNull$$$0(13);
        }
        return iElementType;
    }

    protected boolean isEscape() {
        return this.myBuffer.charAt(this.myStart) == '\\' && (!this.isRaw() || this.isUnicodeMode() && this.nextIsUnicodeEscape());
    }

    private boolean nextIsUnicodeEscape() {
        if (this.myStart + 1 < this.myEnd) {
            char nextChar = this.myBuffer.charAt(this.myStart + 1);
            return nextChar == 'u' || nextChar == 'U';
        }
        return false;
    }

    private boolean isTrailingSpace(int start) {
        for (int i = start; i < this.myBufferEnd; i += 2) {
            char c = this.myBuffer.charAt(i);
            if (c != '\\') {
                return false;
            }
            if (i == this.myBufferEnd - 1) {
                return false;
            }
            if (this.myBuffer.charAt(i + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    public final int getTokenStart() {
        assert (this.myStart < this.myEnd || this.myStart == this.myEnd && this.myEnd == this.myBufferEnd);
        return this.myStart;
    }

    public final int getTokenEnd() {
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.error("myStart=" + this.myStart + " myEnd=" + this.myEnd + " myBufferEnd=" + this.myBufferEnd + " text=" + this.myBuffer.subSequence(this.myStart, this.myBufferEnd));
        }
        return this.myEnd;
    }

    public final int getBufferEnd() {
        return this.myBufferEnd;
    }

    @NotNull
    public final CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            PyStringLiteralLexerBase.$$$reportNull$$$0(14);
        }
        return charSequence;
    }

    protected abstract int locateToken(int var1);

    protected final int locateEscapeSequence(int start) {
        assert (this.myBuffer.charAt(start) == '\\');
        int i = start;
        ++i;
        if (this.isRaw()) {
            return i;
        }
        if (i == this.myBufferEnd) {
            return i;
        }
        if (this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
            char first = this.myBuffer.charAt(i);
            if (++i < this.myBufferEnd && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7' && ++i < this.myBufferEnd && first <= '3' && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'x') {
            ++i;
            while (i < start + 4) {
                if (this.isEscapeEnd(i)) {
                    return i;
                }
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'u' || this.myBuffer.charAt(i) == 'U') {
            int width = this.myBuffer.charAt(i) == 'u' ? 4 : 8;
            ++i;
            while (i < start + width + 2) {
                if (this.isEscapeEnd(i)) {
                    return i;
                }
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'N' && this.isUnicodeMode()) {
            ++i;
            while (i < this.myBufferEnd && this.myBuffer.charAt(i) != '}' && this.myBuffer.charAt(i) != '\\') {
                ++i;
            }
            if (i < this.myBufferEnd && this.myBuffer.charAt(i) == '}') {
                ++i;
            }
            return i;
        }
        return i + 1;
    }

    protected boolean isEscapeEnd(int offset) {
        return offset == this.myBufferEnd || this.myBuffer.charAt(offset) == '\n' || this.myBuffer.charAt(offset) == '\\';
    }

    public void advance() {
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.warn("Inconsistent: start " + this.myStart + ", end " + this.myEnd + ", buf end " + this.myBufferEnd);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/lexer/PyStringLiteralLexerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/lexer/PyStringLiteralLexerBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapeSequenceType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleStart";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

