/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.packaging.PyRequirementsAnalysisResult;
import com.jetbrains.python.packaging.PyRequirementsFileVisitor;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J$\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u001c\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001c0\u000b2\u0006\u0010$\u001a\u00020\u0004H\u0002J&\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0018R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/python/packaging/PyRequirementsFileVisitor;", "", "importedPackages", "", "", "Lcom/jetbrains/python/packaging/PyPackage;", "settings", "Lcom/jetbrains/python/packaging/PyPackageRequirementsSettings;", "(Ljava/util/Map;Lcom/jetbrains/python/packaging/PyPackageRequirementsSettings;)V", "collectedOutput", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "unchangedInBaseFiles", "unmatchedLines", "compatibleVersion", "", "requirement", "Lcom/jetbrains/python/packaging/PyRequirement;", "version", "specifyVersion", "convertToRequirementsEntry", "doVisitFile", "", "requirementsFile", "Lcom/intellij/psi/PsiFile;", "visitedFiles", "", "formatRequirement", "", "pkg", "lines", "isEditableSelf", "line", "isFileReference", "isSkipableInstallOption", "splitByRequirementsEntries", "requirementsText", "visitBaseFile", "filename", "directory", "Lcom/intellij/psi/PsiDirectory;", "visitRequirementsFile", "Lcom/jetbrains/python/packaging/PyRequirementsAnalysisResult;", "Companion", "intellij.python.community.impl"})
public final class PyRequirementsFileVisitor {
    private final Map<VirtualFile, List<String>> collectedOutput;
    private final List<String> unmatchedLines;
    private final List<String> unchangedInBaseFiles;
    private final Map<String, PyPackage> importedPackages;
    private final PyPackageRequirementsSettings settings;
    private static final List<String> vcsPrefixes;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final PyRequirementsAnalysisResult visitRequirementsFile(@NotNull PsiFile requirementsFile) {
        Intrinsics.checkNotNullParameter((Object)requirementsFile, (String)"requirementsFile");
        Object[] objectArray = new VirtualFile[1];
        VirtualFile virtualFile = requirementsFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"requirementsFile.virtualFile");
        objectArray[0] = virtualFile;
        this.doVisitFile(requirementsFile, SetsKt.mutableSetOf((Object[])objectArray));
        List<String> list = this.collectedOutput.remove(requirementsFile.getVirtualFile());
        Intrinsics.checkNotNull(list);
        List<String> currentFileOutput = list;
        return new PyRequirementsAnalysisResult(currentFileOutput, this.collectedOutput, this.unmatchedLines, this.unchangedInBaseFiles);
    }

    /*
     * WARNING - void declaration
     */
    private final void doVisitFile(PsiFile requirementsFile, Set<VirtualFile> visitedFiles) {
        boolean bl = false;
        List outputLines = new ArrayList();
        String string = requirementsFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requirementsFile.text");
        List<List<String>> entries = this.splitByRequirementsEntries(string);
        for (List<String> lines : entries) {
            String name;
            PyRequirement requirement;
            List<PyRequirement> parsed;
            String firstLine;
            if (lines.size() == 1 && (StringsKt.startsWith$default((String)(firstLine = (String)CollectionsKt.first(lines)), (String)"#", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)firstLine))) {
                outputLines.add(firstLine);
                continue;
            }
            String line2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)lines), (Function1)doVisitFile.line.1.INSTANCE), (Function1)doVisitFile.line.2.INSTANCE), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            if (this.isSkipableInstallOption(line2)) {
                outputLines.addAll((Collection)lines);
                continue;
            }
            if (this.settings.getModifyBaseFiles() && this.isFileReference(line2)) {
                String filename = (String)StringsKt.split$default((CharSequence)line2, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null).get(1);
                PsiDirectory psiDirectory = requirementsFile.getContainingDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"requirementsFile.containingDirectory");
                this.visitBaseFile(filename, psiDirectory, visitedFiles);
                outputLines.addAll((Collection)lines);
                continue;
            }
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(PyRequirementParser.fromText(line2, requirementsFile.getVirtualFile(), new LinkedHashSet()), (String)"PyRequirementParser.from\u2026tualFile, mutableSetOf())");
            if (this.isFileReference(line2)) {
                void $this$forEach$iv;
                if (parsed.isEmpty()) {
                    if (this.settings.getRemoveUnused()) continue;
                    outputLines.addAll((Collection)lines);
                    continue;
                }
                Sequence sequence = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)parsed), (Function1)((Function1)new Function1<PyRequirement, Boolean>(this){
                    final /* synthetic */ PyRequirementsFileVisitor this$0;

                    public final boolean invoke(PyRequirement it) {
                        Map map2 = PyRequirementsFileVisitor.access$getImportedPackages$p(this.this$0);
                        PyRequirement pyRequirement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)pyRequirement, (String)"it");
                        String string = pyRequirement.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        String string2 = string;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        string2 = string4;
                        bl = false;
                        Map map3 = map2;
                        boolean bl2 = false;
                        return map3.containsKey(string2);
                    }
                    {
                        this.this$0 = pyRequirementsFileVisitor;
                        super(1);
                    }
                })), (Function1)((Function1)new Function1<PyRequirement, Pair<? extends PyRequirement, ? extends PyPackage>>(this){
                    final /* synthetic */ PyRequirementsFileVisitor this$0;

                    @NotNull
                    public final Pair<PyRequirement, PyPackage> invoke(PyRequirement it) {
                        Map map2 = PyRequirementsFileVisitor.access$getImportedPackages$p(this.this$0);
                        PyRequirement pyRequirement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)pyRequirement, (String)"it");
                        String string = pyRequirement.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        String string2 = string;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        return TuplesKt.to((Object)it, map2.remove(string4));
                    }
                    {
                        this.this$0 = pyRequirementsFileVisitor;
                        super(1);
                    }
                })), (Function1)((Function1)new Function1<Pair<? extends PyRequirement, ? extends PyPackage>, Boolean>(this){
                    final /* synthetic */ PyRequirementsFileVisitor this$0;

                    public final boolean invoke(@NotNull Pair<? extends PyRequirement, PyPackage> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        Object object = it.getFirst();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
                        PyRequirement pyRequirement = (PyRequirement)object;
                        Object object2 = it.getSecond();
                        Intrinsics.checkNotNull((Object)object2);
                        String string = ((PyPackage)((Object)object2)).getVersion();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.second!!.version");
                        return PyRequirementsFileVisitor.access$compatibleVersion(this.this$0, pyRequirement, string, PyRequirementsFileVisitor.access$getSettings$p(this.this$0).getSpecifyVersion());
                    }
                    {
                        this.this$0 = pyRequirementsFileVisitor;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl3 = false;
                    Object object = it.getFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
                    String string2 = ((PyRequirement)object).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.first.name");
                    this.unchangedInBaseFiles.add(string2);
                }
                outputLines.addAll((Collection)lines);
                continue;
            }
            if (parsed.isEmpty()) {
                if (this.settings.getRemoveUnused()) {
                    this.unmatchedLines.add(line2);
                    continue;
                }
                outputLines.addAll((Collection)lines);
                continue;
            }
            PyRequirement pyRequirement = requirement = (PyRequirement)CollectionsKt.first(parsed);
            Intrinsics.checkNotNullExpressionValue((Object)pyRequirement, (String)"requirement");
            String string3 = pyRequirement.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requirement.name");
            Object object = string3;
            boolean element$iv = false;
            String string4 = object;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            object = this.importedPackages;
            element$iv = false;
            Object object2 = object;
            boolean bl4 = false;
            if (object2.containsKey(name)) {
                PyPackage pkg;
                Intrinsics.checkNotNull((Object)((Object)this.importedPackages.remove(name)));
                List<String> formatted = this.formatRequirement(requirement, pkg, lines);
                outputLines.addAll((Collection)formatted);
                continue;
            }
            if (this.settings.getRemoveUnused()) continue;
            outputLines.addAll((Collection)lines);
        }
        VirtualFile virtualFile = requirementsFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"requirementsFile.virtualFile");
        this.collectedOutput.put(virtualFile, outputLines);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<String> formatRequirement(PyRequirement requirement, PyPackage pkg, List<String> lines) {
        List list;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    if (requirement.isEditable()) break block10;
                    Iterable $this$any$iv = vcsPrefixes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)((String)CollectionsKt.first((List)lines)), (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block11;
            }
            list = lines;
            return list;
        }
        if (this.settings.getKeepMatchingSpecifier()) {
            String string = pkg.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pkg.version");
            if (this.compatibleVersion(requirement, string, this.settings.getSpecifyVersion())) {
                list = lines;
                return list;
            }
        }
        list = CollectionsKt.listOf((Object)this.convertToRequirementsEntry(requirement, this.settings, pkg.getVersion()));
        return list;
    }

    private final void visitBaseFile(String filename, PsiDirectory directory2, Set<VirtualFile> visitedFiles) {
        VirtualFile referencedFile = directory2.getVirtualFile().findFileByRelativePath(filename);
        if (referencedFile != null && visitedFiles.add(referencedFile)) {
            PsiFile psiFile = directory2.getManager().findFile(referencedFile);
            Intrinsics.checkNotNull((Object)psiFile);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"directory.manager.findFile(referencedFile)!!");
            PsiFile baseRequirementsFile = psiFile;
            this.doVisitFile(baseRequirementsFile, visitedFiles);
            visitedFiles.remove(referencedFile);
        }
    }

    private final List<List<String>> splitByRequirementsEntries(String requirementsText) {
        boolean bl = false;
        List splitList = new ArrayList();
        boolean bl2 = false;
        List resultList = new ArrayList();
        Object object = requirementsText;
        boolean bl3 = false;
        if (!StringsKt.isBlank((CharSequence)object)) {
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)requirementsText);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl4 = false;
                splitList.add(it);
                if (StringsKt.endsWith$default((String)it, (String)"\\", (boolean)false, (int)2, null)) continue;
                resultList.add(splitList);
                boolean bl5 = false;
                splitList = new ArrayList();
            }
        }
        object = splitList;
        bl3 = false;
        if (!object.isEmpty()) {
            String string = PyBundle.message("python.requirements.error.ends.with.slash", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"python\u2026s.error.ends.with.slash\")");
            object = string;
            bl3 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean compatibleVersion(PyRequirement requirement, String version, boolean specifyVersion) {
        if (specifyVersion) {
            PyRequirementVersionSpec it;
            List<PyRequirementVersionSpec> list = requirement.getVersionSpecs();
            Intrinsics.checkNotNullExpressionValue(list, (String)"requirement.versionSpecs");
            Collection collection = list;
            boolean bl = false;
            if (collection.isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            List<PyRequirementVersionSpec> list2 = requirement.getVersionSpecs();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"requirement.versionSpecs");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                it = (PyRequirementVersionSpec)element$iv;
                boolean bl3 = false;
            } while (it.matches(version));
            return false;
        }
        boolean bl = requirement.getVersionSpecs().isEmpty();
        return bl;
    }

    private final String convertToRequirementsEntry(PyRequirement requirement, PyPackageRequirementsSettings settings, String version) {
        String packageName;
        String string;
        if (settings.getSpecifyVersion()) {
            if (version != null) {
                string = requirement.getName() + requirement.getExtras() + settings.getVersionSpecifier().getSeparator() + version;
            } else {
                String string2 = requirement.getPresentableText();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"requirement.presentableText");
            }
        } else {
            string = packageName = requirement.getName() + requirement.getExtras();
        }
        if (requirement.getInstallOptions().size() == 1) {
            return packageName;
        }
        String offset = StringsKt.repeat((CharSequence)" ", (int)(packageName.length() + 1));
        List<String> list = requirement.getInstallOptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"requirement.installOptions");
        String installOptions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)list, (int)1), (CharSequence)("\\\n" + offset), null, null, (int)0, null, null, (int)62, null);
        return packageName + ' ' + installOptions;
    }

    static /* synthetic */ String convertToRequirementsEntry$default(PyRequirementsFileVisitor pyRequirementsFileVisitor, PyRequirement pyRequirement, PyPackageRequirementsSettings pyPackageRequirementsSettings, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return pyRequirementsFileVisitor.convertToRequirementsEntry(pyRequirement, pyPackageRequirementsSettings, string);
    }

    private final boolean isSkipableInstallOption(String line2) {
        return this.isEditableSelf(line2) || StringsKt.startsWith$default((String)line2, (String)"--", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)line2, (String)"--editable", (boolean)false, (int)2, null) && !this.isFileReference(line2);
    }

    private final boolean isFileReference(String line2) {
        return StringsKt.startsWith$default((String)line2, (String)"-r ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line2, (String)"--requirement ", (boolean)false, (int)2, null);
    }

    private final boolean isEditableSelf(String line2) {
        return StringsKt.startsWith$default((String)line2, (String)"--editable .", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line2, (String)"-e .", (boolean)false, (int)2, null);
    }

    public PyRequirementsFileVisitor(@NotNull Map<String, PyPackage> importedPackages2, @NotNull PyPackageRequirementsSettings settings) {
        Intrinsics.checkNotNullParameter(importedPackages2, (String)"importedPackages");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.importedPackages = importedPackages2;
        this.settings = settings;
        boolean bl = false;
        this.collectedOutput = new LinkedHashMap();
        bl = false;
        this.unmatchedLines = new ArrayList();
        bl = false;
        this.unchangedInBaseFiles = new ArrayList();
    }

    static {
        Companion = new Companion(null);
        vcsPrefixes = CollectionsKt.listOf((Object[])new String[]{"git:", "git+", "svn+", "hg+", "bzr+"});
    }

    public static final /* synthetic */ Map access$getImportedPackages$p(PyRequirementsFileVisitor $this) {
        return $this.importedPackages;
    }

    public static final /* synthetic */ boolean access$compatibleVersion(PyRequirementsFileVisitor $this, PyRequirement requirement, String version, boolean specifyVersion) {
        return $this.compatibleVersion(requirement, version, specifyVersion);
    }

    public static final /* synthetic */ PyPackageRequirementsSettings access$getSettings$p(PyRequirementsFileVisitor $this) {
        return $this.settings;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/packaging/PyRequirementsFileVisitor$Companion;", "", "()V", "vcsPrefixes", "", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

