/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.toolwindow;

import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SideBorder;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.packaging.toolwindow.DisplayablePackage;
import com.jetbrains.python.packaging.toolwindow.ExpandResultNode;
import com.jetbrains.python.packaging.toolwindow.PyPackagesViewData;
import com.jetbrains.python.packaging.toolwindow.PyPackagingTablesView;
import com.jetbrains.python.packaging.toolwindow.PyPackagingToolWindowService;
import com.jetbrains.python.packaging.toolwindow.PyPaginationAwareRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001-B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0000\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001f\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b&\u0010'J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0002J\u0015\u0010+\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b,R0\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/jetbrains/python/packaging/toolwindow/PyPackagesTable;", "T", "Lcom/jetbrains/python/packaging/toolwindow/DisplayablePackage;", "Lcom/intellij/ui/table/JBTable;", "model", "Lcom/intellij/util/ui/ListTableModel;", "service", "Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowService;", "tablesView", "Lcom/jetbrains/python/packaging/toolwindow/PyPackagingTablesView;", "(Lcom/intellij/util/ui/ListTableModel;Lcom/jetbrains/python/packaging/toolwindow/PyPackagingToolWindowService;Lcom/jetbrains/python/packaging/toolwindow/PyPackagingTablesView;)V", "value", "", "items", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "lastSelectedRow", "", "listModel", "getListModel$annotations", "()V", "getListModel", "()Lcom/intellij/util/ui/ListTableModel;", "addRows", "", "rows", "addRows$intellij_python_community_impl", "clearSelection", "getCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "row", "column", "initCrossNavigation", "insertRow", "index", "pkg", "insertRow$intellij_python_community_impl", "(ILcom/jetbrains/python/packaging/toolwindow/DisplayablePackage;)V", "loadMoreItems", "node", "Lcom/jetbrains/python/packaging/toolwindow/ExpandResultNode;", "removeRow", "removeRow$intellij_python_community_impl", "Companion", "intellij.python.community.impl"})
public final class PyPackagesTable<T extends DisplayablePackage>
extends JBTable {
    private int lastSelectedRow;
    private static final String NEXT_ROW_ACTION = "selectNextRow";
    private static final String PREVIOUS_ROW_ACTION = "selectPreviousRow";
    private static final String ENTER_ACTION = "ENTER";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void initCrossNavigation(PyPackagingToolWindowService service, PyPackagingTablesView tablesView) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), ENTER_ACTION);
        this.getActionMap().put(ENTER_ACTION, new AbstractAction(this, service){
            final /* synthetic */ PyPackagesTable this$0;
            final /* synthetic */ PyPackagingToolWindowService $service;

            public void actionPerformed(@Nullable ActionEvent e) {
                if (this.this$0.getSelectedRow() == -1) {
                    return;
                }
                int index = this.this$0.getSelectedRow();
                DisplayablePackage selectedItem = (DisplayablePackage)this.this$0.getItems().get(this.this$0.getSelectedRow());
                if (selectedItem instanceof ExpandResultNode) {
                    PyPackagesTable.access$loadMoreItems(this.this$0, this.$service, (ExpandResultNode)selectedItem);
                }
                this.this$0.setRowSelectionInterval(index, index);
            }
            {
                this.this$0 = this$0;
                this.$service = $captured_local_variable$1;
            }
        });
        Action nextRowAction = this.getActionMap().get(NEXT_ROW_ACTION);
        this.getActionMap().put(NEXT_ROW_ACTION, new AbstractAction(this, tablesView, nextRowAction){
            final /* synthetic */ PyPackagesTable this$0;
            final /* synthetic */ PyPackagingTablesView $tablesView;
            final /* synthetic */ Action $nextRowAction;

            public void actionPerformed(@Nullable ActionEvent e) {
                if (this.this$0.getSelectedRow() == -1) {
                    return;
                }
                if (this.this$0.getSelectedRow() + 1 == this.this$0.getItems().size()) {
                    this.$tablesView.selectNextFrom((JTable)((Object)this.this$0));
                } else {
                    this.$nextRowAction.actionPerformed(e);
                }
            }
            {
                this.this$0 = this$0;
                this.$tablesView = $captured_local_variable$1;
                this.$nextRowAction = $captured_local_variable$2;
            }
        });
        Action prevRowAction = this.getActionMap().get(PREVIOUS_ROW_ACTION);
        this.getActionMap().put(PREVIOUS_ROW_ACTION, new AbstractAction(this, tablesView, prevRowAction){
            final /* synthetic */ PyPackagesTable this$0;
            final /* synthetic */ PyPackagingTablesView $tablesView;
            final /* synthetic */ Action $prevRowAction;

            public void actionPerformed(@Nullable ActionEvent e) {
                if (this.this$0.getSelectedRow() == -1) {
                    return;
                }
                if (this.this$0.getSelectedRow() == 0) {
                    this.$tablesView.selectPreviousOf((JTable)((Object)this.this$0));
                } else {
                    this.$prevRowAction.actionPerformed(e);
                }
            }
            {
                this.this$0 = this$0;
                this.$tablesView = $captured_local_variable$1;
                this.$prevRowAction = $captured_local_variable$2;
            }
        });
    }

    private final void loadMoreItems(PyPackagingToolWindowService service, ExpandResultNode node) {
        PyPackagesViewData result = service.getMoreResultsForRepo(node.getRepository(), this.getItems().size() - 1);
        List<DisplayablePackage> list = result.getPackages();
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<T>");
        }
        this.setItems(CollectionsKt.plus((Collection)CollectionsKt.dropLast(this.getItems(), (int)1), (Iterable)list));
        if (result.getMoreItems() > 0) {
            node.setMore(result.getMoreItems());
            List list2 = CollectionsKt.listOf((Object)node);
            if (list2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<T>");
            }
            this.setItems(CollectionsKt.plus((Collection)this.getItems(), (Iterable)list2));
        }
        this.revalidate();
        this.repaint();
    }

    @NotNull
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new PyPaginationAwareRenderer();
    }

    public void clearSelection() {
        this.lastSelectedRow = -1;
        super.clearSelection();
    }

    public final void addRows$intellij_python_community_impl(@NotNull List<? extends T> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        this.getListModel().addRows((Collection)rows);
    }

    public final void removeRow$intellij_python_community_impl(int index) {
        this.getListModel().removeRow(index);
    }

    public final void insertRow$intellij_python_community_impl(int index, @NotNull T pkg) {
        Intrinsics.checkNotNullParameter(pkg, (String)"pkg");
        this.getListModel().insertRow(index, pkg);
    }

    private static /* synthetic */ void getListModel$annotations() {
    }

    private final ListTableModel<T> getListModel() {
        TableModel tableModel = this.getModel();
        if (tableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.ui.ListTableModel<T>");
        }
        return (ListTableModel)tableModel;
    }

    @NotNull
    public final List<T> getItems() {
        List list = this.getListModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"listModel.items");
        return list;
    }

    public final void setItems(@NotNull List<? extends T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getListModel().setItems(value);
    }

    public PyPackagesTable(final @NotNull ListTableModel<T> model, final @NotNull PyPackagingToolWindowService service, final @NotNull PyPackagingTablesView tablesView) {
        TableColumn column;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)tablesView, (String)"tablesView");
        super((TableModel)model);
        this.lastSelectedRow = -1;
        this.setShowGrid(false);
        this.setSelectionMode(0);
        TableColumn tableColumn = column = this.columnModel.getColumn(1);
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"column");
        tableColumn.setMaxWidth(100);
        column.setResizable(false);
        this.setBorder((Border)new SideBorder(UIUtil.getBoundsColor(), 8));
        this.rowHeight = 20;
        this.initCrossNavigation(service, tablesView);
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(ListSelectionEvent it) {
                if (this.getSelectedRow() != -1 && this.getSelectedRow() != lastSelectedRow) {
                    lastSelectedRow = this.getSelectedRow();
                    tablesView.requestSelection((JTable)((Object)this));
                    DisplayablePackage pkg = (DisplayablePackage)model.getItems().get(this.getSelectedRow());
                    if (!(pkg instanceof ExpandResultNode)) {
                        DisplayablePackage displayablePackage = pkg;
                        Intrinsics.checkNotNullExpressionValue((Object)displayablePackage, (String)"pkg");
                        service.packageSelected(displayablePackage);
                    }
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DisplayablePackage pkg = (DisplayablePackage)model.getItems().get(this.getSelectedRow());
                if (pkg instanceof ExpandResultNode) {
                    this.loadMoreItems(service, (ExpandResultNode)pkg);
                }
                return true;
            }
        }.installOn((Component)((Object)this));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/packaging/toolwindow/PyPackagesTable$Companion;", "", "()V", "ENTER_ACTION", "", "NEXT_ROW_ACTION", "PREVIOUS_ROW_ACTION", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

