/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyPossibleClassMember;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.psi.stubs.PyClassAttributesIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyResolveUtil {
    private PyResolveUtil() {
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement element, @Nullable String name, @Nullable PsiElement roof) {
        PsiFile globalScope;
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(1);
        }
        ScopeOwner originalOwner = ScopeUtil.getScopeOwner(element);
        PsiElement parent = element.getParent();
        ScopeOwner owner = originalOwner;
        if (parent instanceof PyNonlocalStatement) {
            ScopeOwner outerScopeOwner = ScopeUtil.getScopeOwner((PsiElement)owner);
            if (outerScopeOwner != null) {
                owner = outerScopeOwner;
            }
        } else if (parent instanceof PyGlobalStatement && (globalScope = element.getContainingFile()) instanceof PyFile) {
            owner = (PyFile)globalScope;
        }
        PyResolveUtil.scopeCrawlUp(processor2, owner, originalOwner, name, roof);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @NotNull ScopeOwner scopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(2);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(3);
        }
        PyResolveUtil.scopeCrawlUp(processor2, scopeOwner, scopeOwner, name, roof);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @Nullable ScopeOwner scopeOwner, @Nullable ScopeOwner originalScopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(4);
        }
        while (scopeOwner != null) {
            if (!(scopeOwner instanceof PyClass) || scopeOwner == originalScopeOwner) {
                Scope scope = ControlFlowCache.getScope(scopeOwner);
                if (name != null) {
                    boolean includeNestedGlobals = scopeOwner instanceof PyFile;
                    for (PsiNamedElement resolved : scope.getNamedElements(name, includeNestedGlobals)) {
                        if (processor2.execute((PsiElement)resolved, ResolveState.initial())) continue;
                        return;
                    }
                } else {
                    for (PsiNamedElement element : scope.getNamedElements()) {
                        if (processor2.execute((PsiElement)element, ResolveState.initial())) continue;
                        return;
                    }
                }
                for (PyImportedNameDefiner definer : scope.getImportedNameDefiners()) {
                    if (processor2.execute((PsiElement)definer, ResolveState.initial())) continue;
                    return;
                }
            }
            if (scopeOwner == roof) {
                return;
            }
            if (name != null && scopeOwner instanceof PyClass && scopeOwner == originalScopeOwner) {
                scopeOwner = PyResolveUtil.parentScopeForUnresolvedClassLevelName((PyClass)scopeOwner, name);
                continue;
            }
            scopeOwner = ScopeUtil.getScopeOwner((PsiElement)scopeOwner);
        }
    }

    @NotNull
    public static Collection<PsiElement> resolveLocally(@NotNull PyReferenceExpression referenceExpression) {
        String referenceName;
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(5);
        }
        if ((referenceName = referenceExpression.getName()) == null || referenceExpression.isQualified()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(referenceName, true);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, (PsiElement)referenceExpression, referenceName, null);
        Collection<PsiElement> collection = processor2.getElements();
        if (collection == null) {
            PyResolveUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveLocally(@NotNull ScopeOwner scopeOwner, @NotNull String name) {
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(9);
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(name, true);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, scopeOwner, name, null);
        Collection<PsiElement> collection = processor2.getElements();
        if (collection == null) {
            PyResolveUtil.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static List<QualifiedName> resolveImportedElementQNameLocally(@NotNull PyReferenceExpression expression) {
        PyExpression qualifier;
        if (expression == null) {
            PyResolveUtil.$$$reportNull$$$0(11);
        }
        if ((qualifier = expression.getQualifier()) instanceof PyReferenceExpression) {
            String name = expression.getName();
            List list = name == null ? Collections.emptyList() : ContainerUtil.map(PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)qualifier), qn -> qn.append(name));
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        List list = PyResolveUtil.fullMultiResolveLocally(expression, new HashSet<PyReferenceExpression>()).select(PyImportElement.class).map(PyResolveUtil::getImportedElementQName).nonNull().toList();
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    private static QualifiedName getImportedElementQName(@NotNull PyImportElement element) {
        PyStatement importStatement;
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(14);
        }
        if ((importStatement = element.getContainingImportStatement()) instanceof PyFromImportStatement) {
            QualifiedName importSourceQName = ((PyFromImportStatement)importStatement).getImportSourceQName();
            QualifiedName importedQName = element.getImportedQName();
            if (importSourceQName != null && importedQName != null) {
                return importSourceQName.append(importedQName);
            }
        }
        return element.getImportedQName();
    }

    @NotNull
    public static List<PsiElement> resolveQualifiedNameInScope(@NotNull QualifiedName qualifiedName, @NotNull ScopeOwner scopeOwner, @NotNull TypeEvalContext context2) {
        if (qualifiedName == null) {
            PyResolveUtil.$$$reportNull$$$0(15);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            PyResolveUtil.$$$reportNull$$$0(17);
        }
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)scopeOwner, Pair.create((Object)qualifiedName, (Object)context2), param -> PyResolveUtil.doResolveQualifiedNameInScope((QualifiedName)param.getFirst(), scopeOwner, (TypeEvalContext)param.getSecond()));
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> doResolveQualifiedNameInScope(@NotNull QualifiedName qualifiedName, @NotNull ScopeOwner scopeOwner, @NotNull TypeEvalContext context2) {
        StreamEx initialResults;
        List unqualifiedResults;
        String firstName;
        if (qualifiedName == null) {
            PyResolveUtil.$$$reportNull$$$0(19);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(20);
        }
        if (context2 == null) {
            PyResolveUtil.$$$reportNull$$$0(21);
        }
        if ((firstName = qualifiedName.getFirstComponent()) == null || !(scopeOwner instanceof PyTypedElement)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PyResolveUtil.$$$reportNull$$$0(22);
            }
            return list;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context2);
        if (scopeOwner instanceof PyiFile) {
            unqualifiedResults = ((PyiFile)scopeOwner).multiResolveName(firstName, false);
        } else if (scopeOwner instanceof PyFunction) {
            StreamEx targets = ((StreamEx)StreamEx.of((Collection)PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)scopeOwner, PyTargetExpression.class)).filter(it -> !it.isQualified())).select(PsiNamedElement.class);
            StreamEx parameters = StreamEx.of((Object[])((PyFunction)scopeOwner).getParameterList().getParameters()).select(PsiNamedElement.class);
            unqualifiedResults = ((StreamEx)((StreamEx)StreamEx.of((Stream)targets).append((Stream)parameters)).filter(it -> firstName.equals(it.getName()))).map(it -> new RatedResolveResult(0, (PsiElement)it)).toList();
        } else {
            PyType scopeType = context2.getType((PyTypedElement)((Object)scopeOwner));
            if (scopeType == null) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    PyResolveUtil.$$$reportNull$$$0(23);
                }
                return list;
            }
            unqualifiedResults = scopeType.resolveMember(firstName, null, AccessDirection.READ, resolveContext);
        }
        if (ContainerUtil.isEmpty(unqualifiedResults)) {
            PsiElement builtin = PyBuiltinCache.getInstance((PsiElement)scopeOwner).getByName(firstName);
            if (builtin == null) {
                List<PsiElement> list = Collections.emptyList();
                if (list == null) {
                    PyResolveUtil.$$$reportNull$$$0(24);
                }
                return list;
            }
            initialResults = StreamEx.of((Object)new RatedResolveResult(0, builtin));
        } else {
            initialResults = StreamEx.of(unqualifiedResults);
        }
        List remainingNames = qualifiedName.removeHead(1).getComponents();
        StreamEx result = (StreamEx)StreamEx.of((Collection)remainingNames).foldLeft((Object)initialResults, (prev, name) -> prev.map(RatedResolveResult::getElement).select(PyTypedElement.class).map(context2::getType).nonNull().flatMap(type -> {
            PyType instanceType = type instanceof PyClassLikeType ? ((PyClassLikeType)type).toInstance() : type;
            List<? extends RatedResolveResult> results = instanceType.resolveMember((String)name, null, AccessDirection.READ, resolveContext);
            return results != null ? StreamEx.of(results) : StreamEx.empty();
        }));
        List<PsiElement> list = Collections.unmodifiableList(PyUtil.filterTopPriorityResults((ResolveResult[])result.toArray(RatedResolveResult[]::new)));
        if (list == null) {
            PyResolveUtil.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    public static String resolveStrArgument(@NotNull PyCallExpression callExpression, int index, @NotNull String keyword) {
        PyExpression expression;
        if (callExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(26);
        }
        if (keyword == null) {
            PyResolveUtil.$$$reportNull$$$0(27);
        }
        if ((expression = PyPsiUtils.flattenParens(callExpression.getArgument(index, keyword, PyExpression.class))) instanceof PyReferenceExpression) {
            return PyPsiUtils.strValue(PyResolveUtil.fullResolveLocally((PyReferenceExpression)expression));
        }
        return PyPsiUtils.strValue(expression);
    }

    @Nullable
    public static PyExpression fullResolveLocally(@NotNull PyReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(28);
        }
        return PyResolveUtil.fullMultiResolveLocally(referenceExpression, new HashSet<PyReferenceExpression>()).select(PyExpression.class).findFirst().orElse(null);
    }

    @NotNull
    private static StreamEx<PsiElement> fullMultiResolveLocally(@NotNull PyReferenceExpression referenceExpression, @NotNull Set<PyReferenceExpression> visited) {
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(29);
        }
        if (visited == null) {
            PyResolveUtil.$$$reportNull$$$0(30);
        }
        StreamEx streamEx = StreamEx.of(PyResolveUtil.resolveLocally(referenceExpression)).flatMap(element -> {
            if (element instanceof PyTargetExpression) {
                PyExpression assignedValue = ((PyTargetExpression)element).findAssignedValue();
                if (assignedValue instanceof PyReferenceExpression && visited.add((PyReferenceExpression)assignedValue)) {
                    return PyResolveUtil.fullMultiResolveLocally((PyReferenceExpression)assignedValue, visited);
                }
                return StreamEx.of((Object)assignedValue);
            }
            return StreamEx.of((Object)element);
        });
        if (streamEx == null) {
            PyResolveUtil.$$$reportNull$$$0(31);
        }
        return streamEx;
    }

    public static boolean allowForwardReferences(@NotNull PyQualifiedExpression element) {
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(32);
        }
        if (PyiUtil.isInsideStub((PsiElement)element)) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            return pyFile.getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37) && pyFile.hasImportFromFuture(FutureFeature.ANNOTATIONS) && PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class) != null;
        }
        return false;
    }

    @Nullable
    public static ScopeOwner parentScopeForUnresolvedClassLevelName(@NotNull PyClass cls, @NotNull String name) {
        if (cls == null) {
            PyResolveUtil.$$$reportNull$$$0(33);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(34);
        }
        return PyResolveUtil.containsDeclaration(cls, name) ? (ScopeOwner)PyUtil.as(cls.getContainingFile(), PyFile.class) : ScopeUtil.getScopeOwner((PsiElement)cls);
    }

    private static boolean containsDeclaration(@NotNull PyClass cls, @NotNull String name) {
        Scope scope;
        if (cls == null) {
            PyResolveUtil.$$$reportNull$$$0(35);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(36);
        }
        if (!(scope = ControlFlowCache.getScope(cls)).getNamedElements(name, false).isEmpty()) {
            return true;
        }
        return StreamEx.of(scope.getImportedNameDefiners()).select(PyImportElement.class).anyMatch(e -> name.equals(e.getVisibleName()));
    }

    public static void addImplicitResolveResults(@NotNull String referencedName, @NotNull ResolveResultList ret, @NotNull PyQualifiedExpression element) {
        if (referencedName == null) {
            PyResolveUtil.$$$reportNull$$$0(37);
        }
        if (ret == null) {
            PyResolveUtil.$$$reportNull$$$0(38);
        }
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(39);
        }
        Project project = element.getProject();
        GlobalSearchScope scope = PySearchUtilBase.excludeSdkTestsScope(project);
        Collection<PyFunction> functions = PyFunctionNameIndex.find(referencedName, project, scope);
        PsiFile containingFile = element.getContainingFile();
        List<Object> imports = containingFile instanceof PyFile ? PyResolveUtil.collectImports((PyFile)containingFile) : Collections.emptyList();
        for (PyFunction function : functions) {
            if (function.getContainingClass() == null) continue;
            ret.add(new ImplicitResolveResult(function, PyResolveUtil.getImplicitResultRate(function, imports, element)));
        }
        PyClassAttributesIndex.findClassAndInstanceAttributes(referencedName, project, scope).forEach(attribute -> ret.add(new ImplicitResolveResult((PsiElement)attribute, PyResolveUtil.getImplicitResultRate(attribute, imports, element))));
    }

    private static List<QualifiedName> collectImports(PyFile containingFile) {
        ArrayList<QualifiedName> imports = new ArrayList<QualifiedName>();
        for (PyFromImportStatement anImport : containingFile.getFromImports()) {
            QualifiedName source = anImport.getImportSourceQName();
            if (source == null) continue;
            imports.add(source);
        }
        for (PyImportElement importElement : containingFile.getImportTargets()) {
            QualifiedName qName = importElement.getImportedQName();
            if (qName == null) continue;
            imports.add(qName.removeLastComponent());
        }
        return imports;
    }

    private static int getImplicitResultRate(PyElement target, List<QualifiedName> imports, PyQualifiedExpression element) {
        int rate = -1000;
        if (target.getContainingFile() == element.getContainingFile()) {
            rate += 200;
        } else {
            VirtualFile vFile = target.getContainingFile().getVirtualFile();
            if (vFile != null) {
                QualifiedName qName;
                if (ProjectScope.getProjectScope((Project)element.getProject()).contains(vFile)) {
                    rate += 80;
                }
                if ((qName = QualifiedNameFinder.findShortestImportableQName((PsiElement)element, vFile)) != null && imports.contains(qName)) {
                    rate += 70;
                }
            }
        }
        if (element.getParent() instanceof PyCallExpression) {
            if (target instanceof PyFunction) {
                rate += 50;
            }
        } else if (!(target instanceof PyFunction)) {
            rate += 50;
        }
        return rate;
    }

    @Nullable
    public static PsiElement resolveDeclaration(@NotNull PsiReference reference, @NotNull PyResolveContext resolveContext) {
        PyClassType type;
        PyCallExpression call;
        if (reference == null) {
            PyResolveUtil.$$$reportNull$$$0(40);
        }
        if (resolveContext == null) {
            PyResolveUtil.$$$reportNull$$$0(41);
        }
        PsiElement element = reference.getElement();
        TypeEvalContext context2 = resolveContext.getTypeEvalContext();
        PyCallExpression pyCallExpression = call = context2.maySwitchToAST(element) ? PyCallExpressionNavigator.getPyCallExpressionByCallee(element) : null;
        if (call != null && element instanceof PyTypedElement && (type = PyUtil.as(context2.getType((PyTypedElement)element), PyClassType.class)) != null && type.isDefinition()) {
            PyClass cls = type.getPyClass();
            PsiElement constructor = (PsiElement)ContainerUtil.find(PyUtil.filterTopPriorityElements(PyCallExpressionHelper.resolveImplicitlyInvokedMethods(type, call, resolveContext)), it -> it instanceof PyPossibleClassMember && ((PyPossibleClassMember)it).getContainingClass() == cls);
            if (constructor != null) {
                return constructor;
            }
        }
        return reference.resolve();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 14: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeOwner";
                break;
            }
            case 5: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/PyResolveUtil";
                break;
            }
            case 9: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ret";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/PyResolveUtil";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocally";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImportedElementQNameLocally";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedNameInScope";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveQualifiedNameInScope";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "fullMultiResolveLocally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scopeCrawlUp";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportedElementQNameLocally";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getImportedElementQName";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedNameInScope";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doResolveQualifiedNameInScope";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveStrArgument";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fullResolveLocally";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fullMultiResolveLocally";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "allowForwardReferences";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "parentScopeForUnresolvedClassLevelName";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "containsDeclaration";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitResolveResults";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "resolveDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

