/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import org.jetbrains.annotations.NotNull;

final class DependencyVisitor
extends PyRecursiveElementVisitor {
    @NotNull
    private final PyElement myElementToFind;
    private boolean myDependencyFound;

    DependencyVisitor(@NotNull PyElement elementToFind) {
        if (elementToFind == null) {
            DependencyVisitor.$$$reportNull$$$0(0);
        }
        this.myElementToFind = elementToFind;
    }

    @Override
    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        PsiReference reference;
        PyExpression value;
        if (node == null) {
            DependencyVisitor.$$$reportNull$$$0(1);
        }
        if ((value = node.findAssignedValue()) != null && (reference = value.getReference()) != null && reference.isReferenceTo((PsiElement)this.myElementToFind)) {
            this.myDependencyFound = true;
            return;
        }
        super.visitPyTargetExpression(node);
    }

    @Override
    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        PyExpression callee;
        if (node == null) {
            DependencyVisitor.$$$reportNull$$$0(2);
        }
        if ((callee = node.getCallee()) != null) {
            PyArgumentList list;
            PsiReference calleeReference = callee.getReference();
            if (calleeReference != null && calleeReference.isReferenceTo((PsiElement)this.myElementToFind)) {
                this.myDependencyFound = true;
                return;
            }
            String calleeName = callee.getName();
            String name = this.myElementToFind.getName();
            if (calleeName != null && calleeName.equals(name)) {
                this.myDependencyFound = true;
            }
            if ((list = node.getArgumentList()) != null) {
                for (PyExpression expression : node.getArgumentList().getArgumentExpressions()) {
                    PsiReference reference = expression.getReference();
                    if (reference != null && reference.isReferenceTo((PsiElement)this.myElementToFind)) {
                        this.myDependencyFound = true;
                    }
                    if (name == null || !name.equals(expression.getName())) continue;
                    this.myDependencyFound = true;
                }
            }
        }
    }

    @Override
    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        PsiPolyVariantReference reference;
        if (node == null) {
            DependencyVisitor.$$$reportNull$$$0(3);
        }
        if ((reference = node.getReference()).isReferenceTo((PsiElement)this.myElementToFind)) {
            this.myDependencyFound = true;
            return;
        }
        if (this.myElementToFind instanceof PyAssignmentStatement) {
            PyExpression[] targets = ((PyAssignmentStatement)this.myElementToFind).getTargets();
            if (targets.length != 1) {
                return;
            }
            PyExpression expression = targets[0];
            if (reference.isReferenceTo((PsiElement)expression)) {
                this.myDependencyFound = true;
                return;
            }
            if (node.getText().equals(expression.getText())) {
                this.myDependencyFound = true;
            }
            return;
        }
        PsiElement declaration = reference.resolve();
        this.myDependencyFound = PsiTreeUtil.findFirstParent((PsiElement)declaration, (Condition)new PsiElementCondition()) != null;
    }

    public boolean isDependencyFound() {
        return this.myDependencyFound;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToFind";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/classes/DependencyVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyTargetExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyCallExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyReferenceExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class PsiElementCondition
    implements Condition<PsiElement> {
        private PsiElementCondition() {
        }

        public boolean value(PsiElement psiElement) {
            return psiElement.equals(DependencyVisitor.this.myElementToFind);
        }
    }
}

