/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.PySdkTargetPaths;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.JythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetedPythonPaths {
    private TargetedPythonPaths() {
    }

    public static void initPythonPath(@NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) {
        if (envs == null) {
            TargetedPythonPaths.$$$reportNull$$$0(0);
        }
        if (pythonPathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(1);
        }
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(2);
        }
        if (passParentEnvs && targetEnvironmentRequest instanceof LocalTargetEnvironmentRequest && !envs.containsKey("PYTHONPATH")) {
            TargetedPythonPaths.appendSystemPythonPath(pythonPathList);
        }
        PythonScripts.appendToPythonPath(envs, pythonPathList, targetEnvironmentRequest.getTargetPlatform());
    }

    private static void appendSystemPythonPath(@NotNull Collection<Function<TargetEnvironment, String>> pythonPath) {
        String syspath;
        if (pythonPath == null) {
            TargetedPythonPaths.$$$reportNull$$$0(3);
        }
        if ((syspath = System.getenv("PYTHONPATH")) != null) {
            pythonPath.addAll(ContainerUtil.map((Object[])syspath.split(File.pathSeparator), s -> TargetEnvironmentFunctions.constant((Object)s)));
        }
    }

    @NotNull
    public static Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @Nullable Module module, @Nullable String sdkHome, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(4);
        }
        return TargetedPythonPaths.collectPythonPath(targetEnvironmentRequest, new LocalPathToTargetPathConverterImpl(targetEnvironmentRequest), module, sdkHome, shouldAddContentRoots, shouldAddSourceRoots, isDebug);
    }

    @NotNull
    public static Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull Project project, @Nullable Module module, @Nullable String sdkHome, @Nullable PyRemotePathMapper pathMapper, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(5);
        }
        if (project == null) {
            TargetedPythonPaths.$$$reportNull$$$0(6);
        }
        Sdk sdk = PythonSdkUtil.findSdkByPath(sdkHome);
        return TargetedPythonPaths.collectPythonPath(targetEnvironmentRequest, new LocalPathToTargetPathConverterSdkAware(targetEnvironmentRequest, project, sdk, pathMapper), module, sdkHome, shouldAddContentRoots, shouldAddSourceRoots, isDebug);
    }

    @NotNull
    private static Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull LocalPathToTargetPathConverter pathConverter, @Nullable Module module, @Nullable String sdkHome, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(7);
        }
        if (pathConverter == null) {
            TargetedPythonPaths.$$$reportNull$$$0(8);
        }
        LinkedHashSet<Function<TargetEnvironment, String>> pythonPath = new LinkedHashSet<Function<TargetEnvironment, String>>(TargetedPythonPaths.collectPythonPath(targetEnvironmentRequest, pathConverter, module, shouldAddContentRoots, shouldAddSourceRoots));
        if (isDebug && PythonSdkFlavor.getFlavor(sdkHome) instanceof JythonSdkFlavor) {
            for (String helpersResource : Arrays.asList("pycharm", "pydev")) {
                String helperPath = PythonHelpersLocator.getHelperPath(helpersResource);
                Function targetHelperPath = TargetEnvironmentFunctions.getTargetEnvironmentValueForLocalPath((TargetEnvironmentRequest)targetEnvironmentRequest, (String)helperPath);
                pythonPath.add(targetHelperPath);
            }
        }
        LinkedHashSet<Function<TargetEnvironment, String>> linkedHashSet = pythonPath;
        if (linkedHashSet == null) {
            TargetedPythonPaths.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull LocalPathToTargetPathConverter pathConverter, @Nullable Module module, boolean addContentRoots, boolean addSourceRoots) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(10);
        }
        if (pathConverter == null) {
            TargetedPythonPaths.$$$reportNull$$$0(11);
        }
        LinkedHashSet<Function<TargetEnvironment, String>> pythonPathList = new LinkedHashSet<Function<TargetEnvironment, String>>();
        if (module != null) {
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            if (addContentRoots) {
                TargetedPythonPaths.addRoots(pathConverter, pythonPathList, ModuleRootManager.getInstance((Module)module).getContentRoots());
                for (Module dependency : dependencies) {
                    TargetedPythonPaths.addRoots(pathConverter, pythonPathList, ModuleRootManager.getInstance((Module)dependency).getContentRoots());
                }
            }
            if (addSourceRoots) {
                TargetedPythonPaths.addRoots(pathConverter, pythonPathList, ModuleRootManager.getInstance((Module)module).getSourceRoots());
                for (Module dependency : dependencies) {
                    TargetedPythonPaths.addRoots(pathConverter, pythonPathList, ModuleRootManager.getInstance((Module)dependency).getSourceRoots());
                }
            }
            TargetedPythonPaths.addLibrariesFromModule(targetEnvironmentRequest, module, pythonPathList);
            TargetedPythonPaths.addRootsFromModule(module, pythonPathList);
            for (Module dependency : dependencies) {
                TargetedPythonPaths.addLibrariesFromModule(targetEnvironmentRequest, dependency, pythonPathList);
                TargetedPythonPaths.addRootsFromModule(dependency, pythonPathList);
            }
        }
        LinkedHashSet<Function<TargetEnvironment, String>> linkedHashSet = pythonPathList;
        if (linkedHashSet == null) {
            TargetedPythonPaths.$$$reportNull$$$0(12);
        }
        return linkedHashSet;
    }

    @NotNull
    public static List<Function<TargetEnvironment, String>> getAddedPaths(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull Sdk pythonSdk2) {
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(13);
        }
        if (pythonSdk2 == null) {
            TargetedPythonPaths.$$$reportNull$$$0(14);
        }
        ArrayList<Function<TargetEnvironment, String>> pathList = new ArrayList<Function<TargetEnvironment, String>>();
        SdkAdditionalData sdkAdditionalData = pythonSdk2.getSdkAdditionalData();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            Set<VirtualFile> addedPaths = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
            for (VirtualFile file : addedPaths) {
                TargetedPythonPaths.addToPythonPath(new LocalPathToTargetPathConverterImpl(targetEnvironmentRequest), file, pathList);
            }
        }
        ArrayList<Function<TargetEnvironment, String>> arrayList = pathList;
        if (arrayList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static void addToPythonPath(@NotNull LocalPathToTargetPathConverter pathConverter, @NotNull VirtualFile file, @NotNull Collection<Function<TargetEnvironment, String>> pathList) {
        if (pathConverter == null) {
            TargetedPythonPaths.$$$reportNull$$$0(16);
        }
        if (file == null) {
            TargetedPythonPaths.$$$reportNull$$$0(17);
        }
        if (pathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(18);
        }
        if (file.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (realFile != null) {
                TargetedPythonPaths.addIfNeeded(pathConverter, realFile, pathList);
            }
        } else {
            TargetedPythonPaths.addIfNeeded(pathConverter, file, pathList);
        }
    }

    private static void addIfNeeded(@NotNull LocalPathToTargetPathConverter pathConverter, @NotNull VirtualFile file, @NotNull Collection<Function<TargetEnvironment, String>> pathList) {
        if (pathConverter == null) {
            TargetedPythonPaths.$$$reportNull$$$0(19);
        }
        if (file == null) {
            TargetedPythonPaths.$$$reportNull$$$0(20);
        }
        if (pathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(21);
        }
        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        pathList.add(pathConverter.getTargetPath(filePath));
    }

    private static void addLibrariesFromModule(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull Module module, @NotNull Collection<Function<TargetEnvironment, String>> list) {
        OrderEntry[] entries;
        if (targetEnvironmentRequest == null) {
            TargetedPythonPaths.$$$reportNull$$$0(22);
        }
        if (module == null) {
            TargetedPythonPaths.$$$reportNull$$$0(23);
        }
        if (list == null) {
            TargetedPythonPaths.$$$reportNull$$$0(24);
        }
        for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            String name;
            if (!(entry instanceof LibraryOrderEntry) || (name = ((LibraryOrderEntry)entry).getLibraryName()) != null && name.endsWith(" interpreter library")) continue;
            for (VirtualFile root : ((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)) {
                PersistentLibraryKind kind;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    TargetedPythonPaths.addToPythonPath(new LocalPathToTargetPathConverterImpl(targetEnvironmentRequest), root, list);
                    continue;
                }
                if (!(library instanceof LibraryEx) || (kind = ((LibraryEx)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                TargetedPythonPaths.addToPythonPath(new LocalPathToTargetPathConverterImpl(targetEnvironmentRequest), root, list);
            }
        }
    }

    private static void addRootsFromModule(@NotNull Module module, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList) {
        CompilerModuleExtension extension;
        if (module == null) {
            TargetedPythonPaths.$$$reportNull$$$0(25);
        }
        if (pythonPathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(26);
        }
        if ((extension = CompilerModuleExtension.getInstance((Module)module)) != null) {
            VirtualFile pathForTests;
            VirtualFile path = extension.getCompilerOutputPath();
            if (path != null) {
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)path.getPath()));
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)pathForTests.getPath()));
            }
        }
    }

    private static void addRoots(@NotNull LocalPathToTargetPathConverter pathConverter, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList, @NotNull @NotNull VirtualFile @NotNull [] roots) {
        if (pathConverter == null) {
            TargetedPythonPaths.$$$reportNull$$$0(27);
        }
        if (pythonPathList == null) {
            TargetedPythonPaths.$$$reportNull$$$0(28);
        }
        if (roots == null) {
            TargetedPythonPaths.$$$reportNull$$$0(29);
        }
        for (VirtualFile root : roots) {
            TargetedPythonPaths.addToPythonPath(pathConverter, root, pythonPathList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 1: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPathList";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathConverter";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/TargetedPythonPaths";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonSdk";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/TargetedPythonPaths";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPythonPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initPythonPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendSystemPythonPath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectPythonPath";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAddedPaths";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addToPythonPath";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeeded";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addLibrariesFromModule";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addRootsFromModule";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LocalPathToTargetPathConverterSdkAware
    implements LocalPathToTargetPathConverter {
        @NotNull
        private final TargetEnvironmentRequest myTargetEnvironmentRequest;
        @NotNull
        private final Project myProject;
        @Nullable
        private final Sdk mySdk;
        @Nullable
        private final PyRemotePathMapper pathMapper;

        private LocalPathToTargetPathConverterSdkAware(@NotNull TargetEnvironmentRequest request, @NotNull Project project, @Nullable Sdk sdk, @Nullable PyRemotePathMapper pathMapper) {
            if (request == null) {
                LocalPathToTargetPathConverterSdkAware.$$$reportNull$$$0(0);
            }
            if (project == null) {
                LocalPathToTargetPathConverterSdkAware.$$$reportNull$$$0(1);
            }
            this.myTargetEnvironmentRequest = request;
            this.myProject = project;
            this.mySdk = sdk;
            this.pathMapper = pathMapper;
        }

        @Override
        @NotNull
        public Function<TargetEnvironment, String> getTargetPath(@NotNull String localPath) {
            if (localPath == null) {
                LocalPathToTargetPathConverterSdkAware.$$$reportNull$$$0(2);
            }
            Function<TargetEnvironment, String> function = PySdkTargetPaths.getTargetPathForPythonConsoleExecution(this.myTargetEnvironmentRequest, this.myProject, this.mySdk, this.pathMapper, localPath);
            if (function == null) {
                LocalPathToTargetPathConverterSdkAware.$$$reportNull$$$0(3);
            }
            return function;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/run/TargetedPythonPaths$LocalPathToTargetPathConverterSdkAware";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/run/TargetedPythonPaths$LocalPathToTargetPathConverterSdkAware";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargetPath";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class LocalPathToTargetPathConverterImpl
    implements LocalPathToTargetPathConverter {
        @NotNull
        private final TargetEnvironmentRequest myTargetEnvironmentRequest;

        private LocalPathToTargetPathConverterImpl(@NotNull TargetEnvironmentRequest request) {
            if (request == null) {
                LocalPathToTargetPathConverterImpl.$$$reportNull$$$0(0);
            }
            this.myTargetEnvironmentRequest = request;
        }

        @Override
        @NotNull
        public Function<TargetEnvironment, String> getTargetPath(@NotNull String localPath) {
            if (localPath == null) {
                LocalPathToTargetPathConverterImpl.$$$reportNull$$$0(1);
            }
            Function function = TargetEnvironmentFunctions.getTargetEnvironmentValueForLocalPath((TargetEnvironmentRequest)this.myTargetEnvironmentRequest, (String)localPath);
            if (function == null) {
                LocalPathToTargetPathConverterImpl.$$$reportNull$$$0(2);
            }
            return function;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/run/TargetedPythonPaths$LocalPathToTargetPathConverterImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/run/TargetedPythonPaths$LocalPathToTargetPathConverterImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargetPath";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    private static interface LocalPathToTargetPathConverter {
        @NotNull
        public Function<TargetEnvironment, String> getTargetPath(@NotNull String var1);
    }
}

