/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.hash.HashFunction;
import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.io.HttpRequests;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.PySdkToInstallCollector;
import com.jetbrains.python.sdk.PySdkToInstallKt;
import com.jetbrains.python.sdk.PySdkToInstallOnWindows;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002/0B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001b0\u001aH\u0002J\u0012\u0010\u001c\u001a\u00020\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u0003H\u0017J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020$H\u0002J(\u0010%\u001a\u0004\u0018\u00010\u00182\b\u0010&\u001a\u0004\u0018\u00010'2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001b0\u001aH\u0016J0\u0010%\u001a\u0004\u0018\u00010\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0016J\"\u0010+\u001a\u00020,2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010+\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows;", "Lcom/jetbrains/python/sdk/PySdkToInstall;", "name", "", "version", "url", "size", "", "hash", "hashFunction", "Lcom/google/common/hash/HashFunction;", "targetFileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Lcom/google/common/hash/HashFunction;Ljava/lang/String;)V", "checkInstallerConsistency", "", "project", "Lcom/intellij/openapi/project/Project;", "installer", "Ljava/io/File;", "downloadInstaller", "targetFile", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findInstalledSdk", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "systemWideSdksDetector", "Lkotlin/Function0;", "", "getInstallationWarning", "defaultButtonName", "handleExecutionException", "e", "Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows$PyInstallationExecutionException;", "handleIOException", "Ljava/io/IOException;", "handleInstallationException", "Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows$PyInstallationException;", "install", "module", "Lcom/intellij/openapi/module/Module;", "renderInList", "renderer", "Lcom/jetbrains/python/sdk/PySdkListCellRenderer;", "runInstaller", "Lcom/intellij/execution/process/ProcessOutput;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "PyInstallationException", "PyInstallationExecutionException", "intellij.python.community.impl"})
final class PySdkToInstallOnWindows
extends PySdkToInstall {
    private final String version;
    private final String url;
    private final long size;
    private final String hash;
    private final HashFunction hashFunction;
    private final String targetFileName;

    @Override
    public void renderInList(@NotNull PySdkListCellRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        renderer.append(this.getName());
        renderer.append(' ' + this.url, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        renderer.setIcon(AllIcons.Actions.Download);
    }

    @Override
    @NlsContexts.DialogMessage
    @NotNull
    public String getInstallationWarning(@NlsContexts.Button @NotNull String defaultButtonName) {
        Intrinsics.checkNotNullParameter((Object)defaultButtonName, (String)"defaultButtonName");
        String string = StringUtil.formatFileSize((long)this.size);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.formatFileSize(size)");
        String fileSize = string;
        String string2 = new HtmlBuilder().append(PyBundle.message("python.sdk.executable.not.found.header", new Object[0])).append((HtmlChunk)HtmlChunk.tag((String)"ul").children(new HtmlChunk[]{(HtmlChunk)HtmlChunk.tag((String)"li").children(new HtmlChunk[]{HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.specify.path", HtmlChunk.text((String)"...").bold()))}), (HtmlChunk)HtmlChunk.tag((String)"li").children(new HtmlChunk[]{HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.download.and.install", HtmlChunk.text((String)defaultButtonName).bold(), fileSize))})})).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"HtmlBuilder()\n      .app\u2026ze)))\n      )).toString()");
        return string2;
    }

    @Override
    @Nullable
    public PyDetectedSdk install(@Nullable Module module, @NotNull Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        Intrinsics.checkNotNullParameter(systemWideSdksDetector, (String)"systemWideSdksDetector");
        try {
            Module module2 = module;
            Project project = module2 != null ? module2.getProject() : null;
            return (PyDetectedSdk)((Object)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<PyDetectedSdk, Exception>(this, project, systemWideSdksDetector, project, PyBundle.message("python.sdk.installing", this.getName()), true){
                final /* synthetic */ PySdkToInstallOnWindows this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ Function0 $systemWideSdksDetector;

                @Nullable
                protected PyDetectedSdk compute(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    return PySdkToInstallOnWindows.access$install(this.this$0, this.$project, this.$systemWideSdksDetector, indicator);
                }
                {
                    this.this$0 = this$0;
                    this.$project = $captured_local_variable$1;
                    this.$systemWideSdksDetector = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                }
            }));
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        catch (PyInstallationExecutionException e) {
            this.handleExecutionException(e);
        }
        catch (PyInstallationException e) {
            this.handleInstallationException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PyDetectedSdk install(Project project, Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector, ProgressIndicator indicator) {
        File targetFile = new File(PathManager.getTempPath(), this.targetFileName);
        try {
            indicator.setText(PyBundle.message("python.sdk.downloading", this.targetFileName));
            if (indicator.isCanceled()) {
                PySdkToInstallCollector.Companion.logSdkDownload$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.CANCELLED);
                PyDetectedSdk pyDetectedSdk = null;
                return pyDetectedSdk;
            }
            this.downloadInstaller(project, targetFile, indicator);
            if (indicator.isCanceled()) {
                PySdkToInstallCollector.Companion.logSdkDownload$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.CANCELLED);
                PyDetectedSdk pyDetectedSdk = null;
                return pyDetectedSdk;
            }
            this.checkInstallerConsistency(project, targetFile);
            PySdkToInstallCollector.Companion.logSdkDownload$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.OK);
            indicator.setText(PyBundle.message("python.sdk.running", this.targetFileName));
            indicator.setText2(PyBundle.message("python.sdk.installing.windows.warning", new Object[0]));
            indicator.setIndeterminate(true);
            if (indicator.isCanceled()) {
                PySdkToInstallCollector.Companion.logSdkInstallation$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.CANCELLED);
                PyDetectedSdk pyDetectedSdk = null;
                return pyDetectedSdk;
            }
            this.runInstaller(project, targetFile, indicator);
            PySdkToInstallCollector.Companion.logSdkInstallation$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.OK);
            PyDetectedSdk pyDetectedSdk = this.findInstalledSdk(project, systemWideSdksDetector);
            return pyDetectedSdk;
        }
        finally {
            FileUtil.delete((File)targetFile);
        }
    }

    private final void downloadInstaller(Project project, File targetFile, ProgressIndicator indicator) {
        PySdkToInstallKt.access$getLOGGER$p().info("Downloading " + this.url + " to " + targetFile);
        try {
            HttpRequests.request((String)this.url).saveToFile(targetFile, indicator);
            Unit unit = Unit.INSTANCE;
        }
        catch (IOException e) {
            PySdkToInstallCollector.Companion.logSdkDownload$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.EXCEPTION);
            throw (Throwable)new IOException("Failed to download " + this.url + " to " + targetFile + '.', e);
        }
        catch (ProcessCanceledException e) {
            PySdkToInstallCollector.Companion.logSdkDownload$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.CANCELLED);
            throw (Throwable)e;
        }
    }

    private final void checkInstallerConsistency(Project project, File installer) {
        PySdkToInstallKt.access$getLOGGER$p().debug("Checking installer size");
        long sizeDiff = installer.length() - this.size;
        if (sizeDiff != 0L) {
            PySdkToInstallCollector.Companion.logSdkDownload$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.SIZE);
            long l = sizeDiff;
            boolean bl = false;
            throw (Throwable)new IOException("Downloaded " + installer + " has incorrect size, difference is " + Math.abs(l) + " bytes.");
        }
        PySdkToInstallKt.access$getLOGGER$p().debug("Checking installer checksum");
        String string = Files.asByteSource((File)installer).hash(this.hashFunction).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Files.asByteSource(insta\u2026(hashFunction).toString()");
        String actualHashCode = string;
        if (!StringsKt.equals((String)actualHashCode, (String)this.hash, (boolean)true)) {
            PySdkToInstallCollector.Companion.logSdkDownload$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.CHECKSUM);
            throw (Throwable)new IOException("Checksums for " + installer + " does not match. Actual value is " + actualHashCode + ", expected " + this.hash + '.');
        }
    }

    private final void handleIOException(IOException e) {
        block0: {
            PySdkToInstallKt.access$getLOGGER$p().info((Throwable)e);
            String string = e.getMessage();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Throwable throwable = e.getCause();
            PackagesNotificationPanel.showError((String)PyBundle.message("python.sdk.failed.to.install.title", this.getName()), (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(it, null, throwable != null ? throwable.getMessage() : null, PyBundle.message("python.sdk.try.to.install.python.manually", new Object[0])));
        }
    }

    private final void runInstaller(Project project, File installer, ProgressIndicator indicator) {
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{installer.getAbsolutePath(), "/quiet"});
        PySdkToInstallKt.access$getLOGGER$p().info("Running " + commandLine.getCommandLineString());
        ProcessOutput output = this.runInstaller(project, commandLine, indicator);
        if (output.isCancelled()) {
            PySdkToInstallCollector.Companion.logSdkInstallation$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.CANCELLED);
        }
        if (output.getExitCode() != 0) {
            PySdkToInstallCollector.Companion.logSdkInstallation$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.EXIT_CODE);
        }
        if (output.isTimeout()) {
            PySdkToInstallCollector.Companion.logSdkInstallation$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.TIMEOUT);
        }
        if (output.getExitCode() != 0 || output.isTimeout()) {
            throw (Throwable)new PyInstallationException(commandLine, output);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInstallationException(PyInstallationException e) {
        ProcessOutput processOutput = e.getOutput();
        processOutput.checkSuccess(PySdkToInstallKt.access$getLOGGER$p());
        if (processOutput.isCancelled()) {
            Object v1;
            String string;
            String string2;
            String string3;
            block4: {
                void $this$firstOrNull$iv;
                Iterable iterable = CollectionsKt.listOf((Object[])new String[]{processOutput.getStderr(), processOutput.getStdout()});
                string3 = e.getCommandLine().getCommandLineString();
                string2 = PyBundle.message("python.sdk.some.installed.python.components.might.get.inconsistent.after.cancellation", new Object[0]);
                string = PyBundle.message("python.sdk.installation.has.been.cancelled.title", this.getName());
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    String string4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
                    CharSequence charSequence = string4;
                    boolean bl2 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            Object var16_25 = v1;
            String string5 = PyBundle.message("python.sdk.consider.installing.python.manually", new Object[0]);
            String string6 = var16_25;
            String string7 = string3;
            String string8 = string2;
            PackagesNotificationPanel.showError((String)string, (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(string8, string7, string6, string5));
        } else {
            Object v3;
            String string;
            String string9;
            String string10;
            block5: {
                Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])new String[]{processOutput.getStderr(), processOutput.getStdout()});
                string10 = e.getCommandLine().getCommandLineString();
                string9 = processOutput.isTimeout() ? PyBundle.message("python.sdk.failed.to.install.timed.out", new Object[0]) : PyBundle.message("python.sdk.failed.to.install.exit.code", processOutput.getExitCode());
                string = PyBundle.message("python.sdk.failed.to.install.title", this.getName());
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    String string11 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"it");
                    CharSequence charSequence = string11;
                    boolean bl3 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            Object var16_26 = v3;
            String string12 = PyBundle.message("python.sdk.try.to.install.python.manually", new Object[0]);
            String string13 = var16_26;
            String string14 = string10;
            String string15 = string9;
            PackagesNotificationPanel.showError((String)string, (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(string15, string14, string13, string12));
        }
    }

    private final ProcessOutput runInstaller(Project project, GeneralCommandLine commandLine, ProgressIndicator indicator) {
        try {
            ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcessWithProgressIndicator(indicator);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(\u2026gressIndicator(indicator)");
            return processOutput;
        }
        catch (ExecutionException e) {
            PySdkToInstallCollector.Companion.logSdkInstallation$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.EXCEPTION);
            throw (Throwable)new PyInstallationExecutionException(commandLine, e);
        }
    }

    private final void handleExecutionException(PyInstallationExecutionException e) {
        block0: {
            PySdkToInstallKt.access$getLOGGER$p().info((Throwable)e);
            String string = e.getCause().getMessage();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            PackagesNotificationPanel.showError((String)PyBundle.message("python.sdk.failed.to.install.title", this.getName()), (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(it, e.getCommandLine().getCommandLineString(), null, PyBundle.message("python.sdk.try.to.install.python.manually", new Object[0])));
        }
    }

    private final PyDetectedSdk findInstalledSdk(Project project, Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        PySdkToInstallKt.access$getLOGGER$p().debug("Resetting system-wide sdks detectors");
        PySdkExtKt.resetSystemWideSdksDetectors();
        Object object = systemWideSdksDetector.invoke();
        boolean bl = false;
        boolean bl2 = false;
        List sdks = (List)object;
        boolean bl3 = false;
        Logger $this$debug$iv = PySdkToInstallKt.access$getLOGGER$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl4 = false;
            String string = CollectionsKt.joinToString$default((Iterable)sdks, null, (CharSequence)"Detected system-wide sdks: ", null, (int)0, null, (Function1)findInstalledSdk.1.1.1.INSTANCE, (int)29, null);
            logger.debug(string, (Throwable)e$iv);
        }
        bl = false;
        bl2 = false;
        List it = (List)object;
        boolean bl5 = false;
        PySdkToInstallCollector.Companion.logSdkLookup$intellij_python_community_impl(project, this.version, it.isEmpty() ? PySdkToInstallCollector.Companion.LookupResult.NOT_FOUND : PySdkToInstallCollector.Companion.LookupResult.FOUND);
        return (PyDetectedSdk)((Object)CollectionsKt.singleOrNull((List)((List)object)));
    }

    public PySdkToInstallOnWindows(@NotNull String name, @NotNull String version, @NotNull String url, long size, @NotNull String hash, @NotNull HashFunction hashFunction, @NotNull String targetFileName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)hashFunction, (String)"hashFunction");
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        super(name, version);
        this.version = version;
        this.url = url;
        this.size = size;
        this.hash = hash;
        this.hashFunction = hashFunction;
        this.targetFileName = targetFileName;
    }

    public static final /* synthetic */ PyDetectedSdk access$install(PySdkToInstallOnWindows $this, Project project, Function0 systemWideSdksDetector, ProgressIndicator indicator) {
        return $this.install(project, (Function0<? extends List<? extends PyDetectedSdk>>)systemWideSdksDetector, indicator);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows$PyInstallationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "output", "Lcom/intellij/execution/process/ProcessOutput;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/execution/process/ProcessOutput;)V", "getCommandLine", "()Lcom/intellij/execution/configurations/GeneralCommandLine;", "getOutput", "()Lcom/intellij/execution/process/ProcessOutput;", "intellij.python.community.impl"})
    private static final class PyInstallationException
    extends Exception {
        @NotNull
        private final GeneralCommandLine commandLine;
        @NotNull
        private final ProcessOutput output;

        @NotNull
        public final GeneralCommandLine getCommandLine() {
            return this.commandLine;
        }

        @NotNull
        public final ProcessOutput getOutput() {
            return this.output;
        }

        public PyInstallationException(@NotNull GeneralCommandLine commandLine, @NotNull ProcessOutput output) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            this.commandLine = commandLine;
            this.output = output;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows$PyInstallationExecutionException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "cause", "Lcom/intellij/execution/ExecutionException;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/execution/ExecutionException;)V", "getCause", "()Lcom/intellij/execution/ExecutionException;", "getCommandLine", "()Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.python.community.impl"})
    private static final class PyInstallationExecutionException
    extends Exception {
        @NotNull
        private final GeneralCommandLine commandLine;
        @NotNull
        private final ExecutionException cause;

        @NotNull
        public final GeneralCommandLine getCommandLine() {
            return this.commandLine;
        }

        @Override
        @NotNull
        public ExecutionException getCause() {
            return this.cause;
        }

        public PyInstallationExecutionException(@NotNull GeneralCommandLine commandLine, @NotNull ExecutionException cause) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
            this.commandLine = commandLine;
            this.cause = cause;
        }
    }
}

