/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u001a\u001e\u0010\u0007\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u001a<\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0005H\u0002\u001a>\u0010\r\u001a\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0005H\u0002\u001a\"\u0010\u0010\u001a\u00020\u0011*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0002\u00a8\u0006\u0012"}, d2={"findCondaExecutable", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "readCondaEnv", "", "condaExecutable", "runCondaOnTarget", "Lcom/intellij/execution/process/ProcessOutput;", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "arguments", "", "runOnTarget", "executable", "env", "checkExitCode", "", "intellij.python.community.impl"})
public final class PyCondaRunTargetsKt {
    @NotNull
    public static final ProcessOutput runCondaOnTarget(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull String condaExecutable, @NotNull List<String> arguments) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)targetEnvironmentRequest, (String)"targetEnvironmentRequest");
        Intrinsics.checkNotNullParameter((Object)condaExecutable, (String)"condaExecutable");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return PyCondaRunTargetsKt.runOnTarget(targetEnvironmentRequest, condaExecutable, arguments, PyCondaRunTargetsKt.readCondaEnv(condaExecutable));
    }

    @NotNull
    public static final ProcessOutput runCondaOnTarget(@Nullable Sdk sdk, @NotNull List<String> arguments) throws ExecutionException {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String condaExecutable = PyCondaRunTargetsKt.findCondaExecutable(sdk);
        Map<String, String> environment = sdk != null ? PySdkUtil.activateVirtualEnv(sdk) : PyCondaRunTargetsKt.readCondaEnv(condaExecutable);
        return PyCondaRunTargetsKt.runOnTarget(sdk, condaExecutable, arguments, environment);
    }

    private static final ProcessOutput runOnTarget(Sdk sdk, String executable, List<String> arguments, Map<String, String> env) {
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = PythonCommandLineState.getPythonTargetInterpreter(projectManager.getDefaultProject(), sdk);
        Intrinsics.checkNotNullExpressionValue((Object)helpersAwareTargetEnvironmentRequest, (String)"PythonCommandLineState.g\u2026ce().defaultProject, sdk)");
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest = helpersAwareTargetEnvironmentRequest;
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
        return PyCondaRunTargetsKt.runOnTarget(targetEnvironmentRequest, executable, arguments, env);
    }

    /*
     * WARNING - void declaration
     */
    private static final ProcessOutput runOnTarget(TargetEnvironmentRequest targetEnvironmentRequest, String executable, List<String> arguments, Map<String, String> env) {
        TargetProgressIndicator targetProgressIndicator;
        TargetProgressIndicator targetProgressIndicator2 = targetProgressIndicator = TargetProgressIndicator.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)targetProgressIndicator2, (String)"targetProgressIndicator");
        TargetEnvironment targetEnvironment = targetEnvironmentRequest.prepareEnvironment(targetProgressIndicator2);
        TargetedCommandLineBuilder targetedCommandLineBuilder = new TargetedCommandLineBuilder(targetEnvironmentRequest);
        boolean bl = false;
        boolean bl2 = false;
        TargetedCommandLineBuilder $this$apply = targetedCommandLineBuilder;
        boolean bl3 = false;
        $this$apply.setExePath(executable);
        $this$apply.addParameters(arguments);
        Map<String, String> map2 = env;
        if (map2 != null) {
            Map<String, String> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Map<String, String> map3 = $this$forEach$iv;
            boolean bl4 = false;
            Iterator<Map.Entry<String, String>> iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry<String, String> entry = $dstr$key$value;
                boolean bl6 = false;
                String string = entry.getKey();
                entry = $dstr$key$value;
                bl6 = false;
                String value = entry.getValue();
                $this$apply.addEnvironmentVariable((String)key, value);
            }
        }
        TargetedCommandLineBuilder targetedCommandLineBuilder2 = targetedCommandLineBuilder;
        TargetedCommandLine targetedCommandLine = targetedCommandLineBuilder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLine, (String)"targetedCommandLineBuilder.build()");
        TargetedCommandLine targetedCommandLine2 = targetedCommandLine;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        Process process2 = targetEnvironment.createProcess(targetedCommandLine2, indicator);
        String commandPresentation = targetedCommandLine2.getCommandPresentation(targetEnvironment);
        CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(process2, Charsets.UTF_8, commandPresentation);
        boolean bl7 = false;
        boolean bl8 = false;
        CapturingProcessHandler $this$apply2 = capturingProcessHandler;
        boolean bl9 = false;
        $this$apply2.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
        CapturingProcessHandler handler = capturingProcessHandler;
        ProcessOutput processOutput = handler.runProcessWithProgressIndicator(indicator);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"handler.runProcessWithProgressIndicator(indicator)");
        capturingProcessHandler = processOutput;
        bl7 = false;
        bl8 = false;
        $this$apply2 = capturingProcessHandler;
        boolean bl10 = false;
        if ($this$apply2.isCancelled()) {
            throw (Throwable)new RunCanceledByUserException();
        }
        PyCondaRunTargetsKt.checkExitCode((ProcessOutput)$this$apply2, executable, arguments);
        return capturingProcessHandler;
    }

    private static final Map<String, String> readCondaEnv(String condaExecutable) {
        Map<String, String> map2;
        String string = PyCondaPackageService.getCondaBasePython(condaExecutable);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            map2 = PySdkUtil.activateVirtualEnv(it);
        } else {
            map2 = null;
        }
        return map2;
    }

    private static final String findCondaExecutable(Sdk sdk) throws ExecutionException {
        Sdk sdk2 = sdk;
        if ((sdk2 != null ? sdk2.getSdkAdditionalData() : null) instanceof PyTargetAwareAdditionalData) {
            return "/root/anaconda3";
        }
        Sdk sdk3 = sdk;
        String string = PyCondaPackageService.getCondaExecutable(sdk3 != null ? sdk3.getHomePath() : null);
        if (string == null) {
            throw (Throwable)new ExecutionException(PySdkBundle.message("python.sdk.flavor.cannot.find.conda", new Object[0]));
        }
        return string;
    }

    private static final void checkExitCode(ProcessOutput $this$checkExitCode, String executable, List<String> arguments) throws PyExecutionException {
        if ($this$checkExitCode.getExitCode() != 0) {
            String string = StringUtil.isEmptyOrSpaces((String)$this$checkExitCode.getStdout()) && StringUtil.isEmptyOrSpaces((String)$this$checkExitCode.getStderr()) ? PySdkBundle.message("python.conda.permission.denied", new Object[0]) : PySdkBundle.message("python.conda.non.zero.exit.code", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (StringUtil.isEmptyOr\u2026onda.non.zero.exit.code\")");
            String message = string;
            throw (Throwable)((Object)new PyExecutionException(message, executable, arguments, $this$checkExitCode));
        }
    }
}

