/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PoetryOutdatedVersion;
import com.jetbrains.python.sdk.poetry.PyPoetryPackageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "PoetryFileVisitor", "intellij.python.community.impl"})
public final class PoetryPackageVersionsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new PoetryFileVisitor(holder, session);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/sdk/poetry/PoetryPackageVersionsInspection$PoetryFileVisitor;", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "guessModule", "Lcom/intellij/openapi/module/Module;", "element", "Lcom/intellij/psi/PsiElement;", "visitFile", "", "file", "Lcom/intellij/psi/PsiFile;", "intellij.python.community.impl"})
    public static final class PoetryFileVisitor
    extends PsiElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        private final Module guessModule(PsiElement element) {
            Object object = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (object == null) {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)element.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(element.project)");
                Module[] moduleArray = moduleManager.getModules();
                boolean bl = false;
                boolean bl2 = false;
                Module[] it = moduleArray;
                boolean bl3 = false;
                object = it.length != 1 ? null : it[0];
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        public void visitFile(@NotNull PsiFile file) {
            void $this$forEach$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Module module = this.guessModule((PsiElement)file);
            if (module == null) {
                return;
            }
            Module module2 = module;
            Sdk sdk = PythonSdkUtil.findPythonSdk(module2);
            if (sdk == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"PythonSdkUtil.findPythonSdk(module) ?: return");
            Sdk sdk2 = sdk;
            if (!PoetryKt.isPoetry(sdk2)) {
                return;
            }
            if (Intrinsics.areEqual((Object)file.getVirtualFile(), (Object)PoetryKt.getPyProjectToml(module2)) ^ true) {
                return;
            }
            PsiElement[] psiElementArray = file.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"file.children");
            PsiElement[] psiElementArray2 = psiElementArray;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv;
            int n = ((void)iterator2).length;
            for (int i = 0; i < n; ++i) {
                TomlTable tomlTable;
                void element$iv$iv;
                void element = element$iv$iv = iterator2[i];
                boolean bl = false;
                Iterable iterable = CollectionsKt.listOf((Object[])new String[]{"tool.poetry.dependencies", "tool.poetry.dev-dependencies"});
                Object v4 = element;
                if (!(v4 instanceof TomlTable)) {
                    v4 = null;
                }
                if (!CollectionsKt.contains((Iterable)iterable, (tomlTable = (TomlTable)v4) != null && (tomlTable = tomlTable.getHeader()) != null && (tomlTable = tomlTable.getKey()) != null ? tomlTable.getText() : null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                PsiElement[] $this$mapNotNull$iv;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl = false;
                PsiElement psiElement = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)psiElement.getChildren(), (String)"it.children");
                boolean $i$f$mapNotNull = false;
                PsiElement[] psiElementArray3 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                void var20_32 = $this$forEach$iv$iv$iv;
                int n2 = ((void)var20_32).length;
                for (int i = 0; i < n2; ++i) {
                    TomlKeyValue tomlKeyValue;
                    void element$iv$iv$iv;
                    void element$iv$iv2 = element$iv$iv$iv = var20_32[i];
                    boolean bl2 = false;
                    void line2 = element$iv$iv2;
                    boolean bl3 = false;
                    Object v7 = line2;
                    if (!(v7 instanceof TomlKeyValue)) {
                        v7 = null;
                    }
                    if ((TomlKeyValue)v7 == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    TomlKeyValue it$iv$iv = tomlKeyValue;
                    boolean bl6 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PoetryOutdatedVersion outdatedVersion;
                PoetryOutdatedVersion poetryOutdatedVersion;
                TomlKeyValue keyValue = (TomlKeyValue)element$iv;
                boolean bl = false;
                String packageName = keyValue.getKey().getText();
                PyPackageManager pyPackageManager = PyPackageManager.getInstance(sdk2);
                if (!(pyPackageManager instanceof PyPoetryPackageManager)) {
                    pyPackageManager = null;
                }
                if ((PyPoetryPackageManager)pyPackageManager != null) {
                    PyPoetryPackageManager list$iv$iv;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    PyPoetryPackageManager it = list$iv$iv;
                    boolean bl9 = false;
                    poetryOutdatedVersion = it.getOutdatedPackages().get(packageName);
                } else {
                    poetryOutdatedVersion = null;
                }
                if (!((outdatedVersion = poetryOutdatedVersion) instanceof PoetryOutdatedVersion)) continue;
                String message = '\'' + packageName + "' version " + outdatedVersion.getCurrentVersion() + " is outdated (latest: " + outdatedVersion.getLatestVersion() + ')';
                this.holder.registerProblem((PsiElement)keyValue, message, ProblemHighlightType.WARNING, new LocalQuickFix[0]);
            }
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        public PoetryFileVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.holder = holder;
        }
    }
}

