/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PoetryOutdatedVersion;
import com.jetbrains.python.sdk.poetry.PyPoetryPackageManager;
import com.jetbrains.python.sdk.poetry.PyPoetryPackageManager$refresh$;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006H\u0016J\u0018\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0016J&\u0010 \u001a\u00020!2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00062\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010$\u001a\u00020!H\u0016J(\u0010%\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00060&2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020\u0007H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010+\u001a\u00020,H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010-\u001a\u00020\u0007H\u0016J\b\u0010.\u001a\u00020!H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u00100\u001a\u00020\u0014H\u0016J\u0016\u00101\u001a\u00020!2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00062"}, d2={"Lcom/jetbrains/python/sdk/poetry/PyPoetryPackageManager;", "Lcom/jetbrains/python/packaging/PyPackageManager;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "installedLines", "", "", "outdatedPackages", "", "Lcom/jetbrains/python/sdk/poetry/PoetryOutdatedVersion;", "packages", "Lcom/jetbrains/python/packaging/PyPackage;", "requirements", "Lcom/jetbrains/python/packaging/PyRequirement;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "createVirtualEnv", "destinationDir", "useGlobalSite", "", "getDependents", "", "pkg", "getOutdatedPackages", "getPackages", "getRequirements", "module", "Lcom/intellij/openapi/module/Module;", "getVersion", "version", "hasManagement", "install", "", "requirementString", "extraArgs", "installManagement", "parsePoetryInstallDryRun", "Lkotlin/Pair;", "input", "parseRequirement", "line", "parseRequirements", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "refresh", "refreshAndGetPackages", "alwaysRefresh", "uninstall", "intellij.python.community.impl"})
public final class PyPoetryPackageManager
extends PyPackageManager {
    private final List<String> installedLines;
    private volatile List<PyPackage> packages;
    private List<? extends PyRequirement> requirements;
    private Map<String, PoetryOutdatedVersion> outdatedPackages;
    @NotNull
    private final Sdk sdk;

    @Override
    public void installManagement() {
    }

    @Override
    public boolean hasManagement() {
        return true;
    }

    @Override
    public void install(@NotNull String requirementString) {
        Intrinsics.checkNotNullParameter((Object)requirementString, (String)"requirementString");
        this.install((List<? extends PyRequirement>)this.parseRequirements(requirementString), (List<String>)CollectionsKt.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void install(@Nullable List<? extends PyRequirement> requirements2, @NotNull List<String> extraArgs) {
        List list;
        Intrinsics.checkNotNullParameter(extraArgs, (String)"extraArgs");
        if (requirements2 == null || requirements2.isEmpty()) {
            list = CollectionsKt.flatten((Iterable)CollectionsKt.listOfNotNull((Object[])new List[]{CollectionsKt.listOf((Object)"install"), extraArgs}));
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = new List[3];
            objectArray[0] = CollectionsKt.listOf((Object)"add");
            Iterable iterable = requirements2;
            int n = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyRequirement pyRequirement = (PyRequirement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            objectArray3[2] = extraArgs;
            list = CollectionsKt.flatten((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray3));
        }
        List args2 = list;
        try {
            Collection $this$toTypedArray$iv = args2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PoetryKt.runPoetry(this.sdk, Arrays.copyOf(stringArray, stringArray.length));
        }
        finally {
            VirtualFile virtualFile = PySdkExtKt.getAssociatedModuleDir(this.sdk);
            if (virtualFile != null) {
                virtualFile.refresh(true, false);
            }
            this.refreshAndGetPackages(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void uninstall(@NotNull List<PyPackage> packages) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        Iterable iterable = packages;
        Collection collection2 = CollectionsKt.listOf((Object)"remove");
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            PyPackage pyPackage = (PyPackage)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"it.name");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        List args2 = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        try {
            Collection $this$toTypedArray$iv = args2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            PoetryKt.runPoetry(this.sdk, Arrays.copyOf(stringArray, stringArray.length));
        }
        finally {
            VirtualFile virtualFile = PySdkExtKt.getAssociatedModuleDir(this.sdk);
            if (virtualFile != null) {
                virtualFile.refresh(true, false);
            }
            this.refreshAndGetPackages(true);
        }
    }

    @Override
    public void refresh() {
        Application application = ApplicationManager.getApplication();
        boolean bl = false;
        boolean bl2 = false;
        Application $this$with = application;
        boolean bl3 = false;
        $this$with.invokeLater(new Runnable($this$with, this){
            final /* synthetic */ Application $this_with;
            final /* synthetic */ PyPoetryPackageManager this$0;
            {
                this.$this_with = application;
                this.this$0 = pyPoetryPackageManager;
            }

            public final void run() {
                this.$this_with.runWriteAction(new Runnable(this){
                    final /* synthetic */ refresh$$inlined$with$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void run() {
                        VirtualFile[] files = this.this$0.this$0.getSdk().getRootProvider().getFiles(OrderRootType.CLASSES);
                        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])Arrays.copyOf(files, files.length));
                    }
                });
                PythonSdkType.getInstance().setupSdkPaths(this.this$0.getSdk());
            }
        });
    }

    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        throw (Throwable)new ExecutionException("Creating virtual environments based on Poetry environments is not supported");
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        return this.packages;
    }

    @NotNull
    public final Map<String, PoetryOutdatedVersion> getOutdatedPackages() {
        return this.outdatedPackages;
    }

    @Override
    @NotNull
    public List<PyPackage> refreshAndGetPackages(boolean alwaysRefresh) {
        List list;
        if (alwaysRefresh || this.packages == null) {
            Object object;
            String string;
            this.packages = null;
            try {
                string = PoetryKt.runPoetry(this.sdk, "install", "--dry-run", "--no-root");
            }
            catch (ExecutionException e) {
                this.packages = CollectionsKt.emptyList();
                List list2 = this.packages;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                return list2;
            }
            String outputInstallDryRun = string;
            Pair<List<PyPackage>, List<PyRequirement>> allPackage = this.parsePoetryInstallDryRun(outputInstallDryRun);
            this.packages = (List)allPackage.getFirst();
            this.requirements = (List)allPackage.getSecond();
            try {
                object = PoetryKt.runPoetry(this.sdk, "show", "--outdated");
            }
            catch (ExecutionException e) {
                this.outdatedPackages = MapsKt.emptyMap();
                object = Unit.INSTANCE;
            }
            Unit outputOutdatedPackages = object;
            if (outputOutdatedPackages instanceof String) {
                this.outdatedPackages = PoetryKt.parsePoetryShowOutdated((String)outputOutdatedPackages);
            }
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ((PyPackageManager.Listener)application.getMessageBus().syncPublisher(PyPackageManager.PACKAGE_MANAGER_TOPIC)).packagesRefreshed(this.sdk);
        }
        if ((list = this.packages) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.requirements;
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<PyRequirement> list = PyRequirementParser.fromText(text2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"PyRequirementParser.fromText(text)");
        return list;
    }

    @Override
    @Nullable
    public PyRequirement parseRequirement(@NotNull String line2) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        return PyRequirementParser.fromLine(line2);
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<PyRequirement> list = PyRequirementParser.fromFile(file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"PyRequirementParser.fromFile(file)");
        return list;
    }

    @Override
    @NotNull
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) {
        Intrinsics.checkNotNullParameter((Object)((Object)pkg), (String)"pkg");
        return SetsKt.emptySet();
    }

    private final String getVersion(String version) {
        return new Regex("^[0-9]").containsMatchIn((CharSequence)version) ? "==" + version : version;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<PyPackage>, List<PyRequirement>> parsePoetryInstallDryRun(String input) {
        void $this$forEach$iv;
        parsePoetryInstallDryRun.1 $fun$getNameAndVersion$1 = parsePoetryInstallDryRun.1.INSTANCE;
        boolean bl = false;
        List pyPackages = new ArrayList();
        boolean bl2 = false;
        List pyRequirements = new ArrayList();
        Sequence sequence = SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)input), (Function1)parsePoetryInstallDryRun.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyRequirement pyRequirement;
            PyRequirement pyRequirement2;
            boolean bl3;
            boolean bl4;
            Triple<String, String, String> it;
            String line2;
            block6: {
                line2 = (String)element$iv;
                boolean bl5 = false;
                Triple<String, String, String> triple = parsePoetryInstallDryRun.1.INSTANCE.invoke(line2);
                boolean bl6 = false;
                boolean bl7 = false;
                it = triple;
                boolean bl8 = false;
                Iterable $this$any$iv = this.installedLines;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String installedLine = (String)element$iv2;
                        boolean bl9 = false;
                        if (!StringsKt.contains$default((CharSequence)line2, (CharSequence)installedLine, (boolean)false, (int)2, null)) continue;
                        bl4 = true;
                        break block6;
                    }
                    bl4 = false;
                }
            }
            if (bl4) {
                pyPackages.add(new PyPackage((String)it.getFirst(), (String)it.getSecond(), null, CollectionsKt.emptyList()));
                if (this.parseRequirement((String)it.getFirst() + this.getVersion((String)it.getThird())) != null) {
                    bl3 = false;
                    boolean bl10 = false;
                    pyRequirement = pyRequirement2;
                    boolean bl11 = false;
                    pyRequirements.add(pyRequirement);
                }
                continue;
            }
            if (!StringsKt.contains$default((CharSequence)line2, (CharSequence)"Installing", (boolean)false, (int)2, null)) continue;
            if (this.parseRequirement((String)it.getFirst() + this.getVersion((String)it.getThird())) == null) continue;
            bl3 = false;
            boolean bl12 = false;
            pyRequirement = pyRequirement2;
            boolean bl13 = false;
            pyRequirements.add(pyRequirement);
        }
        return new Pair((Object)CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)pyPackages)), (Object)CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)pyRequirements)));
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    public PyPoetryPackageManager(@NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        this.sdk = sdk;
        this.installedLines = CollectionsKt.listOf((Object[])new String[]{"Already installed", "Skipping", "Updating"});
        this.outdatedPackages = MapsKt.emptyMap();
        PyPackageUtil.runOnChangeUnderInterpreterPaths(this.sdk, this, new Runnable(){

            @Override
            public final void run() {
                PythonSdkType.getInstance().setupSdkPaths(this.getSdk());
            }
        });
    }
}

