/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.imports.OptimizeImportsQuickFix;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.inspections.PyPep8Inspection;
import com.jetbrains.python.inspections.flake8.Flake8InspectionSuppressor;
import com.jetbrains.python.inspections.quickfix.PyFillParagraphFix;
import com.jetbrains.python.inspections.quickfix.ReformatFix;
import com.jetbrains.python.inspections.quickfix.RemoveTrailingBlankLinesFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKeywordPattern;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.validation.Pep8ProblemSuppressor;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pep8ExternalAnnotator
extends ExternalAnnotator<State, Results> {
    private static final String DEFAULT_IGNORED_ERRORS = "E121,E123,E126,E226,E24,E704,W503,W504";
    private static final Logger LOG = Logger.getInstance(Pep8ExternalAnnotator.class);
    private static final Pattern E303_LINE_COUNT_PATTERN = Pattern.compile(".*\\((\\d+)\\)$");
    private boolean myReportedMissingInterpreter;
    private static final Pattern PROBLEM_PATTERN = Pattern.compile(".+:(\\d+):(\\d+): ([EW]\\d{3}) (.+)");

    public String getPairedBatchInspectionShortName() {
        return "PyPep8Inspection";
    }

    @Nullable
    public State collectInformation(@NotNull PsiFile file) {
        HighlightDisplayKey key;
        VirtualFile vFile;
        if (file == null) {
            Pep8ExternalAnnotator.$$$reportNull$$$0(0);
        }
        if ((vFile = file.getVirtualFile()) == null || vFile.getFileType() != PythonFileType.INSTANCE) {
            return null;
        }
        Sdk sdk = PythonSdkType.findLocalCPython(ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
        if (sdk == null) {
            if (!this.myReportedMissingInterpreter) {
                this.myReportedMissingInterpreter = true;
                Pep8ExternalAnnotator.reportMissingInterpreter();
            }
            return null;
        }
        String homePath2 = sdk.getHomePath();
        if (homePath2 == null) {
            if (!this.myReportedMissingInterpreter) {
                this.myReportedMissingInterpreter = true;
                LOG.info("Could not find home path for interpreter " + homePath2);
            }
            return null;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        if (!profile.isToolEnabled(key = HighlightDisplayKey.find((String)"PyPep8Inspection"), (PsiElement)file)) {
            return null;
        }
        if (file instanceof PyFileImpl && !((PyFileImpl)file).isAcceptedFor(PyPep8Inspection.class)) {
            return null;
        }
        PyPep8Inspection inspection = (PyPep8Inspection)profile.getUnwrappedTool("PyPep8Inspection", (PsiElement)file);
        CodeStyleSettings commonSettings = CodeStyle.getSettings((PsiFile)file);
        PyCodeStyleSettings customSettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PyCodeStyleSettings.class);
        ArrayList ignoredErrors = Lists.newArrayList(inspection.ignoredErrors);
        if (!customSettings.SPACE_AFTER_NUMBER_SIGN) {
            ignoredErrors.add("E262");
            ignoredErrors.add("E265");
        }
        if (!customSettings.SPACE_BEFORE_NUMBER_SIGN) {
            ignoredErrors.add("E261");
        }
        return new State(homePath2, file.getText(), profile.getErrorLevel(key, (PsiElement)file), ignoredErrors, commonSettings.getRightMargin((Language)PythonLanguage.getInstance()), customSettings.HANG_CLOSING_BRACKETS);
    }

    private static void reportMissingInterpreter() {
        LOG.info("Found no suitable interpreter to run pycodestyle.py. Available interpreters are: [");
        List<Sdk> allSdks = PythonSdkUtil.getAllSdks();
        allSdks.sort(PreferredSdkComparator.INSTANCE);
        for (Sdk sdk : allSdks) {
            LOG.info("  Path: " + sdk.getHomePath() + "; Flavor: " + PythonSdkFlavor.getFlavor(sdk) + "; Remote: " + PythonSdkUtil.isRemote(sdk));
        }
        LOG.info("]");
    }

    @Nullable
    public Results doAnnotate(State collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        ArrayList<String> options = new ArrayList<String>();
        if (!collectedInfo.ignoredErrors.isEmpty()) {
            options.add("--ignore=E121,E123,E126,E226,E24,E704,W503,W504," + StringUtil.join(collectedInfo.ignoredErrors, (String)","));
        }
        if (collectedInfo.hangClosingBrackets) {
            options.add("--hang-closing");
        }
        options.add("--max-line-length=" + collectedInfo.margin);
        options.add("-");
        GeneralCommandLine cmd = PythonHelper.PYCODESTYLE.newCommandLine(collectedInfo.interpreterPath, options);
        ProcessOutput output = PySdkUtil.getProcessOutput(cmd, new File(collectedInfo.interpreterPath).getParent(), (Map<String, String>)ImmutableMap.of((Object)"PYTHONBUFFERED", (Object)"1"), 10000, collectedInfo.fileText.getBytes(StandardCharsets.UTF_8), false);
        Results results = new Results(collectedInfo.level);
        if (output.isTimeout()) {
            LOG.info("Timeout running pycodestyle.py");
            return results;
        }
        if (!output.getStderr().isEmpty() && ((ApplicationInfoImpl)ApplicationInfo.getInstance()).isEAP()) {
            LOG.info("Error running pycodestyle.py: " + output.getStderr());
        }
        for (String line2 : output.getStdoutLines()) {
            ContainerUtil.addIfNotNull(results.problems, (Object)Pep8ExternalAnnotator.parseProblem(line2));
        }
        return results;
    }

    public void apply(@NotNull PsiFile file, Results annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            Pep8ExternalAnnotator.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            Pep8ExternalAnnotator.$$$reportNull$$$0(2);
        }
        if (annotationResult == null || !file.isValid()) {
            return;
        }
        String text2 = file.getText();
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        for (Problem problem : annotationResult.problems) {
            boolean universal;
            HighPriorityAction fix;
            PsiElement elementBefore;
            int line2 = problem.myLine - 1;
            int column = problem.myColumn - 1;
            int offset = document != null ? (line2 >= document.getLineCount() ? document.getTextLength() - 1 : document.getLineStartOffset(line2) + column) : StringUtil.lineColToOffset((CharSequence)text2, (int)line2, (int)column);
            PsiElement problemElement = file.findElementAt(offset);
            if (!(problemElement instanceof PsiWhiteSpace) && problem.myCode.startsWith("E3") && (elementBefore = file.findElementAt(Math.max(0, offset - 1))) instanceof PsiWhiteSpace) {
                problemElement = elementBefore;
            }
            if (problemElement == null && document != null && offset == document.getTextLength() && problem.myCode.equals("W292")) {
                problemElement = file.findElementAt(Math.max(0, offset - 1));
            }
            if (Pep8ExternalAnnotator.ignoreDueToSettings(file, problem, problemElement) || Pep8ExternalAnnotator.ignoredDueToProblemSuppressors(problem, file, problemElement) || Pep8ExternalAnnotator.ignoredDueToNoqaComment(problem, file, document) || problemElement == null) continue;
            TextRange problemRange = problemElement.getTextRange();
            if (Pep8ExternalAnnotator.crossesLineBoundary(document, text2, problemRange)) {
                int lineEndOffset = document != null ? (line2 >= document.getLineCount() ? document.getTextLength() - 1 : document.getLineEndOffset(line2)) : StringUtil.lineColToOffset((CharSequence)text2, (int)(line2 + 1), (int)0) - 1;
                if (offset > lineEndOffset) continue;
                problemRange = new TextRange(offset, lineEndOffset);
            }
            @NonNls String message = "PEP 8: " + problem.myCode + " " + problem.myDescription;
            HighlightSeverity severity = annotationResult.level == HighlightDisplayLevel.ERROR ? HighlightSeverity.ERROR : (annotationResult.level == HighlightDisplayLevel.WARNING ? HighlightSeverity.WARNING : HighlightSeverity.WEAK_WARNING);
            if (problem.myCode.equals("E401")) {
                fix = new OptimizeImportsQuickFix();
                universal = true;
            } else if (problem.myCode.equals("W391")) {
                fix = new RemoveTrailingBlankLinesFix();
                universal = true;
            } else if (problem.myCode.equals("E501")) {
                fix = new PyFillParagraphFix();
                universal = false;
            } else {
                fix = new ReformatFix();
                universal = true;
            }
            AnnotationBuilder builder = holder.newAnnotation(severity, message).range(problemRange);
            builder = universal ? builder.newFix((IntentionAction)fix).universal().registerFix() : builder.withFix((IntentionAction)fix);
            builder.withFix((IntentionAction)new IgnoreErrorFix(problem.myCode)).withFix((IntentionAction)new CustomEditInspectionToolsSettingsAction(HighlightDisplayKey.find((String)"PyPep8Inspection"), () -> PyBundle.message("QFIX.pep8.edit.inspection.profile.setting", new Object[0]))).create();
        }
    }

    private static boolean ignoredDueToProblemSuppressors(@NotNull Problem problem, @NotNull PsiFile file, @Nullable PsiElement element) {
        if (problem == null) {
            Pep8ExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (file == null) {
            Pep8ExternalAnnotator.$$$reportNull$$$0(4);
        }
        Pep8ProblemSuppressor[] suppressors = (Pep8ProblemSuppressor[])Pep8ProblemSuppressor.EP_NAME.getExtensions();
        return Arrays.stream(suppressors).anyMatch(p -> p.isProblemSuppressed(problem, file, element));
    }

    private static boolean ignoredDueToNoqaComment(@NotNull Problem problem, @NotNull PsiFile file, @Nullable Document document) {
        Set<String> codes;
        if (problem == null) {
            Pep8ExternalAnnotator.$$$reportNull$$$0(5);
        }
        if (file == null) {
            Pep8ExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (document == null) {
            return false;
        }
        int reportedLine = problem.myLine - 1;
        int lineLastOffset = Math.max(document.getLineStartOffset(reportedLine), document.getLineEndOffset(reportedLine) - 1);
        PsiComment comment = PyUtil.as(file.findElementAt(lineLastOffset), PsiComment.class);
        if (comment != null && (codes = Flake8InspectionSuppressor.extractNoqaCodes(comment)) != null) {
            return codes.isEmpty() || ContainerUtil.exists(codes, code -> problem.myCode.startsWith((String)code));
        }
        return false;
    }

    private static boolean crossesLineBoundary(@Nullable Document document, String text2, TextRange problemRange) {
        int start = problemRange.getStartOffset();
        int end = problemRange.getEndOffset();
        if (document != null) {
            return document.getLineNumber(start) != document.getLineNumber(end);
        }
        return StringUtil.offsetToLineNumber((CharSequence)text2, (int)start) != StringUtil.offsetToLineNumber((CharSequence)text2, (int)end);
    }

    private static boolean ignoreDueToSettings(PsiFile file, Problem problem, @Nullable PsiElement element) {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        if (!editorSettings.getStripTrailingSpaces().equals("None") && (problem.myCode.equals("W291") || problem.myCode.equals("W293"))) {
            return true;
        }
        CommonCodeStyleSettings commonSettings = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PythonLanguage.getInstance());
        PyCodeStyleSettings pySettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PyCodeStyleSettings.class);
        if (element instanceof PsiWhiteSpace) {
            Matcher matcher;
            if (problem.myCode.equals("E303") && (matcher = E303_LINE_COUNT_PATTERN.matcher(problem.myDescription)).matches()) {
                boolean functionNearby;
                int reportedBlanks = Integer.parseInt(matcher.group(1));
                PsiElement nonWhitespaceAfter = PyPsiUtils.getNextNonWhitespaceSibling(element);
                PsiElement nonWhitespaceBefore = PyPsiUtils.getPrevNonWhitespaceSibling(element);
                boolean classNearby = nonWhitespaceBefore instanceof PyClass || nonWhitespaceAfter instanceof PyClass;
                boolean bl = functionNearby = nonWhitespaceBefore instanceof PyFunction || nonWhitespaceAfter instanceof PyFunction;
                if ((functionNearby || classNearby) && (PyUtil.isTopLevel(element) ? reportedBlanks <= pySettings.BLANK_LINES_AROUND_TOP_LEVEL_CLASSES_FUNCTIONS : classNearby && reportedBlanks <= commonSettings.BLANK_LINES_AROUND_CLASS || functionNearby && reportedBlanks <= commonSettings.BLANK_LINES_AROUND_METHOD)) {
                    return true;
                }
            }
            if (problem.myCode.equals("E251") && (element.getParent() instanceof PyParameter && pySettings.SPACE_AROUND_EQ_IN_NAMED_PARAMETER || element.getParent() instanceof PyKeywordArgument && pySettings.SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT || element.getParent() instanceof PyKeywordPattern && pySettings.SPACE_AROUND_EQ_IN_KEYWORD_ARGUMENT)) {
                return true;
            }
        }
        return problem.myCode.equals("W191") && CodeStyle.getIndentOptions((PsiFile)file).USE_TAB_CHARACTER;
    }

    @Nullable
    private static Problem parseProblem(String s) {
        Matcher m = PROBLEM_PATTERN.matcher(s);
        if (m.matches()) {
            int line2 = Integer.parseInt(m.group(1));
            int column = Integer.parseInt(m.group(2));
            return new Problem(line2, column, m.group(3), m.group(4));
        }
        if (((ApplicationInfoImpl)ApplicationInfo.getInstance()).isEAP()) {
            LOG.info("Failed to parse problem line from pycodestyle.py: " + s);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/Pep8ExternalAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoredDueToProblemSuppressors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoredDueToNoqaComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IgnoreErrorFix
    implements IntentionAction {
        private final String myCode;

        IgnoreErrorFix(String code) {
            this.myCode = code;
        }

        @NotNull
        public String getText() {
            String string = PyPsiBundle.message("ANN.ignore.errors.like.this", new Object[0]);
            if (string == null) {
                IgnoreErrorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                IgnoreErrorFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
            if (project == null) {
                IgnoreErrorFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                IgnoreErrorFix.$$$reportNull$$$0(3);
            }
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, it -> {
                PyPep8Inspection tool = (PyPep8Inspection)it.getUnwrappedTool("PyPep8Inspection", (PsiElement)file);
                if (!tool.ignoredErrors.contains(this.myCode)) {
                    tool.ignoredErrors.add(this.myCode);
                }
            });
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/validation/Pep8ExternalAnnotator$IgnoreErrorFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/validation/Pep8ExternalAnnotator$IgnoreErrorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Results {
        public final List<Problem> problems = new ArrayList<Problem>();
        private final HighlightDisplayLevel level;

        public Results(HighlightDisplayLevel level) {
            this.level = level;
        }
    }

    public static class State {
        private final String interpreterPath;
        private final String fileText;
        private final HighlightDisplayLevel level;
        private final List<String> ignoredErrors;
        private final int margin;
        private final boolean hangClosingBrackets;

        public State(String interpreterPath, String fileText, HighlightDisplayLevel level, List<String> ignoredErrors, int margin, boolean hangClosingBrackets) {
            this.interpreterPath = interpreterPath;
            this.fileText = fileText;
            this.level = level;
            this.ignoredErrors = ignoredErrors;
            this.margin = margin;
            this.hangClosingBrackets = hangClosingBrackets;
        }
    }

    public static class Problem {
        private final int myLine;
        private final int myColumn;
        private final String myCode;
        private final String myDescription;

        public Problem(int line2, int column, @NotNull String code, @NotNull String description) {
            if (code == null) {
                Problem.$$$reportNull$$$0(0);
            }
            if (description == null) {
                Problem.$$$reportNull$$$0(1);
            }
            this.myLine = line2;
            this.myColumn = column;
            this.myCode = code;
            this.myDescription = description;
        }

        public int getLine() {
            return this.myLine;
        }

        public int getColumn() {
            return this.myColumn;
        }

        @NotNull
        public String getCode() {
            String string = this.myCode;
            if (string == null) {
                Problem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                Problem.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/validation/Pep8ExternalAnnotator$Problem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/validation/Pep8ExternalAnnotator$Problem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

