/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class PyBuiltinAnnotator
extends PyAnnotator {
    @Override
    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        String name;
        if (node == null) {
            PyBuiltinAnnotator.$$$reportNull$$$0(0);
        }
        if ((name = node.getName()) == null) {
            return;
        }
        boolean highlightedAsAttribute = this.highlightAsAttribute(node, name);
        if (highlightedAsAttribute) {
            return;
        }
        if ((PyBuiltinCache.isInBuiltins(node) || PyUtil.isPy2ReservedWord(node)) && !(node.getParent() instanceof PyDecorator)) {
            this.addHighlightingAnnotation((PsiElement)node, PyHighlighter.PY_BUILTIN_NAME);
        }
    }

    @Override
    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        String name;
        if (node == null) {
            PyBuiltinAnnotator.$$$reportNull$$$0(1);
        }
        if ((name = node.getName()) != null) {
            this.highlightAsAttribute(node, name);
        }
    }

    private boolean highlightAsAttribute(@NotNull PyQualifiedExpression node, @NotNull String name) {
        ASTNode tgt;
        ASTNode astNode;
        if (node == null) {
            PyBuiltinAnnotator.$$$reportNull$$$0(2);
        }
        if (name == null) {
            PyBuiltinAnnotator.$$$reportNull$$$0(3);
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)node);
        if ((PyNames.UNDERSCORED_ATTRIBUTES.contains(name) || PyNames.getBuiltinMethods(languageLevel).containsKey(name)) && (node.isQualified() || ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyClass) && (astNode = node.getNode()) != null && (tgt = astNode.findChildByType((IElementType)PyTokenTypes.IDENTIFIER)) != null) {
            this.addHighlightingAnnotation(tgt, PyHighlighter.PY_PREDEFINED_USAGE);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyBuiltinAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyTargetExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightAsAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

