/*
 * Decompiled with CFR 0.152.
 */
package circlet.code.github;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lcirclet/code/github/GitHubCommonUtil;", "", "()V", "getGitHubApiURL", "", "repo", "getGitHubRepoNameFromURL", "url", "getGitHubWebhookPageURL", "isGitHubRepository", "", "code-common"})
public final class GitHubCommonUtil {
    @NotNull
    public static final GitHubCommonUtil INSTANCE = new GitHubCommonUtil();

    private GitHubCommonUtil() {
    }

    public final boolean isGitHubRepository(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        return StringsKt.contains$default((CharSequence)url2, (CharSequence)"github.com", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getGitHubRepoNameFromURL(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        if (StringsKt.startsWith$default((String)url2, (String)"https://github.com/", (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)url2, (CharSequence)"https://github.com/"), (CharSequence)".git");
        }
        if (StringsKt.startsWith$default((String)url2, (String)"git@github.com:", (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)url2, (CharSequence)"git@github.com:"), (CharSequence)".git");
        }
        return StringsKt.removeSuffix((String)url2, (CharSequence)".git");
    }

    @NotNull
    public final String getGitHubApiURL(@NotNull String repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        return Intrinsics.stringPlus((String)"https://api.github.com/repos/", (Object)this.getGitHubRepoNameFromURL(repo));
    }

    @NotNull
    public final String getGitHubWebhookPageURL(@NotNull String repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        return "https://github.com/" + this.getGitHubRepoNameFromURL(repo) + "/settings/hooks";
    }
}

