/*
 * Decompiled with CFR 0.152.
 */
package circlet.code.review;

import circlet.code.api.CodeReviewParticipant;
import circlet.code.api.CodeReviewParticipantRole;
import circlet.code.api.CodeReviewParticipants;
import circlet.code.api.CodeReviewRecord;
import circlet.code.api.CodeReviewServiceKt;
import circlet.code.api.CodeReviewState;
import circlet.code.api.ReviewerState;
import circlet.code.review.ReviewParticipantStatus;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"getReviewParticipantStatus", "Lcirclet/code/review/ReviewParticipantStatus;", "review", "Lcirclet/code/api/CodeReviewRecord;", "participants", "Lcirclet/code/api/CodeReviewParticipants;", "participant", "Lcirclet/code/api/CodeReviewParticipant;", "code-client"})
public final class ReviewParticipantStatusKt {
    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final ReviewParticipantStatus getReviewParticipantStatus(@NotNull CodeReviewRecord review, @NotNull CodeReviewParticipants participants, @NotNull CodeReviewParticipant participant) {
        CodeReviewParticipant it;
        boolean bl;
        ReviewParticipantStatus reviewParticipantStatus;
        List<CodeReviewParticipant> reviewers2;
        block14: {
            Iterator iterator2;
            block19: {
                boolean isWaitingReply;
                block17: {
                    Iterable $this$any$iv;
                    block18: {
                        boolean bl2;
                        boolean isOpen;
                        block13: {
                            block16: {
                                Intrinsics.checkNotNullParameter((Object)review, (String)"review");
                                Intrinsics.checkNotNullParameter((Object)participants, (String)"participants");
                                Intrinsics.checkNotNullParameter((Object)participant, (String)"participant");
                                isOpen = review.getState() == CodeReviewState.Opened;
                                reviewers2 = CodeReviewServiceKt.getReviewers(participants);
                                if (participant.getRole() != CodeReviewParticipantRole.Author) break block16;
                                Iterable $this$any$iv2 = reviewers2;
                                boolean $i$f$any = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                    break block13;
                                } else {
                                    for (Object element$iv : $this$any$iv2) {
                                        CodeReviewParticipant it2 = (CodeReviewParticipant)element$iv;
                                        boolean bl3 = false;
                                        if (!Intrinsics.areEqual(it2.getUser(), participant.getUser())) continue;
                                        bl2 = true;
                                        break block13;
                                    }
                                    bl2 = false;
                                }
                                break block13;
                            }
                            bl2 = false;
                        }
                        boolean isReviewerAlsoAuthor = bl2;
                        boolean showTurnInfo = isOpen && Intrinsics.areEqual((Object)review.getTurnBased(), (Object)true) && !isReviewerAlsoAuthor;
                        boolean isAccepted = CodeReviewServiceKt.getReviewerState(participant) == ReviewerState.Accepted;
                        boolean isRejected = CodeReviewServiceKt.getReviewerState(participant) == ReviewerState.Rejected;
                        boolean isInProgress = showTurnInfo && CodeReviewServiceKt.getReviewerState(participant) == null && Intrinsics.areEqual((Object)participant.getTheirTurn(), (Object)true);
                        isWaitingReply = showTurnInfo && CodeReviewServiceKt.getReviewerState(participant) == null && Intrinsics.areEqual((Object)participant.getTheirTurn(), (Object)false);
                        if (isAccepted) {
                            reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_ACCEPTED;
                            return reviewParticipantStatus;
                        }
                        if (isRejected) {
                            reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_REJECTED;
                            return reviewParticipantStatus;
                        }
                        if (isInProgress && participant.getRole() == CodeReviewParticipantRole.Reviewer) {
                            reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_IN_PROGRESS;
                            return reviewParticipantStatus;
                        }
                        if (!isInProgress || participant.getRole() != CodeReviewParticipantRole.Author) break block17;
                        $this$any$iv = reviewers2;
                        boolean $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block18;
                        bl = false;
                        break block14;
                    }
                    iterator2 = $this$any$iv.iterator();
                    break block19;
                }
                if (isWaitingReply && participant.getRole() == CodeReviewParticipantRole.Author) {
                    reviewParticipantStatus = ReviewParticipantStatus.AUTHOR_WAITS_RESPONSE;
                    return reviewParticipantStatus;
                }
                if (!isWaitingReply) return null;
                if (participant.getRole() != CodeReviewParticipantRole.Reviewer) return null;
                reviewParticipantStatus = ReviewParticipantStatus.REVIEWER_WAITS_RESPONSE;
                return reviewParticipantStatus;
            }
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                it = (CodeReviewParticipant)element$iv;
                boolean bl4 = false;
                if (!(CodeReviewServiceKt.getReviewerState(it) == ReviewerState.Accepted)) continue;
                bl = true;
                break block14;
            }
            bl = false;
        }
        if (bl) {
            boolean bl5;
            block15: {
                Iterable $this$none$iv = reviewers2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl5 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (CodeReviewParticipant)element$iv;
                        boolean bl6 = false;
                        if (!(CodeReviewServiceKt.getReviewerState(it) == null && Intrinsics.areEqual((Object)it.getTheirTurn(), (Object)false))) continue;
                        bl5 = false;
                        break block15;
                    }
                    bl5 = true;
                }
            }
            if (bl5) {
                reviewParticipantStatus = ReviewParticipantStatus.AUTHOR_GOT_ALL_APPROVALS;
                return reviewParticipantStatus;
            }
        }
        reviewParticipantStatus = ReviewParticipantStatus.AUTHOR_REVISING_FILES;
        return reviewParticipantStatus;
    }
}

