/*
 * Decompiled with CFR 0.152.
 */
package runtime.batchSource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import libraries.coroutines.extra.CoroutineBuildersCommonKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import libraries.coroutines.extra.Lifetimed;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchKt;
import runtime.async.AtomicBoolean;
import runtime.async.AtomicInteger;
import runtime.async.AtomicKt;
import runtime.batchSource.BatchSource;
import runtime.batchSource.BatchSourceBase;
import runtime.batchSource.BatchSourceKt;
import runtime.batchSource.Result;
import runtime.reactive.CellableKt;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.SequentialLifetimes;
import runtime.reactive.SignalImpl;
import runtime.reactive.SignalKt;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;
import runtime.reactive.property.FlatMapKt;
import runtime.reactive.property.MapKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002/0B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J&\u0010 \u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010#\u001a\u00020$H$J\u0019\u0010%\u001a\u00020\u00182\n\b\u0002\u0010&\u001a\u0004\u0018\u00010$H\u0004\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u0004\u0018\u00018\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\r\u0010*\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020$H\u0016J\b\u0010.\u001a\u00020\u0018H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lruntime/batchSource/BatchSourceBase;", "T", "Lruntime/batchSource/BatchSource;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "(Llibraries/coroutines/extra/Lifetime;)V", "first", "", "getFirst", "()Z", "setFirst", "(Z)V", "hangingAtStart", "getHangingAtStart", "hasMore", "Lruntime/reactive/Property;", "getHasMore", "()Lruntime/reactive/Property;", "ignorable", "getIgnorable", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "resurrected", "Lruntime/reactive/Source;", "", "getResurrected", "()Lruntime/reactive/Source;", "sl", "Lruntime/reactive/SequentialLifetimes;", "wrapper", "Lruntime/reactive/MutableProperty;", "Lruntime/batchSource/BatchSourceBase$ChannelWrapper;", "launchReadChannel", "ch", "Lkotlinx/coroutines/channels/Channel;", "ask", "", "launchReadChannelImpl", "firstBatch", "(Ljava/lang/Integer;)V", "peek", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pop", "()Ljava/lang/Object;", "reload", "batch", "reset", "ChannelWrapper", "State", "platform-runtime"})
public abstract class BatchSourceBase<T>
implements BatchSource<T> {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final SequentialLifetimes sl;
    @NotNull
    private final MutableProperty<ChannelWrapper<T>> wrapper;
    @NotNull
    private final Property<Boolean> hasMore;
    @NotNull
    private final Source<Unit> resurrected;
    private boolean first;

    public BatchSourceBase(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.sl = new SequentialLifetimes(this.lifetime);
        this.wrapper = CellableKt.mutableProperty(null);
        this.hasMore = MapKt.map((Lifetimed)this.lifetime, FlatMapKt.flatMap(this.lifetime, (Property)this.wrapper, (Function2)hasMore.1.INSTANCE), (Function2)hasMore.2.INSTANCE);
        this.resurrected = SourceKt.flatMap((Source)this.wrapper, resurrected.1.INSTANCE);
        this.first = true;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Override
    @NotNull
    public Property<Boolean> getHasMore() {
        return this.hasMore;
    }

    @Override
    @NotNull
    public Source<Unit> getResurrected() {
        return this.resurrected;
    }

    protected abstract void launchReadChannel(@NotNull Lifetime var1, @NotNull Channel<T> var2, int var3);

    protected boolean getIgnorable() {
        return false;
    }

    protected boolean getHangingAtStart() {
        return false;
    }

    public final boolean getFirst() {
        return this.first;
    }

    public final void setFirst(boolean bl) {
        this.first = bl;
    }

    protected final void launchReadChannelImpl(@Nullable Integer firstBatch) {
        Lifetime lt2 = this.sl.next();
        ChannelWrapper wr = new ChannelWrapper(lt2, this.getIgnorable(), this.getHangingAtStart(), this.first);
        this.first = false;
        this.wrapper.setValue(wr);
        Integer n = firstBatch;
        int ask = n == null ? 30 : n;
        this.launchReadChannel(lt2, wr.getCh(), ask);
    }

    public static /* synthetic */ void launchReadChannelImpl$default(BatchSourceBase batchSourceBase, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: launchReadChannelImpl");
        }
        if ((n2 & 1) != 0) {
            n = null;
        }
        batchSourceBase.launchReadChannelImpl(n);
    }

    @Override
    public void reset() {
        ChannelWrapper<T> channelWrapper = this.wrapper.getValue();
        if (channelWrapper != null) {
            channelWrapper.reset();
        }
    }

    @Override
    public void reload(int batch2) {
        KLogger this_$iv = BatchSourceKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string2 = Intrinsics.stringPlus((String)"Reload bucket ", (Object)this);
            kLogger.debug(string2);
        }
        ChannelWrapper<T> channelWrapper = this.wrapper.getValue();
        int n = channelWrapper == null ? 0 : channelWrapper.getChannelCacheSize();
        boolean bl = false;
        int requestBatchCount = Math.max(n, batch2);
        this.launchReadChannelImpl(requestBatchCount);
    }

    @Override
    @Nullable
    public Object peek(@NotNull Continuation<? super T> $completion) {
        return BatchSourceBase.peek$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object peek$suspendImpl(BatchSourceBase this_, Continuation $completion) {
        ChannelWrapper channelWrapper = this_.wrapper.getValue();
        if (channelWrapper != null) {
            return channelWrapper.peek($completion);
        }
        return null;
    }

    @Override
    public T pop() {
        ChannelWrapper<T> channelWrapper = this.wrapper.getValue();
        Intrinsics.checkNotNull(channelWrapper);
        return channelWrapper.pop();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ.\u0010&\u001a\u00020\u001d2\u0014\u0010'\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010(0\u00192\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0004H\u0002J\u0013\u0010+\u001a\u0004\u0018\u00018\u0001H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u000b\u0010-\u001a\u00028\u0001\u00a2\u0006\u0002\u0010.J\u0006\u0010/\u001a\u00020\u001dR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00060"}, d2={"Lruntime/batchSource/BatchSourceBase$ChannelWrapper;", "T", "", "wrapperLifetime", "Llibraries/coroutines/extra/Lifetime;", "ignorable", "", "hangingAtStart", "firstItem", "(Llibraries/coroutines/extra/Lifetime;ZZZ)V", "ch", "Lkotlinx/coroutines/channels/Channel;", "getCh", "()Lkotlinx/coroutines/channels/Channel;", "channelCacheSize", "", "getChannelCacheSize", "()I", "current", "Lruntime/async/AtomicInteger;", "elements", "", "first", "Lruntime/async/AtomicBoolean;", "mutableState", "Lruntime/reactive/MutableProperty;", "Lruntime/batchSource/BatchSourceBase$State;", "resurrected", "Lruntime/reactive/Source;", "", "getResurrected", "()Lruntime/reactive/Source;", "resurrectedSignal", "Lruntime/reactive/SignalImpl;", "state", "Lruntime/reactive/Property;", "getState", "()Lruntime/reactive/Property;", "handleHangingState", "ret", "Lruntime/batchSource/Result;", "hasTimedOut", "timeoutAwaiterLt", "peek", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pop", "()Ljava/lang/Object;", "reset", "platform-runtime"})
    private static final class ChannelWrapper<T> {
        @NotNull
        private final Lifetime wrapperLifetime;
        private final boolean ignorable;
        private final boolean hangingAtStart;
        @NotNull
        private final List<T> elements;
        @NotNull
        private final AtomicInteger current;
        @NotNull
        private final AtomicBoolean first;
        @NotNull
        private final MutableProperty<State> mutableState;
        @NotNull
        private final SignalImpl<Unit> resurrectedSignal;
        @NotNull
        private final Channel<T> ch;

        public ChannelWrapper(@NotNull Lifetime wrapperLifetime, boolean ignorable, boolean hangingAtStart, boolean firstItem) {
            Intrinsics.checkNotNullParameter((Object)wrapperLifetime, (String)"wrapperLifetime");
            this.wrapperLifetime = wrapperLifetime;
            this.ignorable = ignorable;
            this.hangingAtStart = hangingAtStart;
            boolean bl = false;
            this.elements = new ArrayList();
            this.current = AtomicKt.atomicInt(0);
            this.first = AtomicKt.atomicBoolean(firstItem);
            this.mutableState = CellableKt.mutableProperty(State.HasMore);
            this.resurrectedSignal = new SignalImpl();
            this.ch = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
        }

        @NotNull
        public final Channel<T> getCh() {
            return this.ch;
        }

        @NotNull
        public final Source<Unit> getResurrected() {
            return this.resurrectedSignal;
        }

        @NotNull
        public final Property<State> getState() {
            return this.mutableState;
        }

        public final int getChannelCacheSize() {
            Collection collection = this.elements;
            boolean bl = false;
            return collection.size();
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object peek(@NotNull Continuation<? super T> var1_1) {
            if (!(var1_1 instanceof peek.1)) ** GOTO lbl-1000
            var11_2 = var1_1;
            if ((var11_2.label & -2147483648) != 0) {
                var11_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var1_1){
                    /* synthetic */ Object result;
                    final /* synthetic */ ChannelWrapper<T> this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.peek((Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var2_5 = this.elements;
                    var3_6 = false;
                    if (this.current.getValue() < var2_5.size()) {
                        return this.elements.get(this.current.getValue());
                    }
                    var2_5 = BatchSourceKt.access$getLog$p();
                    var3_7 = this.elements;
                    var4_10 = false;
                    condition$iv = this.current.getValue() == var3_7.size();
                    $i$f$assert = false;
                    if (!condition$iv) {
                        var8_12 = $this$assert$iv;
                        $i$a$-assert-BatchSourceBase$ChannelWrapper$peek$2 = false;
                        var6_14 = this.elements;
                        var7_15 = false;
                        var9_16 = "current == elements.count() but was " + this.current + " == " + var6_14.size();
                        var8_12.error(var9_16);
                    }
                    if (this.getState().getValue() != State.HasMore) {
                        return null;
                    }
                    hasTimedOut = AtomicKt.atomicBoolean(false);
                    ret = CellableKt.mutableProperty(null);
                    timeoutAwaiterLt = LifetimeUtilsKt.nested(this.wrapperLifetime);
                    CoroutineBuildersCommonKt.launch$default(this.wrapperLifetime, DispatchKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, timeoutAwaiterLt, hasTimedOut, ret, null){
                        int label;
                        final /* synthetic */ ChannelWrapper<T> this$0;
                        final /* synthetic */ LifetimeSource $timeoutAwaiterLt;
                        final /* synthetic */ AtomicBoolean $hasTimedOut;
                        final /* synthetic */ MutableProperty<Result<T>> $ret;
                        {
                            this.this$0 = $receiver;
                            this.$timeoutAwaiterLt = $timeoutAwaiterLt;
                            this.$hasTimedOut = $hasTimedOut;
                            this.$ret = $ret;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.label = 1;
                                    v0 = this.this$0.getCh().receive((Continuation)this);
                                    ** if (v0 != var9_2) goto lbl11
lbl10:
                                    // 1 sources

                                    return var9_2;
lbl11:
                                    // 1 sources

                                    ** GOTO lbl17
                                }
                                case 1: {
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        var3_3 = v0;
                                        var4_4 = this.this$0;
                                        var5_6 = false;
                                        var6_7 = false;
                                        it = var3_3;
                                        $i$a$-also-BatchSourceBase$ChannelWrapper$peek$3$el$1 = false;
                                        ChannelWrapper.access$getElements$p(var4_4).add(it);
                                    }
                                    catch (ClosedReceiveChannelException var4_5) {
                                        var3_3 = null;
                                    }
                                    el = var3_3;
                                    this.$timeoutAwaiterLt.terminate();
                                    if (this.$hasTimedOut.getValue()) {
                                        if (el != null) {
                                            ChannelWrapper.access$getMutableState$p(this.this$0).setValue(State.HasMore);
                                            SignalKt.fire(ChannelWrapper.access$getResurrectedSignal$p(this.this$0));
                                        }
                                    } else {
                                        this.$ret.setValue(new Result<Object>(el));
                                    }
                                    if (el == null) {
                                        ChannelWrapper.access$getMutableState$p(this.this$0).setValue(State.Completed);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 12, null);
                    if (this.ignorable) {
                        if (this.first.getValue() && this.hangingAtStart) {
                            this.handleHangingState(ret, hasTimedOut, timeoutAwaiterLt);
                        } else {
                            CoroutineBuildersCommonKt.launch$default(timeoutAwaiterLt, DispatchKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ret, hasTimedOut, timeoutAwaiterLt, null){
                                int label;
                                final /* synthetic */ ChannelWrapper<T> this$0;
                                final /* synthetic */ MutableProperty<Result<T>> $ret;
                                final /* synthetic */ AtomicBoolean $hasTimedOut;
                                final /* synthetic */ LifetimeSource $timeoutAwaiterLt;
                                {
                                    this.this$0 = $receiver;
                                    this.$ret = $ret;
                                    this.$hasTimedOut = $hasTimedOut;
                                    this.$timeoutAwaiterLt = $timeoutAwaiterLt;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = CoroutineBuildersCommonKt.delay(2000, (Continuation<? super Unit>)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl13
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl13:
                                            // 2 sources

                                            ChannelWrapper.access$handleHangingState(this.this$0, this.$ret, this.$hasTimedOut, this.$timeoutAwaiterLt);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 12, null);
                        }
                    }
                    $continuation.label = 1;
                    v0 = SourceKt.awaitFirst(SourceKt.filterNotNull((Source)ret), this.wrapperLifetime, $continuation);
                    if (v0 == var12_4) {
                        return var12_4;
                    }
                    ** GOTO lbl50
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl50:
                    // 2 sources

                    return ((Result)v0).getResult();
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public final T pop() {
            return this.elements.get(this.current.getAndIncrement());
        }

        public final void reset() {
            this.current.set(0);
            if (this.getState().getValue() != State.HasMore && this.getChannelCacheSize() > 0) {
                this.mutableState.setValue(State.HasMore);
            }
        }

        private final void handleHangingState(MutableProperty<Result<T>> ret, AtomicBoolean hasTimedOut, Lifetime timeoutAwaiterLt) {
            this.first.set(false);
            if (!timeoutAwaiterLt.isTerminated()) {
                hasTimedOut.set(true);
                this.mutableState.setValue(State.Hanging);
                ret.setValue(new Result<Object>(null));
            }
        }

        public static final /* synthetic */ MutableProperty access$getMutableState$p(ChannelWrapper $this) {
            return $this.mutableState;
        }

        public static final /* synthetic */ SignalImpl access$getResurrectedSignal$p(ChannelWrapper $this) {
            return $this.resurrectedSignal;
        }

        public static final /* synthetic */ List access$getElements$p(ChannelWrapper $this) {
            return $this.elements;
        }

        public static final /* synthetic */ void access$handleHangingState(ChannelWrapper $this, MutableProperty ret, AtomicBoolean hasTimedOut, Lifetime timeoutAwaiterLt) {
            $this.handleHangingState(ret, hasTimedOut, timeoutAwaiterLt);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lruntime/batchSource/BatchSourceBase$State;", "", "(Ljava/lang/String;I)V", "HasMore", "Completed", "Hanging", "platform-runtime"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State HasMore = new State();
        public static final /* enum */ State Completed = new State();
        public static final /* enum */ State Hanging = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.HasMore, State.Completed, State.Hanging};
        }
    }
}

