/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J:\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u001e"}, d2={"Lruntime/utils/Domain;", "", "hostname", "", "subdomain", "port", "", "protocol", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)V", "getHostname", "()Ljava/lang/String;", "getPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getProtocol", "getSubdomain", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Lruntime/utils/Domain;", "equals", "", "other", "hashCode", "linkToDomain", "linkToRoot", "toString", "Companion", "platform-runtime"})
public final class Domain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String hostname;
    @Nullable
    private final String subdomain;
    @Nullable
    private final Integer port;
    @NotNull
    private final String protocol;

    public Domain(@NotNull String hostname, @Nullable String subdomain2, @Nullable Integer port, @NotNull String protocol) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.hostname = hostname;
        this.subdomain = subdomain2;
        this.port = port;
        this.protocol = protocol;
    }

    @NotNull
    public final String getHostname() {
        return this.hostname;
    }

    @Nullable
    public final String getSubdomain() {
        return this.subdomain;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String linkToDomain(@NotNull String subdomain2) {
        void $this$logger$iv;
        Intrinsics.checkNotNullParameter((Object)subdomain2, (String)"subdomain");
        String res = null;
        res = this.protocol + "//" + subdomain2 + '.' + this.hostname;
        if (this.port != null) {
            res = res + ':' + this.port;
        }
        KLoggers kLoggers = KLoggers.INSTANCE;
        String fallbackName$iv = "tst";
        boolean $i$f$logger = false;
        KLogger this_$iv = $this$logger$iv.logger((Function0<String>)((Function0)new Function0<String>(fallbackName$iv){
            final /* synthetic */ String $fallbackName;
            {
                this.$fallbackName = $fallbackName;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$fallbackName;
            }
        }));
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string2 = res;
            kLogger.info(string2);
        }
        return res;
    }

    @NotNull
    public final String linkToRoot() {
        String res = this.protocol + "//" + this.hostname;
        if (this.port != null) {
            res = res + ':' + this.port;
        }
        return res;
    }

    @NotNull
    public final String component1() {
        return this.hostname;
    }

    @Nullable
    public final String component2() {
        return this.subdomain;
    }

    @Nullable
    public final Integer component3() {
        return this.port;
    }

    @NotNull
    public final String component4() {
        return this.protocol;
    }

    @NotNull
    public final Domain copy(@NotNull String hostname, @Nullable String subdomain2, @Nullable Integer port, @NotNull String protocol) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        return new Domain(hostname, subdomain2, port, protocol);
    }

    public static /* synthetic */ Domain copy$default(Domain domain, String string2, String string3, Integer n, String string4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = domain.hostname;
        }
        if ((n2 & 2) != 0) {
            string3 = domain.subdomain;
        }
        if ((n2 & 4) != 0) {
            n = domain.port;
        }
        if ((n2 & 8) != 0) {
            string4 = domain.protocol;
        }
        return domain.copy(string2, string3, n, string4);
    }

    @NotNull
    public String toString() {
        return "Domain(hostname=" + this.hostname + ", subdomain=" + this.subdomain + ", port=" + this.port + ", protocol=" + this.protocol + ')';
    }

    public int hashCode() {
        int result2 = this.hostname.hashCode();
        result2 = result2 * 31 + (this.subdomain == null ? 0 : this.subdomain.hashCode());
        result2 = result2 * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
        result2 = result2 * 31 + this.protocol.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Domain)) {
            return false;
        }
        Domain domain = (Domain)other;
        if (!Intrinsics.areEqual((Object)this.hostname, (Object)domain.hostname)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subdomain, (Object)domain.subdomain)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)domain.port)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.protocol, (Object)domain.protocol);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lruntime/utils/Domain$Companion;", "", "()V", "create", "Lruntime/utils/Domain;", "hostname", "", "rootDomains", "", "port", "", "protocol", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Lruntime/utils/Domain;", "platform-runtime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Domain create(@NotNull String hostname, @NotNull String[] rootDomains, @Nullable Integer port, @NotNull String protocol) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter((Object)rootDomains, (String)"rootDomains");
            Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
            if (!StringsKt.contains$default((CharSequence)hostname, (char)'.', (boolean)false, (int)2, null)) {
                return new Domain(hostname, null, port, protocol);
            }
            String ret = StringsKt.substringBefore$default((String)hostname, (char)'.', null, (int)2, null);
            String host = StringsKt.substringAfter$default((String)hostname, (char)'.', null, (int)2, null);
            if (ArraysKt.contains((Object[])rootDomains, (Object)host)) {
                return new Domain(host, ret, port, protocol);
            }
            if (Intrinsics.areEqual((Object)host, (Object)"circlet.localhost")) {
                return new Domain(host, ret, port, protocol);
            }
            return new Domain(hostname, null, port, protocol);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

