/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.components;

import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.intellij.datavis.r.inlays.components.HistogramSlider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 72\u00020\u0001:\u0005789:;B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u001e\b\u0002\u0010\u0006\u001a\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020%H\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020%H\u0002J\u001a\u0010+\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010,\u001a\u0004\u0018\u00010-H\u0002J$\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\t2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010-2\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\b\u00103\u001a\u00020\nH\u0002J\u0012\u00104\u001a\u00020\n2\b\u00105\u001a\u0004\u0018\u00010-H\u0002J\b\u00106\u001a\u00020\nH\u0002R.\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0018\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010\u000fR\u000e\u0010#\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/intellij/datavis/r/inlays/components/HistogramSlider;", "", "histogram", "Lorg/intellij/datavis/r/inlays/components/HistogramSlider$Histogram;", "drawingStyle", "Lorg/intellij/datavis/r/inlays/components/HistogramSlider$DrawingStyle;", "onUserInput", "Lkotlin/Function1;", "Lkotlin/ranges/ClosedRange;", "", "", "(Lorg/intellij/datavis/r/inlays/components/HistogramSlider$Histogram;Lorg/intellij/datavis/r/inlays/components/HistogramSlider$DrawingStyle;Lkotlin/jvm/functions/Function1;)V", "range", "backingSelectionRange", "setBackingSelectionRange", "(Lkotlin/ranges/ClosedRange;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "frequencies", "", "fromInputField", "Lorg/intellij/datavis/r/inlays/components/HistogramSlider$SwitchableNumberField;", "histogramEnd", "histogramPanel", "Lorg/intellij/datavis/r/inlays/components/HistogramSlider$HistogramPanel;", "histogramStart", "histogramStep", "rootPanel", "Ljavax/swing/JPanel;", "selectionRange", "getSelectionRange", "()Lkotlin/ranges/ClosedRange;", "setSelectionRange", "toInputField", "xFirst", "", "xSecond", "convertCoordinateToValue", "coordinate", "convertIndexToValue", "index", "convertIndicesToValues", "indices", "Lkotlin/ranges/IntRange;", "convertValueToIndex", "value", "rounding", "convertValuesToIndices", "values", "notifyRangeChanged", "updateHistogramPanel", "newSelectedIndices", "updateSelectionRange", "Companion", "DrawingStyle", "Histogram", "HistogramPanel", "SwitchableNumberField", "intellij.notebooks.visualization"})
public final class HistogramSlider {
    private int xFirst;
    private int xSecond;
    private ClosedRange<Double> backingSelectionRange;
    private final List<Double> frequencies;
    private final double histogramStart;
    private final double histogramEnd;
    private final double histogramStep;
    private final HistogramPanel histogramPanel;
    private final SwitchableNumberField fromInputField;
    private final SwitchableNumberField toInputField;
    private final JPanel rootPanel;
    private final Function1<ClosedRange<Double>, Unit> onUserInput;
    private static final DrawingStyle DEFAULT_DRAWING_STYLE;
    @NotNull
    public static final Companion Companion;

    private final void setBackingSelectionRange(ClosedRange<Double> range) {
        this.backingSelectionRange = range;
        if (range != null) {
            this.fromInputField.silentlyChangeValue((Double)range.getStart());
            this.toInputField.silentlyChangeValue((Double)range.getEndInclusive());
        }
    }

    @NotNull
    public final JComponent getComponent() {
        return this.rootPanel;
    }

    @Nullable
    public final ClosedRange<Double> getSelectionRange() {
        return this.backingSelectionRange;
    }

    public final void setSelectionRange(@Nullable ClosedRange<Double> range) {
        if (Intrinsics.areEqual(range, this.backingSelectionRange) ^ true) {
            this.setBackingSelectionRange(range);
            IntRange selectedIndices = this.convertValuesToIndices(range);
            this.updateHistogramPanel(selectedIndices);
        }
    }

    private final void notifyRangeChanged() {
        block0: {
            Function1<ClosedRange<Double>, Unit> function1 = this.onUserInput;
            if (function1 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function1.invoke(this.backingSelectionRange);
        }
    }

    private final IntRange convertValuesToIndices(ClosedRange<Double> values) {
        IntRange intRange;
        ClosedRange<Double> closedRange = values;
        if (closedRange != null) {
            ClosedRange<Double> closedRange2 = closedRange;
            boolean bl = false;
            boolean bl2 = false;
            ClosedRange<Double> range = closedRange2;
            boolean bl3 = false;
            int startIndex2 = this.convertValueToIndex(((Number)((Object)range.getStart())).doubleValue(), (Function1<? super Double, Double>)((Function1)convertValuesToIndices.1.startIndex.1.INSTANCE));
            int endIndex2 = this.convertValueToIndex(((Number)((Object)range.getEndInclusive())).doubleValue(), (Function1<? super Double, Double>)((Function1)convertValuesToIndices.1.endIndex.1.INSTANCE));
            intRange = new IntRange(startIndex2, endIndex2);
        } else {
            intRange = null;
        }
        return intRange;
    }

    private final int convertValueToIndex(double value, Function1<? super Double, Double> rounding) {
        double fractional = (value - this.histogramStart) / this.histogramStep;
        return (int)((Number)rounding.invoke((Object)fractional)).doubleValue();
    }

    private final ClosedRange<Double> convertIndicesToValues(IntRange indices) {
        ClosedFloatingPointRange closedFloatingPointRange;
        IntRange intRange = indices;
        if (intRange != null) {
            IntRange intRange2 = intRange;
            boolean bl = false;
            boolean bl2 = false;
            IntRange range = intRange2;
            boolean bl3 = false;
            double from = this.convertIndexToValue(range.getFirst());
            double to = this.convertIndexToValue(range.getLast());
            closedFloatingPointRange = RangesKt.rangeTo((double)from, (double)to);
        } else {
            closedFloatingPointRange = null;
        }
        return (ClosedRange)closedFloatingPointRange;
    }

    private final double convertIndexToValue(int index) {
        return (double)index * this.histogramStep + this.histogramStart;
    }

    private final double convertCoordinateToValue(int coordinate) {
        int width = this.histogramPanel.getWidth();
        double ratio = (double)coordinate / (double)width;
        double d = (double)this.frequencies.size() * this.histogramStep * ratio + this.histogramStart;
        boolean bl = false;
        return Math.floor(d);
    }

    private final void updateSelectionRange() {
        int width = this.histogramPanel.getWidth();
        int n = this.xFirst;
        int n2 = this.xSecond;
        int n3 = 0;
        int xFrom = RangesKt.coerceIn((int)Math.min(n, n2), (int)1, (int)(width - 1));
        n2 = this.xFirst;
        n3 = this.xSecond;
        boolean bl = false;
        int xTo = RangesKt.coerceIn((int)Math.max(n2, n3), (int)1, (int)(width - 1));
        double valueFrom = this.convertCoordinateToValue(xFrom);
        double valueTo = this.convertCoordinateToValue(xTo);
        this.setSelectionRange((ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)valueFrom, (double)valueTo)));
        this.setBackingSelectionRange(this.convertIndicesToValues(this.histogramPanel.getSelectedIndices()));
    }

    private final void updateHistogramPanel(IntRange newSelectedIndices) {
        if (Intrinsics.areEqual((Object)this.histogramPanel.getSelectedIndices(), (Object)newSelectedIndices) ^ true) {
            this.histogramPanel.setSelectedIndices(newSelectedIndices);
            this.getComponent().repaint();
        }
    }

    public HistogramSlider(@NotNull Histogram histogram, @Nullable DrawingStyle drawingStyle, @Nullable Function1<? super ClosedRange<Double>, Unit> onUserInput) {
        JPanel $this$apply;
        Intrinsics.checkNotNullParameter((Object)histogram, (String)"histogram");
        this.onUserInput = onUserInput;
        this.xFirst = -1;
        this.xSecond = -1;
        this.frequencies = histogram.getFrequencies();
        this.histogramStart = ((Number)((Object)histogram.getValues().getStart())).doubleValue();
        this.histogramEnd = ((Number)((Object)histogram.getValues().getEndInclusive())).doubleValue();
        this.histogramStep = (this.histogramEnd - this.histogramStart) / (double)histogram.getFrequencies().size();
        DrawingStyle drawingStyle2 = drawingStyle;
        if (drawingStyle2 == null) {
            drawingStyle2 = DEFAULT_DRAWING_STYLE;
        }
        JPanel jPanel = new HistogramPanel(this.frequencies, drawingStyle2, null, 4, null);
        boolean bl = false;
        boolean bl2 = false;
        HistogramPanel histogramPanel = jPanel;
        HistogramSlider histogramSlider = this;
        boolean bl3 = false;
        $this$apply.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ HistogramSlider this$0;
            {
                this.this$0 = histogramSlider;
            }

            public void mousePressed(@Nullable MouseEvent e) {
                if (e != null) {
                    HistogramSlider.access$setXFirst$p(this.this$0, e.getX());
                }
            }

            public void mouseReleased(@Nullable MouseEvent e) {
                if (e != null) {
                    HistogramSlider.access$setXSecond$p(this.this$0, e.getX());
                    HistogramSlider.access$updateSelectionRange(this.this$0);
                    HistogramSlider.access$notifyRangeChanged(this.this$0);
                }
            }
        });
        $this$apply.addMouseMotionListener(new MouseAdapter(this){
            final /* synthetic */ HistogramSlider this$0;
            {
                this.this$0 = histogramSlider;
            }

            public void mouseDragged(@Nullable MouseEvent e) {
                if (e != null) {
                    HistogramSlider.access$setXSecond$p(this.this$0, e.getX());
                    HistogramSlider.access$updateSelectionRange(this.this$0);
                }
            }
        });
        Unit unit = Unit.INSTANCE;
        histogramSlider.histogramPanel = jPanel;
        this.fromInputField = new SwitchableNumberField((Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ HistogramSlider this$0;

            public final void invoke(@Nullable Double newFrom) {
                this.this$0.setSelectionRange((ClosedRange<Double>)org.intellij.datavis.r.inlays.components.HistogramSlider$Companion.access$makeRange(HistogramSlider.Companion, newFrom, HistogramSlider.access$getToInputField$p(this.this$0).getValue()));
                HistogramSlider.access$notifyRangeChanged(this.this$0);
            }
            {
                this.this$0 = histogramSlider;
                super(1);
            }
        }));
        this.toInputField = new SwitchableNumberField((Function1<? super Double, Unit>)((Function1)new Function1<Double, Unit>(this){
            final /* synthetic */ HistogramSlider this$0;

            public final void invoke(@Nullable Double newTo) {
                this.this$0.setSelectionRange((ClosedRange<Double>)org.intellij.datavis.r.inlays.components.HistogramSlider$Companion.access$makeRange(HistogramSlider.Companion, HistogramSlider.access$getFromInputField$p(this.this$0).getValue(), newTo));
                HistogramSlider.access$notifyRangeChanged(this.this$0);
            }
            {
                this.this$0 = histogramSlider;
                super(1);
            }
        }));
        jPanel = new JPanel(new GridBagLayout());
        bl = false;
        bl2 = false;
        $this$apply = jPanel;
        histogramSlider = this;
        boolean bl4 = false;
        org.intellij.datavis.r.inlays.components.HistogramSlider$Companion.addWithConstraints$default(Companion, $this$apply, this.histogramPanel, 0, 0, 3, null, 1.0, 16, null);
        org.intellij.datavis.r.inlays.components.HistogramSlider$Companion.addWithConstraints$default(Companion, $this$apply, this.fromInputField, 0, 1, 0, 0.5, 0.0, 8, null);
        org.intellij.datavis.r.inlays.components.HistogramSlider$Companion.addWithConstraints$default(Companion, $this$apply, new JLabel("-", 0), 1, 1, 0, 0.0, 0.0, 8, null);
        org.intellij.datavis.r.inlays.components.HistogramSlider$Companion.addWithConstraints$default(Companion, $this$apply, this.toInputField, 2, 1, 0, 0.5, 0.0, 8, null);
        unit = Unit.INSTANCE;
        histogramSlider.rootPanel = jPanel;
    }

    public /* synthetic */ HistogramSlider(Histogram histogram, DrawingStyle drawingStyle, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            drawingStyle = null;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(histogram, drawingStyle, (Function1<? super ClosedRange<Double>, Unit>)function1);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_DRAWING_STYLE = new DrawingStyle(new Color(96, 160, 255), new Color(255, 0, 0, 96), null);
    }

    public static final /* synthetic */ int access$getXFirst$p(HistogramSlider $this) {
        return $this.xFirst;
    }

    public static final /* synthetic */ void access$setXFirst$p(HistogramSlider $this, int n) {
        $this.xFirst = n;
    }

    public static final /* synthetic */ int access$getXSecond$p(HistogramSlider $this) {
        return $this.xSecond;
    }

    public static final /* synthetic */ void access$setXSecond$p(HistogramSlider $this, int n) {
        $this.xSecond = n;
    }

    public static final /* synthetic */ void access$updateSelectionRange(HistogramSlider $this) {
        $this.updateSelectionRange();
    }

    public static final /* synthetic */ void access$notifyRangeChanged(HistogramSlider $this) {
        $this.notifyRangeChanged();
    }

    public static final /* synthetic */ SwitchableNumberField access$getToInputField$p(HistogramSlider $this) {
        return $this.toInputField;
    }

    public static final /* synthetic */ SwitchableNumberField access$getFromInputField$p(HistogramSlider $this) {
        return $this.fromInputField;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/intellij/datavis/r/inlays/components/HistogramSlider$Histogram;", "", "frequencies", "", "", "values", "Lkotlin/ranges/ClosedRange;", "(Ljava/util/List;Lkotlin/ranges/ClosedRange;)V", "getFrequencies", "()Ljava/util/List;", "getValues", "()Lkotlin/ranges/ClosedRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.notebooks.visualization"})
    public static final class Histogram {
        @NotNull
        private final List<Double> frequencies;
        @NotNull
        private final ClosedRange<Double> values;

        @NotNull
        public final List<Double> getFrequencies() {
            return this.frequencies;
        }

        @NotNull
        public final ClosedRange<Double> getValues() {
            return this.values;
        }

        public Histogram(@NotNull List<Double> frequencies, @NotNull ClosedRange<Double> values) {
            Intrinsics.checkNotNullParameter(frequencies, (String)"frequencies");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.frequencies = frequencies;
            this.values = values;
        }

        @NotNull
        public final List<Double> component1() {
            return this.frequencies;
        }

        @NotNull
        public final ClosedRange<Double> component2() {
            return this.values;
        }

        @NotNull
        public final Histogram copy(@NotNull List<Double> frequencies, @NotNull ClosedRange<Double> values) {
            Intrinsics.checkNotNullParameter(frequencies, (String)"frequencies");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new Histogram(frequencies, values);
        }

        public static /* synthetic */ Histogram copy$default(Histogram histogram, List list, ClosedRange closedRange, int n, Object object) {
            if ((n & 1) != 0) {
                list = histogram.frequencies;
            }
            if ((n & 2) != 0) {
                closedRange = histogram.values;
            }
            return histogram.copy(list, closedRange);
        }

        @NotNull
        public String toString() {
            return "Histogram(frequencies=" + this.frequencies + ", values=" + this.values + ")";
        }

        public int hashCode() {
            List<Double> list = this.frequencies;
            ClosedRange<Double> closedRange = this.values;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (closedRange != null ? closedRange.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Histogram)) break block3;
                    Histogram histogram = (Histogram)object;
                    if (!Intrinsics.areEqual(this.frequencies, histogram.frequencies) || !Intrinsics.areEqual(this.values, histogram.values)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/intellij/datavis/r/inlays/components/HistogramSlider$DrawingStyle;", "", "histogramColor", "Ljava/awt/Color;", "selectionColor", "backgroundColor", "(Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "getBackgroundColor", "()Ljava/awt/Color;", "getHistogramColor", "getSelectionColor", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.notebooks.visualization"})
    public static final class DrawingStyle {
        @NotNull
        private final Color histogramColor;
        @NotNull
        private final Color selectionColor;
        @Nullable
        private final Color backgroundColor;

        @NotNull
        public final Color getHistogramColor() {
            return this.histogramColor;
        }

        @NotNull
        public final Color getSelectionColor() {
            return this.selectionColor;
        }

        @Nullable
        public final Color getBackgroundColor() {
            return this.backgroundColor;
        }

        public DrawingStyle(@NotNull Color histogramColor, @NotNull Color selectionColor, @Nullable Color backgroundColor) {
            Intrinsics.checkNotNullParameter((Object)histogramColor, (String)"histogramColor");
            Intrinsics.checkNotNullParameter((Object)selectionColor, (String)"selectionColor");
            this.histogramColor = histogramColor;
            this.selectionColor = selectionColor;
            this.backgroundColor = backgroundColor;
        }

        @NotNull
        public final Color component1() {
            return this.histogramColor;
        }

        @NotNull
        public final Color component2() {
            return this.selectionColor;
        }

        @Nullable
        public final Color component3() {
            return this.backgroundColor;
        }

        @NotNull
        public final DrawingStyle copy(@NotNull Color histogramColor, @NotNull Color selectionColor, @Nullable Color backgroundColor) {
            Intrinsics.checkNotNullParameter((Object)histogramColor, (String)"histogramColor");
            Intrinsics.checkNotNullParameter((Object)selectionColor, (String)"selectionColor");
            return new DrawingStyle(histogramColor, selectionColor, backgroundColor);
        }

        public static /* synthetic */ DrawingStyle copy$default(DrawingStyle drawingStyle, Color color, Color color2, Color color3, int n, Object object) {
            if ((n & 1) != 0) {
                color = drawingStyle.histogramColor;
            }
            if ((n & 2) != 0) {
                color2 = drawingStyle.selectionColor;
            }
            if ((n & 4) != 0) {
                color3 = drawingStyle.backgroundColor;
            }
            return drawingStyle.copy(color, color2, color3);
        }

        @NotNull
        public String toString() {
            return "DrawingStyle(histogramColor=" + this.histogramColor + ", selectionColor=" + this.selectionColor + ", backgroundColor=" + this.backgroundColor + ")";
        }

        public int hashCode() {
            Color color = this.histogramColor;
            Color color2 = this.selectionColor;
            Color color3 = this.backgroundColor;
            return ((color != null ? ((Object)color).hashCode() : 0) * 31 + (color2 != null ? ((Object)color2).hashCode() : 0)) * 31 + (color3 != null ? ((Object)color3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DrawingStyle)) break block3;
                    DrawingStyle drawingStyle = (DrawingStyle)object;
                    if (!Intrinsics.areEqual((Object)this.histogramColor, (Object)drawingStyle.histogramColor) || !Intrinsics.areEqual((Object)this.selectionColor, (Object)drawingStyle.selectionColor) || !Intrinsics.areEqual((Object)this.backgroundColor, (Object)drawingStyle.backgroundColor)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/intellij/datavis/r/inlays/components/HistogramSlider$HistogramPanel;", "Ljavax/swing/JPanel;", "frequencies", "", "", "drawingStyle", "Lorg/intellij/datavis/r/inlays/components/HistogramSlider$DrawingStyle;", "selectedIndices", "Lkotlin/ranges/IntRange;", "(Ljava/util/List;Lorg/intellij/datavis/r/inlays/components/HistogramSlider$DrawingStyle;Lkotlin/ranges/IntRange;)V", "getSelectedIndices", "()Lkotlin/ranges/IntRange;", "setSelectedIndices", "(Lkotlin/ranges/IntRange;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.notebooks.visualization"})
    private static final class HistogramPanel
    extends JPanel {
        private final List<Double> frequencies;
        private final DrawingStyle drawingStyle;
        @Nullable
        private IntRange selectedIndices;

        /*
         * WARNING - void declaration
         */
        @Override
        protected void paintComponent(@NotNull Graphics g) {
            block2: {
                boolean bl;
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Color color = this.drawingStyle.getBackgroundColor();
                if (color != null) {
                    Color color2 = color;
                    bl2 = false;
                    bl = false;
                    Color color3 = color2;
                    boolean bl3 = false;
                    g.setColor(color3);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                int columnWidth = this.getWidth() / this.frequencies.size();
                g.setColor(this.drawingStyle.getHistogramColor());
                bl2 = false;
                Iterator bl3 = ((Iterable)this.frequencies).iterator();
                while (bl3.hasNext()) {
                    void index;
                    double value = ((Number)bl3.next()).doubleValue();
                    double clamped = RangesKt.coerceIn((double)value, (double)0.0, (double)1.0);
                    int columnHeight = (int)((double)this.getHeight() * clamped);
                    g.fillRect((int)(index * columnWidth), this.getHeight() - columnHeight, columnWidth, columnHeight);
                    ++index;
                }
                IntRange intRange = this.selectedIndices;
                if (intRange == null) break block2;
                IntRange intRange2 = intRange;
                bl = false;
                boolean bl4 = false;
                IntRange indices = intRange2;
                boolean bl5 = false;
                int first = RangesKt.coerceIn((int)indices.getFirst(), (int)0, (int)this.frequencies.size());
                int last = RangesKt.coerceIn((int)indices.getLast(), (int)0, (int)this.frequencies.size());
                int from = first * columnWidth;
                int selectionWidth = (last - first) * columnWidth;
                g.setColor(this.drawingStyle.getSelectionColor());
                g.fillRect(from, 0, selectionWidth, this.getHeight());
            }
        }

        @Nullable
        public final IntRange getSelectedIndices() {
            return this.selectedIndices;
        }

        public final void setSelectedIndices(@Nullable IntRange intRange) {
            this.selectedIndices = intRange;
        }

        public HistogramPanel(@NotNull List<Double> frequencies, @NotNull DrawingStyle drawingStyle, @Nullable IntRange selectedIndices) {
            Intrinsics.checkNotNullParameter(frequencies, (String)"frequencies");
            Intrinsics.checkNotNullParameter((Object)drawingStyle, (String)"drawingStyle");
            this.frequencies = frequencies;
            this.drawingStyle = drawingStyle;
            this.selectedIndices = selectedIndices;
        }

        public /* synthetic */ HistogramPanel(List list, DrawingStyle drawingStyle, IntRange intRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                intRange = null;
            }
            this(list, drawingStyle, intRange);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000f\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/intellij/datavis/r/inlays/components/HistogramSlider$SwitchableNumberField;", "Ljavax/swing/JTextField;", "onValueChanged", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "isActive", "", "newValue", "value", "getValue", "()Ljava/lang/Double;", "setValue", "(Ljava/lang/Double;)V", "silentlyChangeValue", "intellij.notebooks.visualization"})
    private static final class SwitchableNumberField
    extends JTextField {
        private boolean isActive;

        @Nullable
        public final Double getValue() {
            String string = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            return StringsKt.toDoubleOrNull((String)string);
        }

        public final void setValue(@Nullable Double newValue) {
            Double d = newValue;
            this.setText(d != null ? String.valueOf(d) : null);
        }

        public final void silentlyChangeValue(@Nullable Double newValue) {
            if (Intrinsics.areEqual((Double)this.getValue(), (Double)newValue) ^ true) {
                this.isActive = false;
                this.setValue(newValue);
                this.isActive = true;
            }
        }

        public SwitchableNumberField(final @NotNull Function1<? super Double, Unit> onValueChanged) {
            Intrinsics.checkNotNullParameter(onValueChanged, (String)"onValueChanged");
            this.isActive = true;
            this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (isActive) {
                        String string = this.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                        Double newValue = StringsKt.toDoubleOrNull((String)string);
                        onValueChanged.invoke((Object)newValue);
                    }
                }
            });
        }

        public static final /* synthetic */ void access$setActive$p(SwitchableNumberField $this, boolean bl) {
            $this.isActive = bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\nJ\\\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u001a\u0010\u0017\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u0004\u0012\u00020\f0\u0018JK\u0010\u0019\u001a\u00020\f*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020\u001d2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/intellij/datavis/r/inlays/components/HistogramSlider$Companion;", "", "()V", "DEFAULT_DRAWING_STYLE", "Lorg/intellij/datavis/r/inlays/components/HistogramSlider$DrawingStyle;", "makeRange", "Lkotlin/ranges/ClosedRange;", "", "from", "to", "(Ljava/lang/Double;Ljava/lang/Double;)Lkotlin/ranges/ClosedRange;", "show", "", "owner", "Ljavax/swing/JComponent;", "point", "Ljava/awt/Point;", "preferredSize", "Ljava/awt/Dimension;", "histogram", "Lorg/intellij/datavis/r/inlays/components/HistogramSlider$Histogram;", "selectedValues", "drawingStyle", "onUserInput", "Lkotlin/Function1;", "addWithConstraints", "Ljavax/swing/JPanel;", "component", "x", "", "y", "width", "xWeight", "yWeight", "(Ljavax/swing/JPanel;Ljavax/swing/JComponent;IIILjava/lang/Double;Ljava/lang/Double;)V", "intellij.notebooks.visualization"})
    public static final class Companion {
        public final void show(@NotNull JComponent owner, @NotNull Point point, @NotNull Dimension preferredSize, @NotNull Histogram histogram, @NotNull ClosedRange<Double> selectedValues, @Nullable DrawingStyle drawingStyle, @NotNull Function1<? super ClosedRange<Double>, Unit> onUserInput) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
            Intrinsics.checkNotNullParameter((Object)histogram, (String)"histogram");
            Intrinsics.checkNotNullParameter(selectedValues, (String)"selectedValues");
            Intrinsics.checkNotNullParameter(onUserInput, (String)"onUserInput");
            HistogramSlider histogramSlider = new HistogramSlider(histogram, drawingStyle, onUserInput);
            boolean bl = false;
            boolean bl2 = false;
            HistogramSlider $this$apply = histogramSlider;
            boolean bl3 = false;
            $this$apply.getComponent().setPreferredSize(preferredSize);
            $this$apply.setSelectionRange(selectedValues);
            HistogramSlider slider = histogramSlider;
            ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(slider.getComponent(), null);
            bl2 = false;
            boolean bl4 = false;
            ComponentPopupBuilder $this$apply2 = componentPopupBuilder;
            boolean bl5 = false;
            $this$apply2.setFocusable(true);
            $this$apply2.setRequestFocus(true);
            ComponentPopupBuilder componentPopupBuilder2 = componentPopupBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder2, (String)"JBPopupFactory.getInstan\u2026equestFocus(true)\n      }");
            ComponentPopupBuilder popupBuilder = componentPopupBuilder2;
            JBPopup jBPopup = popupBuilder.createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"popupBuilder.createPopup()");
            JBPopup popup = jBPopup;
            popup.showInScreenCoordinates((Component)owner, point);
        }

        public static /* synthetic */ void show$default(Companion companion, JComponent jComponent, Point point, Dimension dimension, Histogram histogram, ClosedRange closedRange, DrawingStyle drawingStyle, Function1 function1, int n, Object object) {
            if ((n & 0x20) != 0) {
                drawingStyle = null;
            }
            companion.show(jComponent, point, dimension, histogram, (ClosedRange<Double>)closedRange, drawingStyle, (Function1<? super ClosedRange<Double>, Unit>)function1);
        }

        private final void addWithConstraints(JPanel $this$addWithConstraints, JComponent component, int x, int y, int width, Double xWeight, Double yWeight) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            boolean bl = false;
            boolean bl2 = false;
            GridBagConstraints $this$apply = gridBagConstraints;
            boolean bl3 = false;
            $this$apply.fill = 1;
            $this$apply.insets = (Insets)JBUI.insets((int)(2 * width));
            $this$apply.gridx = x;
            $this$apply.gridy = y;
            $this$apply.gridwidth = width;
            if (xWeight != null) {
                $this$apply.weightx = xWeight;
            }
            if (yWeight != null) {
                $this$apply.weighty = yWeight;
            }
            GridBagConstraints constraints = gridBagConstraints;
            $this$addWithConstraints.add((Component)component, constraints);
        }

        static /* synthetic */ void addWithConstraints$default(Companion companion, JPanel jPanel, JComponent jComponent, int n, int n2, int n3, Double d, Double d2, int n4, Object object) {
            if ((n4 & 8) != 0) {
                n3 = 1;
            }
            if ((n4 & 0x10) != 0) {
                d = null;
            }
            if ((n4 & 0x20) != 0) {
                d2 = null;
            }
            companion.addWithConstraints(jPanel, jComponent, n, n2, n3, d, d2);
        }

        private final ClosedRange<Double> makeRange(Double from, Double to) {
            ClosedFloatingPointRange closedFloatingPointRange;
            Double d = from;
            if (d != null) {
                Double d2 = d;
                boolean bl = false;
                boolean bl2 = false;
                double it = ((Number)d2).doubleValue();
                boolean bl3 = false;
                Double d3 = to;
                if (d3 != null) {
                    Double d4 = d3;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    double it2 = ((Number)d4).doubleValue();
                    boolean bl6 = false;
                    closedFloatingPointRange = from <= to ? RangesKt.rangeTo((double)from, (double)to) : null;
                } else {
                    closedFloatingPointRange = null;
                }
            } else {
                closedFloatingPointRange = null;
            }
            return (ClosedRange)closedFloatingPointRange;
        }

        private Companion() {
        }

        public static final /* synthetic */ ClosedRange access$makeRange(Companion $this, Double from, Double to) {
            return $this.makeRange(from, to);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

