/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharCharHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharCharScatterMap
extends CharCharHashMap {
    public CharCharScatterMap() {
        this(4);
    }

    public CharCharScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharCharScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharCharScatterMap from(char[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharCharScatterMap map2 = new CharCharScatterMap(keys.length);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            map2.put(keys[i2], values[i2]);
        }
        return map2;
    }
}

