/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.languagetool.FragmentWithLanguage;
import org.languagetool.Language;
import org.languagetool.rules.spelling.VagueSpellChecker;

public class LanguageAnnotator {
    private static final int MIN_TOKENS = 4;

    public List<FragmentWithLanguage> detectLanguages(String input2, Language mainLang, List<Language> secondLangs) {
        List<TokenWithLanguages> tokens = this.getTokensWithPotentialLanguages(input2, mainLang, secondLangs);
        List<List<TokenWithLanguages>> tokenRanges = this.getTokenRanges(tokens);
        List<TokenRangeWithLanguage> tokenRangesWithLang = this.getTokenRangesWithLang(tokenRanges, mainLang, secondLangs);
        Language prevLang = mainLang;
        int curPos = 0;
        int fromPos = 0;
        ArrayList<FragmentWithLanguage> result2 = new ArrayList<FragmentWithLanguage>();
        for (TokenRangeWithLanguage tokenRange : tokenRangesWithLang) {
            Language curLang = tokenRange.lang;
            if (tokenRange.tokens.size() == 1 && this.isQuote((String)tokenRange.tokens.get(0))) {
                curLang = prevLang;
            } else if (curLang != prevLang) {
                result2.add(new FragmentWithLanguage(prevLang.getShortCodeWithCountryAndVariant(), input2.substring(fromPos, curPos)));
                fromPos = curPos;
            }
            prevLang = curLang;
            curPos += tokenRange.tokens.stream().mapToInt(String::length).sum();
        }
        result2.add(new FragmentWithLanguage(prevLang.getShortCodeWithCountryAndVariant(), input2.substring(fromPos)));
        return result2;
    }

    List<TokenWithLanguages> getTokensWithPotentialLanguages(String input2, Language mainLang, List<Language> secondLangs) {
        ArrayList<TokenWithLanguages> tokens = new ArrayList<TokenWithLanguages>();
        long t1 = System.nanoTime();
        VagueSpellChecker speller2 = new VagueSpellChecker();
        List<String> mainLangTokens = mainLang.getWordTokenizer().tokenize(input2);
        for (String token : mainLangTokens) {
            if (LanguageAnnotator.isWord(token) && speller2.isValidWord(token, mainLang)) {
                tokens.add(new TokenWithLanguages(token, mainLang));
                continue;
            }
            tokens.add(new TokenWithLanguages(token, new Language[0]));
        }
        for (Language secondLang : secondLangs) {
            int i2 = 0;
            for (TokenWithLanguages token : tokens) {
                if (LanguageAnnotator.isWord(token.token) && speller2.isValidWord(token.token, secondLang)) {
                    ArrayList<Language> langs = new ArrayList<Language>(token.langs);
                    langs.add(secondLang);
                    tokens.set(i2, new TokenWithLanguages(token.token, langs));
                }
                ++i2;
            }
        }
        long t2 = System.nanoTime();
        long runTime = t2 - t1;
        return tokens;
    }

    List<List<TokenWithLanguages>> getTokenRanges(List<TokenWithLanguages> tokens) {
        ArrayList<List<TokenWithLanguages>> result2 = new ArrayList<List<TokenWithLanguages>>();
        ArrayList<TokenWithLanguages> l = new ArrayList<TokenWithLanguages>();
        boolean inQuote = false;
        for (TokenWithLanguages token : tokens) {
            if (this.isQuote(token.token) && !inQuote) {
                if (l.size() > 0) {
                    result2.add(l);
                }
                l = new ArrayList();
                l.add(token);
            } else if (this.isBoundary(token)) {
                l.add(token);
                result2.add(l);
                l = new ArrayList();
            } else {
                l.add(token);
            }
            if (!this.isQuote(token.token)) continue;
            inQuote = !inQuote;
        }
        if (l.size() > 0) {
            result2.add(l);
        }
        return result2;
    }

    List<TokenRangeWithLanguage> getTokenRangesWithLang(List<List<TokenWithLanguages>> tokenRanges, Language mainLang, List<Language> secondLangs) {
        ArrayList<TokenRangeWithLanguage> result2 = new ArrayList<TokenRangeWithLanguage>();
        int i2 = 0;
        Language prevTopLang = null;
        for (List<TokenWithLanguages> tokens : tokenRanges) {
            Language topLang = null;
            boolean allAmbiguous = tokens.stream().allMatch(k -> k.ambiguous());
            if (allAmbiguous) {
                for (int j = i2 + 1; j < tokenRanges.size(); ++j) {
                    List<TokenWithLanguages> nextTokens = tokenRanges.get(j);
                    boolean nextAllAmbiguous = nextTokens.stream().allMatch(k -> k.ambiguous());
                    if (nextAllAmbiguous) continue;
                    topLang = this.getTopLang(mainLang, secondLangs, nextTokens);
                    break;
                }
            }
            if (topLang == null) {
                topLang = tokens.size() < 4 && prevTopLang != null ? prevTopLang : this.getTopLang(mainLang, secondLangs, tokens);
            }
            List<String> tokenList = tokens.stream().map(k -> ((TokenWithLanguages)k).token).collect(Collectors.toList());
            result2.add(new TokenRangeWithLanguage(tokenList, topLang));
            prevTopLang = topLang;
            ++i2;
        }
        return result2;
    }

    private Language getTopLang(Language mainLang, List<Language> secondLangs, List<TokenWithLanguages> tokens) {
        HashMap<Language, Integer> langToCount = new HashMap<Language, Integer>();
        langToCount.put(mainLang, tokens.stream().mapToInt(k -> ((TokenWithLanguages)k).langs.contains(mainLang) ? 1 : 0).sum());
        for (Language lang : secondLangs) {
            int langCount = tokens.stream().mapToInt(k -> ((TokenWithLanguages)k).langs.contains(lang) ? 1 : 0).sum();
            langToCount.put(lang, langCount);
        }
        int max = 0;
        Language topLang = mainLang;
        for (Map.Entry entry : langToCount.entrySet()) {
            if ((Integer)entry.getValue() <= max) continue;
            topLang = (Language)entry.getKey();
            max = (Integer)entry.getValue();
        }
        return topLang;
    }

    private boolean isBoundary(TokenWithLanguages token) {
        return token.token.matches("[.?!;:\"\u201e\u201c\u00bb\u00ab()\\[\\]\n]");
    }

    private boolean isQuote(String token) {
        return token.matches("[\"\u201e\u201c\u201d\u00bb\u00ab]");
    }

    private static boolean isWord(String s) {
        return !s.trim().isEmpty() && s.matches("\\w+");
    }

    static class TokenRangeWithLanguage {
        private final List<String> tokens;
        private final Language lang;

        TokenRangeWithLanguage(List<String> tokens, Language lang) {
            this.tokens = Objects.requireNonNull(tokens);
            this.lang = Objects.requireNonNull(lang);
        }

        public String toString() {
            return this.lang.getShortCodeWithCountryAndVariant() + ": " + this.tokens;
        }
    }

    static class TokenWithLanguages {
        private final String token;
        private final List<Language> langs;

        TokenWithLanguages(String token, Language ... langs) {
            this.token = Objects.requireNonNull(token);
            this.langs = new ArrayList<Language>(Arrays.asList(Objects.requireNonNull(langs)));
        }

        TokenWithLanguages(String token, List<Language> langs) {
            this.token = Objects.requireNonNull(token);
            this.langs = Objects.requireNonNull(langs);
        }

        boolean ambiguous() {
            return this.langs.size() != 1;
        }

        public String toString() {
            if (LanguageAnnotator.isWord(this.token)) {
                return this.token + "/" + this.langs.stream().map(k -> k.getShortCodeWithCountryAndVariant()).collect(Collectors.joining("/"));
            }
            return this.token;
        }

        String getToken() {
            return this.token;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TokenWithLanguages that = (TokenWithLanguages)o;
            return this.token.equals(that.token) && this.langs.equals(that.langs);
        }

        public int hashCode() {
            return Objects.hash(this.token, this.langs);
        }
    }
}

