/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ngrams;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ConfusionPair;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ngrams.GoogleToken;
import org.languagetool.rules.ngrams.LanguageModelUtils;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public abstract class ConfusionProbabilityRule
extends Rule {
    public static final String RULE_ID = "CONFUSION_RULE";
    public static final float MIN_COVERAGE = 0.5f;
    private static final double MIN_PROB = 0.0;
    private static final boolean DEBUG = false;
    private static final LoadingCache<PathAndLanguage, Map<String, List<ConfusionPair>>> confSetCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PathAndLanguage, Map<String, List<ConfusionPair>>>(){

        public Map<String, List<ConfusionPair>> load(@NotNull PathAndLanguage pathAndLanguage) throws IOException {
            ConfusionSetLoader confusionSetLoader = new ConfusionSetLoader(pathAndLanguage.lang);
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            try (InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(pathAndLanguage.path);){
                Map<String, List<ConfusionPair>> map2 = confusionSetLoader.loadConfusionPairs(confusionSetStream);
                return map2;
            }
        }
    });
    private final Map<String, List<ConfusionPair>> wordToPairs = new HashMap<String, List<ConfusionPair>>();
    private final LanguageModel lm;
    private final int grams;
    private final Language language;
    private final List<String> exceptions;
    private final List<DisambiguationPatternRule> antiPatterns;

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        this(messages, languageModel, language, grams, Arrays.asList(new String[0]));
    }

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams, List<String> exceptions) {
        this(messages, languageModel, language, grams, exceptions, Collections.emptyList());
    }

    public ConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams, List<String> exceptions, List<List<PatternToken>> antiPatterns) {
        super(messages);
        this.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.NonConformance);
        for (String filename : this.getFilenames()) {
            String path = "/" + language.getShortCode() + "/" + filename;
            this.wordToPairs.putAll((Map)confSetCache.getUnchecked((Object)new PathAndLanguage(path, language)));
        }
        this.lm = Objects.requireNonNull(languageModel);
        this.language = Objects.requireNonNull(language);
        if (grams < 1 || grams > 5) {
            throw new IllegalArgumentException("grams must be between 1 and 5: " + grams);
        }
        this.grams = grams;
        this.exceptions = exceptions;
        this.antiPatterns = ConfusionProbabilityRule.makeAntiPatterns(antiPatterns, language);
    }

    @NotNull
    protected List<String> getFilenames() {
        return Arrays.asList("confusion_sets.txt");
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public int estimateContextForSureMatch() {
        return this.grams;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        String text2 = sentence.getText();
        List<GoogleToken> tokens = GoogleToken.getGoogleTokens(text2, true, LanguageModelUtils.getGoogleStyleWordTokenizer(this.language));
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        if (tokens.size() == 2) {
            return matches.toArray(new RuleMatch[0]);
        }
        int pos = 0;
        boolean realWordBefore = false;
        for (GoogleToken googleToken : tokens) {
            String token = googleToken.token;
            List<ConfusionPair> confusionPairs = this.wordToPairs.get(token);
            boolean uppercase = false;
            if (confusionPairs == null && token.length() > 0 && Character.isUpperCase(token.charAt(0)) && !realWordBefore && this.isRealWord(token)) {
                confusionPairs = this.wordToPairs.get(StringTools.lowercaseFirstChar(token));
                uppercase = true;
            }
            if (this.isRealWord(token)) {
                realWordBefore = true;
            }
            if (confusionPairs != null) {
                for (ConfusionPair confusionPair : confusionPairs) {
                    List<ConfusionString> pairs;
                    boolean isEasilyConfused = confusionPair != null;
                    if (!isEasilyConfused) continue;
                    List<ConfusionString> list = pairs = uppercase ? confusionPair.getUppercaseFirstCharTerms() : confusionPair.getTerms();
                    ConfusionString betterAlternative = this.getBetterAlternativeOrNull(tokens.get(pos), tokens, pairs, confusionPair.getFactor());
                    if (betterAlternative == null || this.isException(text2, googleToken.startPos, googleToken.endPos) || !confusionPair.isBidirectional() && betterAlternative.getString().equals(pairs.get(0).getString())) continue;
                    ConfusionString stringFromText = this.getConfusionString(pairs, tokens.get(pos));
                    String message = this.getMessage(stringFromText, betterAlternative);
                    ArrayList<String> suggestions = new ArrayList<String>(this.getSuggestions(message));
                    if (!suggestions.contains(betterAlternative.getString())) {
                        suggestions.add(betterAlternative.getString());
                    }
                    if (pos > 0 && "_START_".equals(tokens.get((int)(pos - 1)).token) && tokens.size() > pos + 1 && tokens.get((int)(pos + 1)).token != null && !tokens.get((int)(pos + 1)).token.matches("\\w+") || this.isCoveredByAntiPattern(sentence, googleToken) || this.isLocalException(sentence, googleToken)) continue;
                    String term1 = confusionPair.getTerms().get(0).getString();
                    String term2 = confusionPair.getTerms().get(1).getString();
                    String id = this.getId() + "_" + this.cleanId(term1) + "_" + this.cleanId(term2);
                    String desc = this.getDescription(term1, term2);
                    String shortDesc = Tools.i18n(this.messages, "statistics_suggest_short_desc", new Object[0]);
                    RuleMatch match = new RuleMatch(new SpecificIdRule(id, desc, this.messages, this.lm, this.language), sentence, googleToken.startPos, googleToken.endPos, message, shortDesc);
                    match.setSuggestedReplacements(suggestions);
                    matches.add(match);
                }
            }
            ++pos;
        }
        return matches.toArray(new RuleMatch[0]);
    }

    private boolean isCoveredByAntiPattern(AnalyzedSentence sentence, GoogleToken googleToken) {
        AnalyzedTokenReadings[] tmpTokens;
        for (AnalyzedTokenReadings tmpToken : tmpTokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace()) {
            if (!tmpToken.isImmunized() || !this.covers(tmpToken.getStartPos(), tmpToken.getEndPos(), googleToken.startPos, googleToken.endPos)) continue;
            return true;
        }
        return false;
    }

    private String cleanId(String id) {
        return id.toUpperCase().replace("\u00c4", "AE").replace("\u00dc", "UE").replace("\u00d6", "OE");
    }

    private boolean isRealWord(String token) {
        return token.matches("[\\p{L}]+");
    }

    private boolean isLocalException(AnalyzedSentence sentence, GoogleToken googleToken) {
        for (String exception : this.exceptions) {
            int exStartPos = sentence.getText().toLowerCase().indexOf(exception);
            while (exStartPos != -1) {
                int exEndPos = exStartPos + exception.length();
                if (exEndPos == exStartPos) {
                    return false;
                }
                if (this.covers(exStartPos, exEndPos, googleToken.startPos, googleToken.endPos)) {
                    return true;
                }
                exStartPos = sentence.getText().indexOf(exception, exEndPos);
            }
        }
        return false;
    }

    private boolean covers(int exceptionStartPos, int exceptionEndPos, int startPos, int endPos) {
        return exceptionStartPos <= startPos && exceptionEndPos >= endPos;
    }

    private List<String> getSuggestions(String message) {
        Matcher matcher = Pattern.compile("<suggestion>(.*?)</suggestion>").matcher(message);
        ArrayList<String> result2 = new ArrayList<String>();
        while (matcher.find()) {
            result2.add(matcher.group(1));
        }
        return result2;
    }

    protected boolean isException(String sentenceText, int startPos, int endPos) {
        return false;
    }

    @Override
    public String getDescription() {
        return Tools.i18n(this.messages, "statistics_rule_description", new Object[0]);
    }

    private String getDescription(String word1, String word2) {
        return Tools.i18n(this.messages, "statistics_rule_description", word1, word2);
    }

    protected String getMessage(ConfusionString textString, ConfusionString suggestion) {
        if (textString.getDescription() != null && suggestion.getDescription() != null) {
            return Tools.i18n(this.messages, "statistics_suggest1_new", suggestion.getString(), suggestion.getDescription(), textString.getString(), textString.getDescription());
        }
        if (textString.getDescription() != null) {
            return Tools.i18n(this.messages, "statistics_suggest4_new", suggestion.getString(), textString, textString.getDescription());
        }
        if (suggestion.getDescription() != null) {
            return Tools.i18n(this.messages, "statistics_suggest2_new", suggestion.getString(), suggestion.getDescription(), textString.getString());
        }
        return Tools.i18n(this.messages, "statistics_suggest3_new", suggestion.getString(), textString.getString());
    }

    public void setConfusionPair(ConfusionPair pair) {
        this.wordToPairs.clear();
        for (ConfusionString word : pair.getTerms()) {
            this.wordToPairs.put(word.getString(), Collections.singletonList(pair));
        }
    }

    public int getNGrams() {
        return this.grams;
    }

    @Nullable
    private ConfusionString getBetterAlternativeOrNull(GoogleToken token, List<GoogleToken> tokens, List<ConfusionString> confusionSet, long factor) {
        if (confusionSet.size() != 2) {
            throw new RuntimeException("Confusion set must be of size 2: " + confusionSet);
        }
        ConfusionString other = this.getAlternativeTerm(confusionSet, token);
        return this.getBetterAlternativeOrNull(token, tokens, other, factor);
    }

    private ConfusionString getAlternativeTerm(List<ConfusionString> confusionSet, GoogleToken token) {
        for (ConfusionString s : confusionSet) {
            if (s.getString().equals(token.token)) continue;
            return s;
        }
        throw new RuntimeException("No alternative found for: " + token);
    }

    private ConfusionString getConfusionString(List<ConfusionString> confusionSet, GoogleToken token) {
        for (ConfusionString s : confusionSet) {
            if (!s.getString().equalsIgnoreCase(token.token)) continue;
            return s;
        }
        throw new RuntimeException("Not found in set '" + confusionSet + "': " + token);
    }

    private ConfusionString getBetterAlternativeOrNull(GoogleToken token, List<GoogleToken> tokens, ConfusionString otherWord, long factor) {
        double p2;
        double p1;
        String word = token.token;
        if (this.grams == 3) {
            p1 = LanguageModelUtils.get3gramProbabilityFor(this.language, this.lm, token, tokens, word);
            p2 = LanguageModelUtils.get3gramProbabilityFor(this.language, this.lm, token, tokens, otherWord.getString());
        } else if (this.grams == 4) {
            p1 = LanguageModelUtils.get4gramProbabilityFor(this.language, this.lm, token, tokens, word);
            p2 = LanguageModelUtils.get4gramProbabilityFor(this.language, this.lm, token, tokens, otherWord.getString());
        } else {
            throw new RuntimeException("Only 3grams and 4grams are supported");
        }
        this.debug("%.90f <- P(" + word + ") \n", p1);
        this.debug("%.90f <- P(" + otherWord + ")\n", p2);
        return p2 >= 0.0 && p2 > p1 * (double)factor ? otherWord : null;
    }

    private void debug(String message, Object ... vars) {
    }

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns;
    }

    static class SpecificIdRule
    extends ConfusionProbabilityRule {
        private final String id;
        private final String desc;

        SpecificIdRule(String id, String desc, ResourceBundle messages, LanguageModel lm, Language lang) {
            super(messages, lm, lang);
            this.id = Objects.requireNonNull(id);
            this.desc = desc;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    private static class PathAndLanguage {
        private final String path;
        private final Language lang;

        PathAndLanguage(String path, Language lang) {
            this.path = Objects.requireNonNull(path);
            this.lang = Objects.requireNonNull(lang);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathAndLanguage that = (PathAndLanguage)o;
            return this.path.equals(that.path) && this.lang.equals(that.lang);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.lang);
        }
    }
}

